/*
 * Decompiled with CFR 0.152.
 */
package smile.feature;

import java.util.Date;
import smile.data.Attribute;
import smile.data.NominalAttribute;
import smile.data.NumericAttribute;
import smile.feature.FeatureGenerator;

public class DateFeature
implements FeatureGenerator<Date> {
    private Attribute[] attributes;
    private Type[] types;

    public DateFeature(Type[] types) {
        this.types = types;
        this.attributes = new Attribute[types.length];
        block4: for (int i = 0; i < this.attributes.length; ++i) {
            switch (types[i]) {
                case MONTH: {
                    this.attributes[i] = new NominalAttribute(types[i].name(), new String[]{"January", "February", "March", "April", "May", "June", "July", "August", "September", "October", "November", "December"});
                    continue block4;
                }
                case DAY_OF_WEEK: {
                    this.attributes[i] = new NominalAttribute(types[i].name(), new String[]{"Sunday", "Monday", "Tuesday", "Wednesday", "Thursday", "Friday", "Saturday"});
                    continue block4;
                }
                default: {
                    this.attributes[i] = new NumericAttribute(types[i].name());
                }
            }
        }
    }

    @Override
    public Attribute[] attributes() {
        return this.attributes;
    }

    @Override
    public double[] feature(Date date) {
        double[] x = new double[this.types.length];
        block9: for (int i = 0; i < this.types.length; ++i) {
            switch (this.types[i]) {
                case YEAR: {
                    x[i] = 1900 + date.getYear();
                    continue block9;
                }
                case MONTH: {
                    x[i] = date.getMonth();
                    continue block9;
                }
                case DAY_OF_MONTH: {
                    x[i] = date.getDate();
                    continue block9;
                }
                case DAY_OF_WEEK: {
                    x[i] = date.getDay();
                    continue block9;
                }
                case HOURS: {
                    x[i] = date.getHours();
                    continue block9;
                }
                case MINUTES: {
                    x[i] = date.getMinutes();
                    continue block9;
                }
                case SECONDS: {
                    x[i] = date.getSeconds();
                    continue block9;
                }
                default: {
                    throw new IllegalStateException("Unknown date feature type: " + (Object)((Object)this.types[i]));
                }
            }
        }
        return x;
    }

    public static enum Type {
        YEAR,
        MONTH,
        DAY_OF_MONTH,
        DAY_OF_WEEK,
        HOURS,
        MINUTES,
        SECONDS;

    }
}

