/*
 * Decompiled with CFR 0.152.
 */
package smile.demo.util;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class ParameterParser {
    private Map<String, Parameter> parameters;
    private String usage;

    public ParameterParser(String usage) {
        this.usage = usage;
        this.parameters = new HashMap<String, Parameter>();
    }

    public void addParameter(String name, ParameterType type) {
        this.parameters.put(name, new Parameter(name, type));
    }

    public void addParameter(String name, ParameterType type, boolean mandatory) {
        this.parameters.put(name, new Parameter(name, type, mandatory));
    }

    public void addParameter(String name, ParameterType type, String defaultValue) {
        this.parameters.put(name, new Parameter(name, type, defaultValue));
    }

    public String get(String name) {
        Parameter param = this.parameters.get(name);
        if (param != null) {
            return param.value;
        }
        return null;
    }

    private List<String> filterMonadics(String[] args) {
        ArrayList<String> filteredArgs = new ArrayList<String>();
        for (String arg : args) {
            filteredArgs.add(arg);
            Parameter param = this.parameters.get(arg);
            if (param == null || param.paramType != ParameterType.MONADIC) continue;
            filteredArgs.add("1");
        }
        return filteredArgs;
    }

    public List<String> parse(String[] args) {
        Parameter param;
        ArrayList<String> extras = new ArrayList<String>();
        List<String> filteredArgs = this.filterMonadics(args);
        for (int i = 0; i < filteredArgs.size(); ++i) {
            String key = filteredArgs.get(i);
            if (key.equalsIgnoreCase("-h") || key.equalsIgnoreCase("-help")) {
                System.out.println(this.usage);
                System.exit(0);
            }
            if (this.parameters.containsKey(key)) {
                param = this.parameters.get(key);
                param.value = filteredArgs.get(i + 1);
                switch (param.paramType) {
                    case INTEGER: {
                        try {
                            Integer.parseInt(param.value);
                        }
                        catch (Exception ex) {
                            System.err.println("Invalid parameter " + param.name + ' ' + param.value);
                            System.err.println(this.usage);
                            System.exit(1);
                        }
                        break;
                    }
                    case FLOAT: {
                        try {
                            Double.parseDouble(param.value);
                        }
                        catch (Exception ex) {
                            System.err.println("Invalid parameter " + param.name + ' ' + param.value);
                            System.err.println(this.usage);
                            System.exit(1);
                        }
                        break;
                    }
                }
                ++i;
                continue;
            }
            extras.add(key);
        }
        for (String key : this.parameters.keySet()) {
            param = this.parameters.get(key);
            if (!param.mandatory || param.value != null) continue;
            System.err.println("Missing mandatory parameter: " + key);
            System.err.println(this.usage);
            System.exit(1);
        }
        return extras;
    }

    private class Parameter {
        String name;
        String value;
        ParameterType paramType;
        boolean mandatory;

        Parameter(String name, ParameterType paraType) {
            this(name, paraType, false);
        }

        Parameter(String name, ParameterType type, boolean mandatory) {
            this.name = name;
            this.paramType = type;
            this.mandatory = mandatory;
        }

        Parameter(String name, ParameterType paraType, String defaultValue) {
            this(name, paraType, false);
            this.value = defaultValue;
        }
    }

    public static enum ParameterType {
        MONADIC,
        INTEGER,
        FLOAT,
        STRING;

    }
}

