/*
 * Decompiled with CFR 0.152.
 */
package smile.demo.stat.distribution;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.util.Hashtable;
import javax.swing.BorderFactory;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import smile.plot.BarPlot;
import smile.plot.Histogram;
import smile.plot.PlotCanvas;
import smile.stat.distribution.NegativeBinomialDistribution;

public class NegativeBinomialDistributionDemo
extends JPanel
implements ChangeListener {
    private JPanel optionPane;
    private JPanel canvas;
    private PlotCanvas pdf;
    private PlotCanvas cdf;
    private PlotCanvas histogram;
    private JSlider nSlider;
    private JSlider probSlider;
    private int n = 10;
    private double prob = 0.3;

    public NegativeBinomialDistributionDemo() {
        super(new BorderLayout());
        Hashtable<Integer, JLabel> nLabelTable = new Hashtable<Integer, JLabel>();
        nLabelTable.put(1, new JLabel(String.valueOf(1)));
        for (int i = 10; i <= 50; i += 10) {
            nLabelTable.put(new Integer(i), new JLabel(String.valueOf(i)));
        }
        this.nSlider = new JSlider(1, 50, this.n);
        this.nSlider.addChangeListener(this);
        this.nSlider.setLabelTable(nLabelTable);
        this.nSlider.setMajorTickSpacing(10);
        this.nSlider.setMinorTickSpacing(2);
        this.nSlider.setPaintTicks(true);
        this.nSlider.setPaintLabels(true);
        Hashtable<Integer, JLabel> probLabelTable = new Hashtable<Integer, JLabel>();
        for (int i = 1; i < 10; i += 2) {
            probLabelTable.put(new Integer(i), new JLabel(String.valueOf((double)i / 10.0)));
        }
        this.probSlider = new JSlider(1, 9, (int)Math.round(this.prob * 10.0));
        this.probSlider.addChangeListener(this);
        this.probSlider.setLabelTable(probLabelTable);
        this.probSlider.setMajorTickSpacing(5);
        this.probSlider.setMinorTickSpacing(1);
        this.probSlider.setPaintTicks(true);
        this.probSlider.setPaintLabels(true);
        this.optionPane = new JPanel(new FlowLayout(0));
        this.optionPane.setBorder(BorderFactory.createRaisedBevelBorder());
        this.optionPane.add(new JLabel("N:"));
        this.optionPane.add(this.nSlider);
        this.optionPane.add(new JLabel("Probability:"));
        this.optionPane.add(this.probSlider);
        this.add((Component)this.optionPane, "North");
        this.canvas = new JPanel(new GridLayout(1, 3));
        this.add((Component)this.canvas, "Center");
        NegativeBinomialDistribution dist = new NegativeBinomialDistribution(this.n, this.prob);
        double[][] p = new double[50][2];
        double[][] q = new double[50][2];
        for (int i = 0; i < p.length; ++i) {
            p[i][0] = i;
            p[i][1] = dist.p(p[i][0]);
            q[i][0] = i;
            q[i][1] = dist.cdf(p[i][0]);
        }
        double[] lowerBound = new double[]{0.0, 0.0};
        double[] upperBound = new double[]{50.0, 1.0};
        this.pdf = new PlotCanvas(lowerBound, upperBound);
        this.pdf.add(new BarPlot(p));
        this.pdf.setTitle("PDF");
        this.canvas.add(this.pdf);
        this.cdf = new PlotCanvas(lowerBound, upperBound);
        this.cdf.staircase(q, Color.BLACK);
        this.cdf.setTitle("CDF");
        this.canvas.add(this.cdf);
        int[] data = new int[500];
        for (int i = 0; i < data.length; ++i) {
            data[i] = (int)dist.rand();
        }
        this.histogram = Histogram.plot(data, 20);
        this.histogram.setTitle("Histogram");
        this.canvas.add(this.histogram);
    }

    @Override
    public void stateChanged(ChangeEvent e) {
        if (e.getSource() == this.probSlider || e.getSource() == this.nSlider) {
            this.n = this.nSlider.getValue();
            if (this.n == 0) {
                this.n = 1;
            }
            this.prob = (double)this.probSlider.getValue() / 10.0;
            if (this.prob == 0.0) {
                this.prob = 0.01;
            }
            NegativeBinomialDistribution dist = new NegativeBinomialDistribution(this.n, this.prob);
            double[][] p = new double[50][2];
            double[][] q = new double[50][2];
            for (int i = 0; i < p.length; ++i) {
                p[i][0] = i;
                p[i][1] = dist.p(p[i][0]);
                q[i][0] = i;
                q[i][1] = dist.cdf(p[i][0]);
            }
            this.pdf.clear();
            this.pdf.add(new BarPlot(p));
            this.cdf.clear();
            this.cdf.staircase(q, Color.BLACK);
            int[] data = new int[500];
            for (int i = 0; i < data.length; ++i) {
                data[i] = (int)dist.rand();
            }
            this.histogram.clear();
            this.histogram.histogram(data, 20, Color.BLUE);
        }
    }

    @Override
    public String toString() {
        return "Negative Binomial";
    }

    public static void main(String[] args) {
        JFrame frame = new JFrame("Negative Binomial Distribution");
        frame.setDefaultCloseOperation(3);
        frame.setLocationRelativeTo(null);
        frame.getContentPane().add(new NegativeBinomialDistributionDemo());
        frame.setVisible(true);
    }
}

