/*
 * Decompiled with CFR 0.152.
 */
package smile.demo.projection;

import java.awt.Dimension;
import java.awt.GridLayout;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import smile.demo.projection.ProjectionDemo;
import smile.math.Math;
import smile.plot.Palette;
import smile.plot.PlotCanvas;
import smile.projection.PCA;

public class PCADemo
extends ProjectionDemo {
    JComboBox<String> corBox = new JComboBox();

    public PCADemo() {
        this.corBox.addItem("Covariance");
        this.corBox.addItem("Correlation");
        this.corBox.setSelectedIndex(0);
        this.optionPane.add(new JLabel("Scaling:"));
        this.optionPane.add(this.corBox);
    }

    @Override
    public JComponent learn() {
        double[][] data = (double[][])dataset[datasetIndex].toArray((E[])new double[dataset[datasetIndex].size()][]);
        String[] names = dataset[datasetIndex].toArray(new String[dataset[datasetIndex].size()]);
        if (names[0] == null) {
            names = null;
        }
        boolean cor = this.corBox.getSelectedIndex() != 0;
        long clock = System.currentTimeMillis();
        PCA pca = new PCA(data, cor);
        System.out.format("Learn PCA from %d samples in %dms\n", data.length, System.currentTimeMillis() - clock);
        JPanel pane = new JPanel(new GridLayout(1, 2));
        PlotCanvas scree = PlotCanvas.screeplot(pca);
        scree.setTitle("Variance");
        pane.add(scree);
        pca.setProjection(3);
        double[][] y = pca.project(data);
        PlotCanvas plot = new PlotCanvas(Math.colMin(y), Math.colMax(y));
        if (names != null) {
            plot.points(y, names);
        } else if (dataset[datasetIndex].responseAttribute() != null) {
            int[] labels = dataset[datasetIndex].toArray(new int[dataset[datasetIndex].size()]);
            for (int i = 0; i < y.length; ++i) {
                plot.point(this.pointLegend, Palette.COLORS[labels[i]], y[i]);
            }
        } else {
            plot.points(y, this.pointLegend);
        }
        plot.setTitle("Scatter Plot");
        pane.add(plot);
        return pane;
    }

    @Override
    public String toString() {
        return "Principal Component Analysis";
    }

    public static void main(String[] argv) {
        PCADemo demo = new PCADemo();
        JFrame f = new JFrame("Principal Component Analysis");
        f.setSize(new Dimension(1000, 1000));
        f.setLocationRelativeTo(null);
        f.setDefaultCloseOperation(3);
        f.getContentPane().add(demo);
        f.setVisible(true);
    }
}

