/*
 * Decompiled with CFR 0.152.
 */
package smile.demo.plot;

import java.awt.GridLayout;
import javax.swing.JFrame;
import javax.swing.JPanel;
import smile.plot.BoxPlot;
import smile.plot.PlotCanvas;

public class BoxPlotDemo
extends JPanel {
    public BoxPlotDemo() {
        super(new GridLayout(1, 2));
        double[][] data = new double[5][100];
        for (int i = 0; i < data.length; ++i) {
            for (int j = 0; j < data[i].length; ++j) {
                double y;
                double x;
                double r;
                while ((r = (x = 2.0 * (Math.random() - 0.5)) * x + (y = 2.0 * (Math.random() - 0.5)) * y) >= 1.0) {
                }
                double z = Math.sqrt(-2.0 * Math.log(r) / r);
                data[i][j] = new Double(x * z);
            }
        }
        PlotCanvas canvas = BoxPlot.plot(data, new String[]{"Group A", "Group B", "Big Group C", "Group D", "Very Long Group E"});
        canvas.setTitle("Box Plot A");
        canvas.getAxis(0).setRotation(-1.5707963267948966);
        this.add(canvas);
        canvas = BoxPlot.plot(data[0]);
        canvas.setTitle("Box Plot B");
        this.add(canvas);
    }

    @Override
    public String toString() {
        return "Box Plot";
    }

    public static void main(String[] args) {
        JFrame frame = new JFrame("Box Plot");
        frame.setDefaultCloseOperation(3);
        frame.setLocationRelativeTo(null);
        frame.getContentPane().add(new BoxPlotDemo());
        frame.setVisible(true);
    }
}

