/*
 * Decompiled with CFR 0.152.
 */
package smile.demo.interpolation;

import java.awt.Color;
import java.awt.GridLayout;
import java.util.ArrayList;
import javax.swing.JFrame;
import javax.swing.JPanel;
import smile.interpolation.BicubicInterpolation;
import smile.interpolation.KrigingInterpolation;
import smile.interpolation.RBFInterpolation;
import smile.interpolation.ShepardInterpolation;
import smile.math.rbf.GaussianRadialBasis;
import smile.plot.Heatmap;
import smile.plot.Palette;
import smile.plot.PlotCanvas;

public class ScatterDataInterpolationDemo
extends JPanel {
    public ScatterDataInterpolationDemo() {
        super(new GridLayout(2, 3));
        this.setBackground(Color.WHITE);
        double[] x1 = new double[]{0.0, 1.0, 2.0, 3.0};
        double[] x2 = new double[]{0.0, 1.0, 2.0, 3.0};
        double[][] y = new double[][]{{1.0, 2.0, 4.0, 1.0}, {6.0, 3.0, 5.0, 2.0}, {4.0, 2.0, 1.0, 5.0}, {5.0, 4.0, 2.0, 3.0}};
        BicubicInterpolation bicubic = new BicubicInterpolation(x1, x2, y);
        double[][] yy = new double[26][26];
        for (int i = 0; i <= 25; ++i) {
            for (int j = 0; j <= 25; ++j) {
                yy[i][j] = bicubic.interpolate((double)i * 0.12, (double)j * 0.12);
            }
        }
        PlotCanvas canvas = Heatmap.plot(yy, Palette.jet(256));
        canvas.setTitle("Original");
        this.add(canvas);
        double[][] ww = new double[26][26];
        ArrayList<double[]> xx = new ArrayList<double[]>();
        ArrayList<Double> zz = new ArrayList<Double>();
        for (int i = 0; i <= 25; ++i) {
            for (int j = 0; j <= 25; ++j) {
                ww[i][j] = Math.random() < 0.2 ? Double.NaN : yy[i][j];
                if (Double.isNaN(ww[i][j])) continue;
                double[] pos = new double[]{(double)j * 0.12, (double)i * 0.12};
                xx.add(pos);
                zz.add(ww[i][j]);
            }
        }
        double[][] p = new double[xx.size()][];
        double[] q = new double[xx.size()];
        for (int i = 0; i < p.length; ++i) {
            p[i] = (double[])xx.get(i);
            q[i] = (Double)zz.get(i);
        }
        canvas = Heatmap.plot(ww, Palette.jet(256));
        canvas.setTitle("Missing Values");
        this.add(canvas);
        KrigingInterpolation kriging = new KrigingInterpolation(p, q);
        double[][] uu = new double[26][26];
        for (int i = 0; i <= 25; ++i) {
            for (int j = 0; j <= 25; ++j) {
                uu[i][j] = Double.isNaN(ww[i][j]) ? kriging.interpolate((double)j * 0.12, (double)i * 0.12) : ww[i][j];
            }
        }
        canvas = Heatmap.plot(uu, Palette.jet(256));
        canvas.setTitle("Kriging");
        this.add(canvas);
        RBFInterpolation rbf = new RBFInterpolation(p, q, new GaussianRadialBasis(0.25));
        double[][] vv = new double[26][26];
        for (int i = 0; i <= 25; ++i) {
            for (int j = 0; j <= 25; ++j) {
                vv[i][j] = Double.isNaN(ww[i][j]) ? rbf.interpolate((double)j * 0.12, (double)i * 0.12) : ww[i][j];
            }
        }
        canvas = Heatmap.plot(vv, Palette.jet(256));
        canvas.setTitle("RBF");
        this.add(canvas);
        ShepardInterpolation shepard = new ShepardInterpolation(p, q, 3.0);
        double[][] rr = new double[26][26];
        for (int i = 0; i <= 25; ++i) {
            for (int j = 0; j <= 25; ++j) {
                rr[i][j] = Double.isNaN(ww[i][j]) ? shepard.interpolate((double)j * 0.12, (double)i * 0.12) : ww[i][j];
            }
        }
        canvas = Heatmap.plot(rr, Palette.jet(256));
        canvas.setTitle("Shepard");
        this.add(canvas);
    }

    @Override
    public String toString() {
        return "Scatter Data";
    }

    public static void main(String[] args) {
        JFrame frame = new JFrame("Scatter Data Interpolation");
        frame.setDefaultCloseOperation(3);
        frame.setLocationRelativeTo(null);
        frame.getContentPane().add(new ScatterDataInterpolationDemo());
        frame.setVisible(true);
    }
}

