/*
 * Decompiled with CFR 0.152.
 */
package smile.demo.clustering;

import java.awt.Dimension;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JTextField;
import smile.clustering.MEC;
import smile.demo.clustering.ClusteringDemo;
import smile.math.distance.EuclideanDistance;
import smile.plot.Palette;
import smile.plot.PlotCanvas;
import smile.plot.ScatterPlot;

public class MECDemo
extends ClusteringDemo {
    JTextField rangeField = new JTextField(Double.toString(this.range), 5);
    double range = 10.0;

    public MECDemo() {
        this.optionPane.add(new JLabel("Range:"));
        this.optionPane.add(this.rangeField);
    }

    @Override
    public JComponent learn() {
        try {
            this.range = Double.parseDouble(this.rangeField.getText().trim());
            if (this.range <= 0.0) {
                JOptionPane.showMessageDialog(this, "Invalid Range: " + this.range, "Error", 0);
                return null;
            }
        }
        catch (Exception e) {
            JOptionPane.showMessageDialog(this, "Invalid range: " + this.rangeField.getText(), "Error", 0);
            return null;
        }
        long clock = System.currentTimeMillis();
        MEC<double[]> mec = new MEC<double[]>((T[])dataset[datasetIndex], new EuclideanDistance(), clusterNumber, this.range);
        System.out.format("MEC clusterings %d samples in %dms\n", dataset[datasetIndex].length, System.currentTimeMillis() - clock);
        PlotCanvas plot = ScatterPlot.plot(dataset[datasetIndex], this.pointLegend);
        for (int k = 0; k < mec.getNumClusters(); ++k) {
            double[][] cluster = new double[mec.getClusterSize()[k]][];
            int j = 0;
            for (int i = 0; i < dataset[datasetIndex].length; ++i) {
                if (mec.getClusterLabel()[i] != k) continue;
                cluster[j++] = dataset[datasetIndex][i];
            }
            plot.points((double[][])cluster, this.pointLegend, Palette.COLORS[k % Palette.COLORS.length]);
        }
        return plot;
    }

    @Override
    public String toString() {
        return "Minimum Entropy Clustering";
    }

    public static void main(String[] argv) {
        MECDemo demo = new MECDemo();
        JFrame f = new JFrame("MEC");
        f.setSize(new Dimension(1000, 1000));
        f.setLocationRelativeTo(null);
        f.setDefaultCloseOperation(3);
        f.getContentPane().add(demo);
        f.setVisible(true);
    }
}

