/*
 * Decompiled with CFR 0.152.
 */
package smile.demo.clustering;

import java.awt.Dimension;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JTextField;
import smile.clustering.DeterministicAnnealing;
import smile.demo.clustering.ClusteringDemo;
import smile.plot.Palette;
import smile.plot.PlotCanvas;
import smile.plot.ScatterPlot;

public class DeterministicAnnealingDemo
extends ClusteringDemo {
    JTextField alphaField = new JTextField(Double.toString(this.alpha), 5);
    double alpha = 0.9;

    public DeterministicAnnealingDemo() {
        this.optionPane.add(new JLabel("alpha:"));
        this.optionPane.add(this.alphaField);
    }

    @Override
    public JComponent learn() {
        try {
            this.alpha = Double.parseDouble(this.alphaField.getText().trim());
            if (this.alpha <= 0.0 || this.alpha >= 1.0) {
                JOptionPane.showMessageDialog(this, "Invalid alpha: " + this.alpha, "Error", 0);
                return null;
            }
        }
        catch (Exception e) {
            JOptionPane.showMessageDialog(this, "Invalid K: " + this.alphaField.getText(), "Error", 0);
            return null;
        }
        long clock = System.currentTimeMillis();
        DeterministicAnnealing annealing = new DeterministicAnnealing(dataset[datasetIndex], clusterNumber, this.alpha);
        System.out.format("Deterministic Annealing clusterings %d samples in %dms\n", dataset[datasetIndex].length, System.currentTimeMillis() - clock);
        PlotCanvas plot = ScatterPlot.plot(annealing.centroids(), '@');
        for (int k = 0; k < clusterNumber; ++k) {
            if (annealing.getClusterSize()[k] <= 0) continue;
            double[][] cluster = new double[annealing.getClusterSize()[k]][];
            int j = 0;
            for (int i = 0; i < dataset[datasetIndex].length; ++i) {
                if (annealing.getClusterLabel()[i] != k) continue;
                cluster[j++] = dataset[datasetIndex][i];
            }
            plot.points((double[][])cluster, this.pointLegend, Palette.COLORS[k % Palette.COLORS.length]);
        }
        plot.points(annealing.centroids(), '@');
        return plot;
    }

    @Override
    public String toString() {
        return "Deterministic Annealing";
    }

    public static void main(String[] argv) {
        DeterministicAnnealingDemo demo = new DeterministicAnnealingDemo();
        JFrame f = new JFrame("Deterministic Annealing");
        f.setSize(new Dimension(1000, 1000));
        f.setLocationRelativeTo(null);
        f.setDefaultCloseOperation(3);
        f.getContentPane().add(demo);
        f.setVisible(true);
    }
}

