/*
 * Decompiled with CFR 0.152.
 */
package smile.demo.clustering;

import java.awt.Dimension;
import java.awt.GridLayout;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import smile.clustering.DENCLUE;
import smile.demo.clustering.ClusteringDemo;
import smile.plot.Palette;
import smile.plot.PlotCanvas;
import smile.plot.ScatterPlot;

public class DENCLUEDemo
extends ClusteringDemo {
    JTextField kField;
    JTextField sigmaField;
    int k = 20;
    double sigma = 1.0;

    public DENCLUEDemo() {
        this.optionPane.remove(this.optionPane.getComponentCount() - 1);
        this.kField = new JTextField(Integer.toString(this.k), 5);
        this.optionPane.add(this.kField);
        this.sigmaField = new JTextField(Double.toString(this.sigma), 5);
        this.optionPane.add(new JLabel("Sigma:"));
        this.optionPane.add(this.sigmaField);
    }

    @Override
    public JComponent learn() {
        try {
            this.k = Integer.parseInt(this.kField.getText().trim());
            if (this.k < 1) {
                JOptionPane.showMessageDialog(this, "Invalid K: " + this.k, "Error", 0);
                return null;
            }
        }
        catch (Exception e) {
            JOptionPane.showMessageDialog(this, "Invalid K: " + this.kField.getText(), "Error", 0);
            return null;
        }
        try {
            this.sigma = Double.parseDouble(this.sigmaField.getText().trim());
            if (this.sigma <= 0.0) {
                JOptionPane.showMessageDialog(this, "Invalid Sigma: " + this.sigma, "Error", 0);
                return null;
            }
        }
        catch (Exception e) {
            JOptionPane.showMessageDialog(this, "Invalid Sigma: " + this.sigmaField.getText(), "Error", 0);
            return null;
        }
        long clock = System.currentTimeMillis();
        DENCLUE denclue = new DENCLUE(dataset[datasetIndex], this.sigma, this.k);
        System.out.format("DENCLUE clusterings %d samples in %dms\n", dataset[datasetIndex].length, System.currentTimeMillis() - clock);
        JPanel pane = new JPanel(new GridLayout(1, 2));
        PlotCanvas plot = ScatterPlot.plot(dataset[datasetIndex], this.pointLegend);
        for (int l = 0; l < denclue.getNumClusters(); ++l) {
            double[][] cluster = new double[denclue.getClusterSize()[l]][];
            int j = 0;
            for (int i = 0; i < dataset[datasetIndex].length; ++i) {
                if (denclue.getClusterLabel()[i] != l) continue;
                cluster[j++] = dataset[datasetIndex][i];
            }
            plot.points((double[][])cluster, this.pointLegend, Palette.COLORS[l % Palette.COLORS.length]);
        }
        plot.points(denclue.getDensityAttractors(), '@');
        pane.add(plot);
        return pane;
    }

    @Override
    public String toString() {
        return "DENCLUE";
    }

    public static void main(String[] argv) {
        DENCLUEDemo demo = new DENCLUEDemo();
        JFrame f = new JFrame("DENCLUE");
        f.setSize(new Dimension(1000, 1000));
        f.setLocationRelativeTo(null);
        f.setDefaultCloseOperation(3);
        f.getContentPane().add(demo);
        f.setVisible(true);
    }
}

