/*
 * Decompiled with CFR 0.152.
 */
package smile.demo.classification;

import java.awt.Dimension;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JTextField;
import smile.classification.SVM;
import smile.demo.classification.ClassificationDemo;
import smile.math.kernel.GaussianKernel;

public class SVMDemo
extends ClassificationDemo {
    private double gamma = 1.0;
    private JTextField gammaField = new JTextField(Double.toString(this.gamma), 5);
    private double C = 1.0;
    private JTextField cField;

    public SVMDemo() {
        this.optionPane.add(new JLabel("\u02e0:"));
        this.optionPane.add(this.gammaField);
        this.cField = new JTextField(Double.toString(this.C), 5);
        this.optionPane.add(new JLabel("C:"));
        this.optionPane.add(this.cField);
    }

    @Override
    public double[][] learn(double[] x, double[] y) {
        try {
            this.gamma = Double.parseDouble(this.gammaField.getText().trim());
            if (this.gamma <= 0.0) {
                JOptionPane.showMessageDialog(this, "Invalid \u02e0: " + this.gamma, "Error", 0);
                return null;
            }
        }
        catch (Exception ex) {
            JOptionPane.showMessageDialog(this, "Invalid \u02e0: " + this.gammaField.getText(), "Error", 0);
            return null;
        }
        try {
            this.C = Double.parseDouble(this.cField.getText().trim());
            if (this.C < 0.0) {
                JOptionPane.showMessageDialog(this, "Invalid C: " + this.C, "Error", 0);
                return null;
            }
        }
        catch (Exception ex) {
            JOptionPane.showMessageDialog(this, "Invalid C: " + this.cField.getText(), "Error", 0);
            return null;
        }
        double[][] data = (double[][])dataset[datasetIndex].toArray((E[])new double[dataset[datasetIndex].size()][]);
        int[] label = dataset[datasetIndex].toArray(new int[dataset[datasetIndex].size()]);
        SVM<double[]> svm = new SVM<double[]>(new GaussianKernel(this.gamma), this.C);
        svm.learn((T[])data, label);
        svm.finish();
        for (int i = 0; i < label.length; ++i) {
            label[i] = svm.predict(data[i]);
        }
        double trainError = this.error(label, label);
        System.out.format("training error = %.2f%%\n", 100.0 * trainError);
        double[][] z = new double[y.length][x.length];
        for (int i = 0; i < y.length; ++i) {
            for (int j = 0; j < x.length; ++j) {
                double[] p = new double[]{x[j], y[i]};
                z[i][j] = svm.predict(p);
            }
        }
        return z;
    }

    @Override
    public String toString() {
        return "Support Vector Machines";
    }

    public static void main(String[] argv) {
        SVMDemo demo = new SVMDemo();
        JFrame f = new JFrame("Support Vector Machines");
        f.setSize(new Dimension(1000, 1000));
        f.setLocationRelativeTo(null);
        f.setDefaultCloseOperation(3);
        f.getContentPane().add(demo);
        f.setVisible(true);
    }
}

