/*
 * Decompiled with CFR 0.152.
 */
package smile.clustering;

import java.util.Arrays;
import smile.clustering.Clustering;
import smile.clustering.ClusteringDistance;
import smile.math.Math;
import smile.math.distance.Distance;

public abstract class PartitionClustering<T>
implements Clustering<T> {
    protected int k;
    protected int[] y;
    protected int[] size;

    public int getNumClusters() {
        return this.k;
    }

    public int[] getClusterLabel() {
        return this.y;
    }

    public int[] getClusterSize() {
        return this.size;
    }

    static double squaredDistance(double[] x, double[] y) {
        int n = x.length;
        int m = 0;
        double dist = 0.0;
        for (int i = 0; i < n; ++i) {
            if (Double.isNaN(x[i]) || Double.isNaN(y[i])) continue;
            ++m;
            double d = x[i] - y[i];
            dist += d * d;
        }
        dist = m == 0 ? Double.MAX_VALUE : (double)n * dist / (double)m;
        return dist;
    }

    public static int[] seed(double[][] data, int k, ClusteringDistance distance) {
        int i;
        int n = data.length;
        int[] y = new int[n];
        double[] centroid = data[Math.randomInt(n)];
        double[] d = new double[n];
        for (i = 0; i < n; ++i) {
            d[i] = Double.MAX_VALUE;
        }
        for (int j = 1; j < k; ++j) {
            int index;
            for (int i2 = 0; i2 < n; ++i2) {
                double dist = 0.0;
                switch (distance) {
                    case EUCLIDEAN: {
                        dist = Math.squaredDistance(data[i2], centroid);
                        break;
                    }
                    case EUCLIDEAN_MISSING_VALUES: {
                        dist = PartitionClustering.squaredDistance(data[i2], centroid);
                        break;
                    }
                    case JENSEN_SHANNON_DIVERGENCE: {
                        dist = Math.JensenShannonDivergence(data[i2], centroid);
                    }
                }
                if (!(dist < d[i2])) continue;
                d[i2] = dist;
                y[i2] = j - 1;
            }
            double cutoff = Math.random() * Math.sum(d);
            double cost = 0.0;
            for (index = 0; index < n && !((cost += d[index]) >= cutoff); ++index) {
            }
            centroid = data[index];
        }
        for (i = 0; i < n; ++i) {
            double dist = 0.0;
            switch (distance) {
                case EUCLIDEAN: {
                    dist = Math.squaredDistance(data[i], centroid);
                    break;
                }
                case EUCLIDEAN_MISSING_VALUES: {
                    dist = PartitionClustering.squaredDistance(data[i], centroid);
                    break;
                }
                case JENSEN_SHANNON_DIVERGENCE: {
                    dist = Math.JensenShannonDivergence(data[i], centroid);
                }
            }
            if (!(dist < d[i])) continue;
            d[i] = dist;
            y[i] = k - 1;
        }
        return y;
    }

    public static <T> double seed(Distance<T> distance, T[] data, T[] medoids, int[] y, double[] d) {
        int n = data.length;
        int k = medoids.length;
        T medoid = data[Math.randomInt(n)];
        medoids[0] = medoid;
        Arrays.fill(d, Double.MAX_VALUE);
        for (int j = 1; j < k; ++j) {
            int index;
            for (int i = 0; i < n; ++i) {
                double dist = distance.d(data[i], medoid);
                if (!(dist < d[i])) continue;
                d[i] = dist;
                y[i] = j - 1;
            }
            double cutoff = Math.random() * Math.sum(d);
            double cost = 0.0;
            for (index = 0; index < n && !((cost += d[index]) >= cutoff); ++index) {
            }
            medoid = data[index];
            medoids[j] = medoid;
        }
        for (int i = 0; i < n; ++i) {
            double dist = distance.d(data[i], medoid);
            if (!(dist < d[i])) continue;
            d[i] = dist;
            y[i] = k - 1;
        }
        double distortion = 0.0;
        for (int i = 0; i < n; ++i) {
            distortion += d[i];
        }
        return distortion;
    }
}

