/*
 * Decompiled with CFR 0.152.
 */
package smile.classification;

import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import smile.classification.RBFNetwork;
import smile.data.AttributeDataset;
import smile.data.NominalAttribute;
import smile.data.parser.ArffParser;
import smile.data.parser.DelimitedTextParser;
import smile.data.parser.IOUtils;
import smile.math.Math;
import smile.math.distance.EuclideanDistance;
import smile.math.distance.Metric;
import smile.math.rbf.GaussianRadialBasis;
import smile.math.rbf.RadialBasisFunction;
import smile.util.SmileUtils;
import smile.validation.LOOCV;

public class RBFNetworkTest {
    @BeforeClass
    public static void setUpClass() throws Exception {
    }

    @AfterClass
    public static void tearDownClass() throws Exception {
    }

    @Before
    public void setUp() {
    }

    @After
    public void tearDown() {
    }

    @Test
    public void testLearn() {
        System.out.println("learn");
        ArffParser arffParser = new ArffParser();
        arffParser.setResponseIndex(4);
        try {
            AttributeDataset iris = arffParser.parse(IOUtils.getTestDataFile("weka/iris.arff"));
            double[][] x = (double[][])iris.toArray((E[])new double[iris.size()][]);
            int[] y = iris.toArray(new int[iris.size()]);
            int n = x.length;
            LOOCV loocv = new LOOCV(n);
            int error = 0;
            for (int i = 0; i < n; ++i) {
                double[][] centers;
                RadialBasisFunction[] basis;
                int[] trainy;
                double[][] trainx = (double[][])Math.slice(x, loocv.train[i]);
                RBFNetwork<double[]> rbf = new RBFNetwork<double[]>((T[])trainx, trainy = Math.slice(y, loocv.train[i]), (Metric<double[]>)new EuclideanDistance(), basis = SmileUtils.learnGaussianRadialBasis(trainx, (double[][])(centers = new double[10][]), 5.0), (T[])centers);
                if (y[loocv.test[i]] == rbf.predict(x[loocv.test[i]])) continue;
                ++error;
            }
            System.out.println("RBF network error = " + error);
            Assert.assertTrue(error <= 6);
        }
        catch (Exception ex) {
            System.err.println(ex);
        }
    }

    @Test
    public void testSegment() {
        System.out.println("Segment");
        ArffParser parser = new ArffParser();
        parser.setResponseIndex(19);
        try {
            AttributeDataset train = parser.parse(IOUtils.getTestDataFile("weka/segment-challenge.arff"));
            AttributeDataset test = parser.parse(IOUtils.getTestDataFile("weka/segment-test.arff"));
            double[][] x = (double[][])train.toArray((E[])new double[0][]);
            int[] y = train.toArray(new int[0]);
            double[][] testx = (double[][])test.toArray((E[])new double[0][]);
            int[] testy = test.toArray(new int[0]);
            double[][] centers = new double[100][];
            RadialBasisFunction[] basis = SmileUtils.learnGaussianRadialBasis(x, (double[][])centers, 5.0);
            RBFNetwork<double[]> rbf = new RBFNetwork<double[]>((T[])x, y, (Metric<double[]>)new EuclideanDistance(), basis, (T[])centers);
            int error = 0;
            for (int i = 0; i < testx.length; ++i) {
                if (rbf.predict(testx[i]) == testy[i]) continue;
                ++error;
            }
            System.out.format("Segment error rate = %.2f%%%n", 100.0 * (double)error / (double)testx.length);
            Assert.assertTrue(error <= 210);
        }
        catch (Exception ex) {
            System.err.println(ex);
        }
    }

    @Test
    public void testUSPS() {
        System.out.println("USPS");
        DelimitedTextParser parser = new DelimitedTextParser();
        parser.setResponseIndex(new NominalAttribute("class"), 0);
        try {
            AttributeDataset train = parser.parse("USPS Train", IOUtils.getTestDataFile("usps/zip.train"));
            AttributeDataset test = parser.parse("USPS Test", IOUtils.getTestDataFile("usps/zip.test"));
            double[][] x = (double[][])train.toArray((E[])new double[train.size()][]);
            int[] y = train.toArray(new int[train.size()]);
            double[][] testx = (double[][])test.toArray((E[])new double[test.size()][]);
            int[] testy = test.toArray(new int[test.size()]);
            double[][] centers = new double[200][];
            GaussianRadialBasis basis = SmileUtils.learnGaussianRadialBasis(x, centers);
            RBFNetwork<double[]> rbf = new RBFNetwork<double[]>((T[])x, y, (Metric<double[]>)new EuclideanDistance(), new GaussianRadialBasis(8.0), (T[])centers);
            int error = 0;
            for (int i = 0; i < testx.length; ++i) {
                if (rbf.predict(testx[i]) == testy[i]) continue;
                ++error;
            }
            System.out.format("USPS error rate = %.2f%%%n", 100.0 * (double)error / (double)testx.length);
            Assert.assertTrue(error <= 150);
        }
        catch (Exception ex) {
            System.err.println(ex);
        }
    }
}

