/*
 * Decompiled with CFR 0.152.
 */
package smile.classification;

import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import smile.classification.LogisticRegression;
import smile.data.AttributeDataset;
import smile.data.NominalAttribute;
import smile.data.parser.ArffParser;
import smile.data.parser.DelimitedTextParser;
import smile.data.parser.IOUtils;
import smile.math.Math;
import smile.validation.LOOCV;

public class LogisticRegressionTest {
    @BeforeClass
    public static void setUpClass() throws Exception {
    }

    @AfterClass
    public static void tearDownClass() throws Exception {
    }

    @Before
    public void setUp() {
    }

    @After
    public void tearDown() {
    }

    @Test
    public void testIris2() {
        System.out.println("Iris binary");
        ArffParser arffParser = new ArffParser();
        arffParser.setResponseIndex(4);
        try {
            AttributeDataset iris = arffParser.parse(IOUtils.getTestDataFile("weka/iris.arff"));
            double[][] x = (double[][])iris.toArray((E[])new double[iris.size()][]);
            int[] y = iris.toArray(new int[iris.size()]);
            for (int i = 0; i < y.length; ++i) {
                y[i] = y[i] == 2 ? 1 : 0;
            }
            int n = x.length;
            LOOCV loocv = new LOOCV(n);
            int error = 0;
            for (int i = 0; i < n; ++i) {
                int[] trainy;
                double[][] trainx = (double[][])Math.slice(x, loocv.train[i]);
                LogisticRegression logit = new LogisticRegression(trainx, trainy = Math.slice(y, loocv.train[i]));
                if (y[loocv.test[i]] == logit.predict(x[loocv.test[i]])) continue;
                ++error;
            }
            System.out.println("Logistic Regression error = " + error);
            Assert.assertEquals(3L, error);
        }
        catch (Exception ex) {
            System.err.println(ex);
        }
    }

    @Test
    public void testIris() {
        System.out.println("Iris");
        ArffParser arffParser = new ArffParser();
        arffParser.setResponseIndex(4);
        try {
            AttributeDataset iris = arffParser.parse(IOUtils.getTestDataFile("weka/iris.arff"));
            double[][] x = (double[][])iris.toArray((E[])new double[iris.size()][]);
            int[] y = iris.toArray(new int[iris.size()]);
            int n = x.length;
            LOOCV loocv = new LOOCV(n);
            int error = 0;
            for (int i = 0; i < n; ++i) {
                int[] trainy;
                double[][] trainx = (double[][])Math.slice(x, loocv.train[i]);
                LogisticRegression logit = new LogisticRegression(trainx, trainy = Math.slice(y, loocv.train[i]));
                if (y[loocv.test[i]] == logit.predict(x[loocv.test[i]])) continue;
                ++error;
            }
            System.out.println("Logistic Regression error = " + error);
            Assert.assertEquals(3L, error);
        }
        catch (Exception ex) {
            System.err.println(ex);
        }
    }

    @Test
    public void testSegment() {
        System.out.println("Segment");
        ArffParser arffParser = new ArffParser();
        arffParser.setResponseIndex(19);
        try {
            AttributeDataset train = arffParser.parse(IOUtils.getTestDataFile("weka/segment-challenge.arff"));
            AttributeDataset test = arffParser.parse(IOUtils.getTestDataFile("weka/segment-test.arff"));
            double[][] x = (double[][])train.toArray((E[])new double[train.size()][]);
            int[] y = train.toArray(new int[train.size()]);
            double[][] testx = (double[][])test.toArray((E[])new double[test.size()][]);
            int[] testy = test.toArray(new int[test.size()]);
            LogisticRegression logit = new LogisticRegression(x, y, 0.05, 0.001, 1000);
            int error = 0;
            for (int i = 0; i < testx.length; ++i) {
                if (logit.predict(testx[i]) == testy[i]) continue;
                ++error;
            }
            System.out.format("Segment error rate = %.2f%%%n", 100.0 * (double)error / (double)testx.length);
            Assert.assertEquals(48L, error);
        }
        catch (Exception ex) {
            System.err.println(ex);
        }
    }

    @Test
    public void testUSPS() {
        System.out.println("USPS");
        DelimitedTextParser parser = new DelimitedTextParser();
        parser.setResponseIndex(new NominalAttribute("class"), 0);
        try {
            AttributeDataset train = parser.parse("USPS Train", IOUtils.getTestDataFile("usps/zip.train"));
            AttributeDataset test = parser.parse("USPS Test", IOUtils.getTestDataFile("usps/zip.test"));
            double[][] x = (double[][])train.toArray((E[])new double[train.size()][]);
            int[] y = train.toArray(new int[train.size()]);
            double[][] testx = (double[][])test.toArray((E[])new double[test.size()][]);
            int[] testy = test.toArray(new int[test.size()]);
            LogisticRegression logit = new LogisticRegression(x, y, 0.3, 0.001, 1000);
            int error = 0;
            for (int i = 0; i < testx.length; ++i) {
                if (logit.predict(testx[i]) == testy[i]) continue;
                ++error;
            }
            System.out.format("USPS error rate = %.2f%%%n", 100.0 * (double)error / (double)testx.length);
            Assert.assertEquals(188L, error);
        }
        catch (Exception ex) {
            System.err.println(ex);
        }
    }
}

