/*
 * Decompiled with CFR 0.152.
 */
package smile.classification;

import org.junit.After;
import org.junit.AfterClass;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import smile.classification.GradientTreeBoost;
import smile.data.AttributeDataset;
import smile.data.NominalAttribute;
import smile.data.parser.ArffParser;
import smile.data.parser.DelimitedTextParser;
import smile.data.parser.IOUtils;
import smile.math.Math;
import smile.sort.QuickSort;
import smile.validation.LOOCV;

public class GradientTreeBoostTest {
    @BeforeClass
    public static void setUpClass() throws Exception {
    }

    @AfterClass
    public static void tearDownClass() throws Exception {
    }

    @Before
    public void setUp() {
    }

    @After
    public void tearDown() {
    }

    @Test
    public void testIris2() {
        System.out.println("Iris binary");
        ArffParser arffParser = new ArffParser();
        arffParser.setResponseIndex(4);
        try {
            AttributeDataset iris = arffParser.parse(IOUtils.getTestDataFile("weka/iris.arff"));
            double[][] x = (double[][])iris.toArray((E[])new double[iris.size()][]);
            int[] y = iris.toArray(new int[iris.size()]);
            for (int i = 0; i < y.length; ++i) {
                y[i] = y[i] == 2 ? 1 : 0;
            }
            int n = x.length;
            LOOCV loocv = new LOOCV(n);
            int error = 0;
            for (int i = 0; i < n; ++i) {
                double[][] trainx = (double[][])Math.slice(x, loocv.train[i]);
                int[] trainy = Math.slice(y, loocv.train[i]);
                GradientTreeBoost boost = new GradientTreeBoost(iris.attributes(), trainx, trainy, 100);
                if (y[loocv.test[i]] == boost.predict(x[loocv.test[i]])) continue;
                ++error;
            }
            System.out.println("Gradient Tree Boost error = " + error);
        }
        catch (Exception ex) {
            System.err.println(ex);
        }
    }

    @Test
    public void testIris() {
        System.out.println("Iris");
        ArffParser arffParser = new ArffParser();
        arffParser.setResponseIndex(4);
        try {
            AttributeDataset iris = arffParser.parse(IOUtils.getTestDataFile("weka/iris.arff"));
            double[][] x = (double[][])iris.toArray((E[])new double[iris.size()][]);
            int[] y = iris.toArray(new int[iris.size()]);
            int n = x.length;
            LOOCV loocv = new LOOCV(n);
            int error = 0;
            for (int i = 0; i < n; ++i) {
                double[][] trainx = (double[][])Math.slice(x, loocv.train[i]);
                int[] trainy = Math.slice(y, loocv.train[i]);
                GradientTreeBoost boost = new GradientTreeBoost(iris.attributes(), trainx, trainy, 100);
                if (y[loocv.test[i]] == boost.predict(x[loocv.test[i]])) continue;
                ++error;
            }
            System.out.println("Gradient Tree Boost error = " + error);
        }
        catch (Exception ex) {
            System.err.println(ex);
        }
    }

    @Test
    public void testSegment() {
        System.out.println("Segment");
        ArffParser arffParser = new ArffParser();
        arffParser.setResponseIndex(19);
        try {
            AttributeDataset train = arffParser.parse(IOUtils.getTestDataFile("weka/segment-challenge.arff"));
            AttributeDataset test = arffParser.parse(IOUtils.getTestDataFile("weka/segment-test.arff"));
            double[][] x = (double[][])train.toArray((E[])new double[train.size()][]);
            int[] y = train.toArray(new int[train.size()]);
            double[][] testx = (double[][])test.toArray((E[])new double[test.size()][]);
            int[] testy = test.toArray(new int[test.size()]);
            GradientTreeBoost boost = new GradientTreeBoost(train.attributes(), x, y, 100);
            int error = 0;
            for (int i = 0; i < testx.length; ++i) {
                if (boost.predict(testx[i]) == testy[i]) continue;
                ++error;
            }
            System.out.format("Gradient Tree Boost error rate = %.2f%%%n", 100.0 * (double)error / (double)testx.length);
        }
        catch (Exception ex) {
            System.err.println(ex);
        }
    }

    @Test
    public void testUSPS() {
        System.out.println("USPS");
        DelimitedTextParser parser = new DelimitedTextParser();
        parser.setResponseIndex(new NominalAttribute("class"), 0);
        try {
            AttributeDataset train = parser.parse("USPS Train", IOUtils.getTestDataFile("usps/zip.train"));
            AttributeDataset test = parser.parse("USPS Test", IOUtils.getTestDataFile("usps/zip.test"));
            double[][] x = (double[][])train.toArray((E[])new double[train.size()][]);
            int[] y = train.toArray(new int[train.size()]);
            double[][] testx = (double[][])test.toArray((E[])new double[test.size()][]);
            int[] testy = test.toArray(new int[test.size()]);
            GradientTreeBoost boost = new GradientTreeBoost(train.attributes(), x, y, 100);
            int error = 0;
            for (int i = 0; i < testx.length; ++i) {
                if (boost.predict(testx[i]) == testy[i]) continue;
                ++error;
            }
            System.out.format("Gradient Tree Boost error rate = %.2f%%%n", 100.0 * (double)error / (double)testx.length);
            double[] accuracy = boost.test(testx, testy);
            for (int i = 1; i <= accuracy.length; ++i) {
                System.out.format("%d trees accuracy = %.2f%%%n", i, 100.0 * accuracy[i - 1]);
            }
            double[] importance = boost.importance();
            int[] index = QuickSort.sort(importance);
            int i = importance.length;
            while (i-- > 0) {
                System.out.format("%s importance is %.4f%n", train.attributes()[index[i]], importance[i]);
            }
        }
        catch (Exception ex) {
            System.err.println(ex);
        }
    }

    @Test
    public void testUSPS2() {
        System.out.println("USPS 2 classes");
        DelimitedTextParser parser = new DelimitedTextParser();
        parser.setResponseIndex(new NominalAttribute("class"), 0);
        try {
            int i;
            AttributeDataset train = parser.parse("USPS Train", IOUtils.getTestDataFile("usps/zip.train"));
            AttributeDataset test = parser.parse("USPS Test", IOUtils.getTestDataFile("usps/zip.test"));
            double[][] x = (double[][])train.toArray((E[])new double[train.size()][]);
            int[] y = train.toArray(new int[train.size()]);
            double[][] testx = (double[][])test.toArray((E[])new double[test.size()][]);
            int[] testy = test.toArray(new int[test.size()]);
            for (i = 0; i < y.length; ++i) {
                if (y[i] == 0) continue;
                y[i] = 1;
            }
            for (i = 0; i < testy.length; ++i) {
                if (testy[i] == 0) continue;
                testy[i] = 1;
            }
            GradientTreeBoost boost = new GradientTreeBoost(train.attributes(), x, y, 100);
            int error = 0;
            for (int i2 = 0; i2 < testx.length; ++i2) {
                if (boost.predict(testx[i2]) == testy[i2]) continue;
                ++error;
            }
            System.out.format("Gradient Tree Boost error rate = %.2f%%%n", 100.0 * (double)error / (double)testx.length);
            double[] accuracy = boost.test(testx, testy);
            for (int i3 = 1; i3 <= accuracy.length; ++i3) {
                System.out.format("%d trees accuracy = %.2f%%%n", i3, 100.0 * accuracy[i3 - 1]);
            }
            double[] importance = boost.importance();
            int[] index = QuickSort.sort(importance);
            int i4 = importance.length;
            while (i4-- > 0) {
                System.out.format("%s importance is %.4f%n", train.attributes()[index[i4]], importance[i4]);
            }
        }
        catch (Exception ex) {
            System.err.println(ex);
        }
    }
}

