/*
 * Decompiled with CFR 0.152.
 */
package smile.association;

import java.util.Arrays;
import java.util.HashMap;
import smile.math.Math;
import smile.sort.QuickSort;

final class FPTree {
    int numTransactions = 0;
    int minSupport;
    Node root = null;
    int[] itemSupport;
    HeaderTableItem[] headerTable;
    int numItems = 0;
    int numFreqItems = 0;
    int maxItemSetSize = -1;
    int[] order;

    public FPTree(int[] frequency, int minSupport) {
        int i;
        this.itemSupport = frequency;
        this.minSupport = minSupport;
        this.root = new Node();
        this.numItems = frequency.length;
        for (int f : frequency) {
            if (f < minSupport) continue;
            ++this.numFreqItems;
        }
        this.headerTable = new HeaderTableItem[this.numFreqItems];
        int j = 0;
        for (i = 0; i < this.numItems; ++i) {
            if (frequency[i] < minSupport) continue;
            HeaderTableItem header = new HeaderTableItem(i);
            header.count = frequency[i];
            this.headerTable[j++] = header;
        }
        Arrays.sort(this.headerTable);
        this.order = new int[this.numItems];
        Arrays.fill(this.order, this.numItems);
        for (i = 0; i < this.numFreqItems; ++i) {
            this.order[this.headerTable[i].id] = i;
        }
    }

    public FPTree(int[][] itemsets, int minSupport) {
        this(FPTree.freq(itemsets), minSupport);
        for (int[] itemset : itemsets) {
            this.add(itemset);
        }
    }

    private static int[] freq(int[][] itemsets) {
        int[] f = new int[Math.max(itemsets) + 1];
        int[][] nArray = itemsets;
        int n = nArray.length;
        for (int i = 0; i < n; ++i) {
            int[] itemset;
            int[] nArray2 = itemset = nArray[i];
            int n2 = nArray2.length;
            for (int j = 0; j < n2; ++j) {
                int i2;
                int n3 = i2 = nArray2[j];
                f[n3] = f[n3] + 1;
            }
        }
        return f;
    }

    public int size() {
        return this.numTransactions;
    }

    public void add(int[] itemset) {
        int i;
        ++this.numTransactions;
        int m = 0;
        int t = itemset.length;
        int[] o = new int[t];
        for (i = 0; i < t; ++i) {
            int item = itemset[i];
            o[i] = this.order[item];
            if (this.itemSupport[item] < this.minSupport) continue;
            ++m;
        }
        if (m > 0) {
            QuickSort.sort(o, itemset, t);
            for (i = 1; i < m; ++i) {
                if (itemset[i] != itemset[i - 1]) continue;
                --m;
                for (int j = i; j < m; ++j) {
                    itemset[j] = itemset[j + 1];
                }
            }
            this.root.add(0, m, itemset, 1);
        }
    }

    public void add(int index, int end, int[] itemset, int support) {
        this.root.add(index, end, itemset, support);
    }

    static class HeaderTableItem
    implements Comparable<HeaderTableItem> {
        int id;
        int count = 0;
        Node node = null;

        HeaderTableItem(int id) {
            this.id = id;
        }

        @Override
        public int compareTo(HeaderTableItem o) {
            return o.count - this.count;
        }
    }

    class Node {
        int id = -1;
        int count = 0;
        Node parent = null;
        Node next = null;
        HashMap<Integer, Node> children = null;

        Node() {
        }

        Node(int id, int support, Node parent) {
            this.id = id;
            this.count = support;
            this.parent = parent;
        }

        void add(int index, int end, int[] itemset, int support) {
            Node child;
            if (this.children == null) {
                this.children = new HashMap();
            }
            if ((child = this.children.get(itemset[index])) != null) {
                child.count += support;
                if (++index < end) {
                    child.add(index, end, itemset, support);
                }
            } else {
                this.append(index, end, itemset, support);
            }
        }

        void append(int index, int end, int[] itemset, int support) {
            if (this.children == null) {
                this.children = new HashMap();
            }
            if (index >= FPTree.this.maxItemSetSize) {
                FPTree.this.maxItemSetSize = index + 1;
            }
            int item = itemset[index];
            Node child = new Node(item, support, this.id < 0 ? null : this);
            child.addToHeaderTable();
            this.children.put(item, child);
            if (++index < end) {
                child.append(index, end, itemset, support);
            }
        }

        void addToHeaderTable() {
            this.next = FPTree.this.headerTable[FPTree.this.order[this.id]].node;
            FPTree.this.headerTable[FPTree.this.order[this.id]].node = this;
        }
    }
}

