/*
 * Decompiled with CFR 0.152.
 */
package jnumeric;

import jnumeric.PyMultiarray;
import org.python.core.JyAttribute;
import org.python.core.Py;
import org.python.core.PyObject;
import org.python.core.PyType;

public class FFT
extends PyObject {
    private static final long serialVersionUID = 5458819189675402442L;

    public FFT() {
        super(PyType.fromClass(FFT.class));
        Object javaProxy = JyAttribute.getAttr(this, (byte)-128);
        javaProxy = JyAttribute.getAttr(this, (byte)-128);
    }

    static PyMultiarray _fft(PyObject o, boolean inverse) {
        PyMultiarray a = PyMultiarray.asarray(o, 'D');
        if (PyMultiarray.shapeOf(a).length != 1) {
            throw Py.ValueError("FFT only available for 1D arrays");
        }
        int N = a.__len__();
        int log2N = 0;
        while (1 << log2N < N) {
            ++log2N;
        }
        if (1 << log2N != N) {
            throw Py.ValueError("array length is not a power of two");
        }
        int[] factors = new int[log2N];
        int[] perms = new int[log2N];
        for (int i = 0; i < log2N; ++i) {
            factors[i] = 2;
            perms[i] = log2N - i - 1;
        }
        a = PyMultiarray.transpose(PyMultiarray.reshape(a, factors), perms);
        a = PyMultiarray.array(PyMultiarray.reshape(a, new int[]{N}));
        double[] data = (double[])a.data;
        double signedTwoPi = (double)((inverse ? 1 : -1) * 2) * Math.PI;
        int twoN = 2 * N;
        for (int step = 4; step <= twoN; step *= 2) {
            int halfStep = step / 2;
            double theta0 = signedTwoPi / (double)step;
            for (int start = 0; start < halfStep; start += 2) {
                double cosTheta = Math.cos((double)start * theta0);
                double sinTheta = Math.sin((double)start * theta0);
                for (int jR = start; jR < twoN; jR += step) {
                    int kR = jR + halfStep;
                    int jI = jR + 1;
                    int kI = kR + 1;
                    double tempR = cosTheta * data[kR] - sinTheta * data[kI];
                    double tempI = sinTheta * data[kR] + cosTheta * data[kI];
                    data[kR] = data[jR] - tempR;
                    data[kI] = data[jI] - tempI;
                    int n = jR;
                    data[n] = data[n] + tempR;
                    int n2 = jI;
                    data[n2] = data[n2] + tempI;
                }
            }
        }
        if (inverse) {
            for (int i = 0; i < twoN; i += 2) {
                int n = i;
                data[n] = data[n] / (double)N;
                int n3 = i + 1;
                data[n3] = data[n3] / (double)N;
            }
        }
        return a;
    }

    public static PyMultiarray fft(PyObject o) {
        return FFT._fft(o, false);
    }

    public static PyMultiarray inverse_fft(PyObject o) {
        return FFT._fft(o, true);
    }
}

