/*
 * Decompiled with CFR 0.152.
 */
package org.la4j.operation.ooplace;

import java.util.ArrayList;
import java.util.Iterator;
import org.la4j.Matrix;
import org.la4j.matrix.ColumnMajorSparseMatrix;
import org.la4j.matrix.DenseMatrix;
import org.la4j.matrix.RowMajorSparseMatrix;
import org.la4j.operation.MatrixOperation;

public class OoPlaceMatrixByItsTransposeMultiplication
extends MatrixOperation<Matrix> {
    @Override
    public Matrix apply(DenseMatrix a) {
        Matrix result = a.blankOfShape(a.rows(), a.rows());
        for (int i = 0; i < a.rows(); ++i) {
            for (int j = 0; j < a.rows(); ++j) {
                double acc = 0.0;
                for (int k = 0; k < a.columns(); ++k) {
                    acc += a.get(i, k) * a.get(j, k);
                }
                result.set(i, j, acc);
            }
        }
        return result;
    }

    @Override
    public Matrix apply(RowMajorSparseMatrix a) {
        Matrix result = a.blankOfShape(a.rows(), a.rows());
        ArrayList<Integer> nzRows = new ArrayList<Integer>();
        Iterator<Integer> it = a.iteratorOfNonZeroRows();
        while (it.hasNext()) {
            nzRows.add(it.next());
        }
        Iterator iterator = nzRows.iterator();
        while (iterator.hasNext()) {
            int i = (Integer)iterator.next();
            Iterator iterator2 = nzRows.iterator();
            while (iterator2.hasNext()) {
                int j = (Integer)iterator2.next();
                result.set(i, j, a.nonZeroIteratorOfRow(i).innerProduct(a.nonZeroIteratorOfRow(j)));
            }
        }
        return result;
    }

    @Override
    public Matrix apply(ColumnMajorSparseMatrix a) {
        return this.apply(a.toRowMajorSparseMatrix());
    }
}

