/*
 * Decompiled with CFR 0.152.
 */
package org.la4j.matrix.sparse;

import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.Random;
import org.la4j.Matrices;
import org.la4j.Matrix;
import org.la4j.Vector;
import org.la4j.iterator.RowMajorMatrixIterator;
import org.la4j.iterator.VectorIterator;
import org.la4j.matrix.MatrixFactory;
import org.la4j.matrix.RowMajorSparseMatrix;
import org.la4j.matrix.functor.MatrixFunction;
import org.la4j.matrix.functor.MatrixProcedure;
import org.la4j.vector.functor.VectorProcedure;
import org.la4j.vector.sparse.CompressedVector;

public class CRSMatrix
extends RowMajorSparseMatrix {
    private static final byte MATRIX_TAG = 32;
    private static final int MINIMUM_SIZE = 32;
    private double[] values;
    private int[] columnIndices;
    private int[] rowPointers;

    public static CRSMatrix zero(int rows, int columns) {
        return new CRSMatrix(rows, columns);
    }

    public static CRSMatrix zero(int rows, int columns, int capacity) {
        return new CRSMatrix(rows, columns, capacity);
    }

    public static CRSMatrix diagonal(int size, double diagonal) {
        double[] values = new double[size];
        int[] columnIndices = new int[size];
        int[] rowPointers = new int[size + 1];
        for (int i = 0; i < size; ++i) {
            columnIndices[i] = i;
            rowPointers[i] = i;
            values[i] = diagonal;
        }
        rowPointers[size] = size;
        return new CRSMatrix(size, size, size, values, columnIndices, rowPointers);
    }

    public static CRSMatrix identity(int size) {
        return CRSMatrix.diagonal(size, 1.0);
    }

    public static CRSMatrix random(int rows, int columns, double density, Random random) {
        if (density < 0.0 || density > 1.0) {
            throw new IllegalArgumentException("The density value should be between 0 and 1.0");
        }
        int cardinality = Math.max((int)((double)(rows * columns) * density), rows);
        double[] values = new double[cardinality];
        int[] columnIndices = new int[cardinality];
        int[] rowPointers = new int[rows + 1];
        int kk = cardinality / rows;
        int[] indices = new int[kk];
        int k = 0;
        for (int i = 0; i < rows; ++i) {
            rowPointers[i] = k;
            for (int ii = 0; ii < kk; ++ii) {
                indices[ii] = random.nextInt(columns);
            }
            Arrays.sort(indices);
            int previous = -1;
            for (int ii = 0; ii < kk; ++ii) {
                if (indices[ii] == previous) continue;
                values[k] = random.nextDouble();
                columnIndices[k++] = indices[ii];
                previous = indices[ii];
            }
        }
        rowPointers[rows] = cardinality;
        return new CRSMatrix(rows, columns, cardinality, values, columnIndices, rowPointers);
    }

    public static CRSMatrix randomSymmetric(int size, double density, Random random) {
        int cardinality = (int)((double)(size * size) * density);
        CRSMatrix matrix = new CRSMatrix(size, size, cardinality);
        for (int k = 0; k < cardinality / 2; ++k) {
            int i = random.nextInt(size);
            int j = random.nextInt(size);
            double value = random.nextDouble();
            matrix.set(i, j, value);
            matrix.set(j, i, value);
        }
        return matrix;
    }

    public static CRSMatrix from1DArray(int rows, int columns, double[] array) {
        CRSMatrix result = CRSMatrix.zero(rows, columns);
        for (int i = 0; i < rows; ++i) {
            for (int j = 0; j < columns; ++j) {
                int k = i * columns + j;
                if (array[k] == 0.0) continue;
                result.set(i, j, array[k]);
            }
        }
        return result;
    }

    public static CRSMatrix from2DArray(double[][] array) {
        int rows = array.length;
        int columns = array[0].length;
        CRSMatrix result = CRSMatrix.zero(rows, columns);
        for (int i = 0; i < rows; ++i) {
            for (int j = 0; j < columns; ++j) {
                if (array[i][j] == 0.0) continue;
                result.set(i, j, array[i][j]);
            }
        }
        return result;
    }

    public static CRSMatrix block(Matrix a, Matrix b, Matrix c, Matrix d) {
        if (a.rows() != b.rows() || a.columns() != c.columns() || c.rows() != d.rows() || b.columns() != d.columns()) {
            throw new IllegalArgumentException("Sides of blocks are incompatible!");
        }
        int rows = a.rows() + c.rows();
        int columns = a.columns() + b.columns();
        ArrayList<Double> values = new ArrayList<Double>();
        ArrayList<Integer> columnIndices = new ArrayList<Integer>();
        int[] rowPointers = new int[rows + 1];
        int k = 0;
        rowPointers[0] = 0;
        double current = 0.0;
        for (int i = 0; i < rows; ++i) {
            for (int j = 0; j < columns; ++j) {
                if (i < a.rows() && j < a.columns()) {
                    current = a.get(i, j);
                }
                if (i < a.rows() && j > a.columns()) {
                    current = b.get(i, j);
                }
                if (i > a.rows() && j < a.columns()) {
                    current = c.get(i, j);
                }
                if (i > a.rows() && j > a.columns()) {
                    current = d.get(i, j);
                }
                if (!(Math.abs(current) > Matrices.EPS)) continue;
                values.add(current);
                columnIndices.add(j);
                ++k;
            }
            rowPointers[i + 1] = k;
        }
        double[] valuesArray = new double[values.size()];
        int[] colIndArray = new int[columnIndices.size()];
        for (int i = 0; i < values.size(); ++i) {
            valuesArray[i] = (Double)values.get(i);
            colIndArray[i] = (Integer)columnIndices.get(i);
        }
        return new CRSMatrix(rows, columns, k, valuesArray, colIndArray, rowPointers);
    }

    public static CRSMatrix fromBinary(byte[] array) {
        int i;
        ByteBuffer buffer = ByteBuffer.wrap(array);
        if (buffer.get() != 32) {
            throw new IllegalArgumentException("Can not decode CRSMatrix from the given byte array.");
        }
        int rows = buffer.getInt();
        int columns = buffer.getInt();
        int cardinality = buffer.getInt();
        int[] columnIndices = new int[cardinality];
        double[] values = new double[cardinality];
        int[] rowPointers = new int[rows + 1];
        for (i = 0; i < cardinality; ++i) {
            columnIndices[i] = buffer.getInt();
            values[i] = buffer.getDouble();
        }
        for (i = 0; i < rows + 1; ++i) {
            rowPointers[i] = buffer.getInt();
        }
        return new CRSMatrix(rows, columns, cardinality, values, columnIndices, rowPointers);
    }

    public static CRSMatrix fromCSV(String csv) {
        return Matrix.fromCSV(csv).to(Matrices.CRS);
    }

    public static CRSMatrix fromMatrixMarket(String mm) {
        return Matrix.fromMatrixMarket(mm).to(Matrices.CRS);
    }

    public CRSMatrix() {
        this(0, 0);
    }

    public CRSMatrix(int rows, int columns) {
        this(rows, columns, 0);
    }

    public CRSMatrix(int rows, int columns, int capacity) {
        super(rows, columns);
        this.ensureCardinalityIsCorrect(rows, columns, capacity);
        int alignedSize = this.align(capacity);
        this.values = new double[alignedSize];
        this.columnIndices = new int[alignedSize];
        this.rowPointers = new int[rows + 1];
    }

    public CRSMatrix(int rows, int columns, int cardinality, double[] values, int[] columnIndices, int[] rowPointers) {
        super(rows, columns, cardinality);
        this.ensureCardinalityIsCorrect(rows, columns, cardinality);
        this.values = values;
        this.columnIndices = columnIndices;
        this.rowPointers = rowPointers;
    }

    @Override
    public double getOrElse(int i, int j, double defaultValue) {
        this.ensureIndexesAreInBounds(i, j);
        int k = this.searchForColumnIndex(j, this.rowPointers[i], this.rowPointers[i + 1]);
        if (k < this.rowPointers[i + 1] && this.columnIndices[k] == j) {
            return this.values[k];
        }
        return defaultValue;
    }

    @Override
    public void set(int i, int j, double value) {
        this.ensureIndexesAreInBounds(i, j);
        int k = this.searchForColumnIndex(j, this.rowPointers[i], this.rowPointers[i + 1]);
        if (k < this.rowPointers[i + 1] && this.columnIndices[k] == j) {
            if (value == 0.0) {
                this.remove(k, i);
            } else {
                this.values[k] = value;
            }
        } else {
            this.insert(k, i, j, value);
        }
    }

    @Override
    public void setAll(double value) {
        if (value == 0.0) {
            this.cardinality = 0;
        } else {
            int size = (int)this.capacity();
            if (this.values.length < size) {
                this.values = new double[size];
                this.columnIndices = new int[size];
                this.rowPointers = new int[this.rows + 1];
            }
            for (int i = 0; i < this.rows; ++i) {
                for (int j = 0; j < this.columns; ++j) {
                    this.values[i * this.columns + j] = value;
                    this.columnIndices[i * this.columns + j] = j;
                }
                this.rowPointers[i] = this.columns * i;
            }
            this.rowPointers[this.rows] = size;
            this.cardinality = size;
        }
    }

    @Override
    public Vector getRow(int i) {
        int rowCardinality = this.rowPointers[i + 1] - this.rowPointers[i];
        double[] rowValues = new double[rowCardinality];
        int[] rowIndices = new int[rowCardinality];
        System.arraycopy(this.values, this.rowPointers[i], rowValues, 0, rowCardinality);
        System.arraycopy(this.columnIndices, this.rowPointers[i], rowIndices, 0, rowCardinality);
        return new CompressedVector(this.columns, rowCardinality, rowValues, rowIndices);
    }

    @Override
    public Vector getColumn(int j) {
        CompressedVector result = CompressedVector.zero(this.rows);
        int i = 0;
        while (this.rowPointers[i] < this.cardinality) {
            int k = this.searchForColumnIndex(j, this.rowPointers[i], this.rowPointers[i + 1]);
            if (k < this.rowPointers[i + 1] && this.columnIndices[k] == j) {
                ((Vector)result).set(i, this.values[k]);
            }
            ++i;
        }
        return result;
    }

    @Override
    public Matrix copyOfShape(int rows, int columns) {
        int i;
        this.ensureDimensionsAreCorrect(rows, columns);
        if (rows >= this.rows && columns >= this.columns) {
            double[] $values = new double[this.align(this.cardinality)];
            int[] $columnIndices = new int[this.align(this.cardinality)];
            int[] $rowPointers = new int[rows + 1];
            System.arraycopy(this.values, 0, $values, 0, this.cardinality);
            System.arraycopy(this.columnIndices, 0, $columnIndices, 0, this.cardinality);
            System.arraycopy(this.rowPointers, 0, $rowPointers, 0, this.rows + 1);
            for (int i2 = this.rows; i2 < rows + 1; ++i2) {
                $rowPointers[i2] = this.cardinality;
            }
            return new CRSMatrix(rows, columns, this.cardinality, $values, $columnIndices, $rowPointers);
        }
        double[] $values = new double[this.align(this.cardinality)];
        int[] $columnIndices = new int[this.align(this.cardinality)];
        int[] $rowPointers = new int[rows + 1];
        int $cardinality = 0;
        int k = 0;
        for (i = 0; k < this.cardinality && i < rows; ++i) {
            $rowPointers[i] = $cardinality;
            int j = this.rowPointers[i];
            while (j < this.rowPointers[i + 1] && this.columnIndices[j] < columns) {
                $values[$cardinality] = this.values[j];
                $columnIndices[$cardinality] = this.columnIndices[j];
                ++$cardinality;
                ++j;
                ++k;
            }
        }
        while (i < rows + 1) {
            $rowPointers[i] = $cardinality;
            ++i;
        }
        return new CRSMatrix(rows, columns, $cardinality, $values, $columnIndices, $rowPointers);
    }

    @Override
    public void eachNonZero(MatrixProcedure procedure) {
        int k = 0;
        int i = 0;
        while (k < this.cardinality) {
            int j = this.rowPointers[i];
            while (j < this.rowPointers[i + 1]) {
                procedure.apply(i, this.columnIndices[j], this.values[j]);
                ++j;
                ++k;
            }
            ++i;
        }
    }

    @Override
    public void each(MatrixProcedure procedure) {
        int k = 0;
        for (int i = 0; i < this.rows; ++i) {
            int valuesSoFar = this.rowPointers[i + 1];
            for (int j = 0; j < this.columns; ++j) {
                if (k < valuesSoFar && j == this.columnIndices[k]) {
                    procedure.apply(i, j, this.values[k++]);
                    continue;
                }
                procedure.apply(i, j, 0.0);
            }
        }
    }

    @Override
    public void eachInRow(int i, VectorProcedure procedure) {
        int k = this.rowPointers[i];
        int valuesSoFar = this.rowPointers[i + 1];
        for (int j = 0; j < this.columns; ++j) {
            if (k < valuesSoFar && j == this.columnIndices[k]) {
                procedure.apply(j, this.values[k++]);
                continue;
            }
            procedure.apply(j, 0.0);
        }
    }

    @Override
    public void eachNonZeroInRow(int i, VectorProcedure procedure) {
        for (int j = this.rowPointers[i]; j < this.rowPointers[i + 1]; ++j) {
            procedure.apply(this.columnIndices[j], this.values[j]);
        }
    }

    @Override
    public void updateAt(int i, int j, MatrixFunction function) {
        int k = this.searchForColumnIndex(j, this.rowPointers[i], this.rowPointers[i + 1]);
        if (k < this.rowPointers[i + 1] && this.columnIndices[k] == j) {
            double value = function.evaluate(i, j, this.values[k]);
            if (value == 0.0) {
                this.remove(k, i);
            } else {
                this.values[k] = value;
            }
        } else {
            this.insert(k, i, j, function.evaluate(i, j, 0.0));
        }
    }

    @Override
    public boolean nonZeroAt(int i, int j) {
        int k = this.searchForColumnIndex(j, this.rowPointers[i], this.rowPointers[i + 1]);
        return k < this.rowPointers[i + 1] && this.columnIndices[k] == j;
    }

    private int searchForColumnIndex(int j, int left, int right) {
        if (right - left == 0 || j > this.columnIndices[right - 1]) {
            return right;
        }
        while (left < right) {
            int p = (left + right) / 2;
            if (this.columnIndices[p] > j) {
                right = p;
                continue;
            }
            if (this.columnIndices[p] < j) {
                left = p + 1;
                continue;
            }
            return p;
        }
        return left;
    }

    private void insert(int k, int i, int j, double value) {
        if (value == 0.0) {
            return;
        }
        if (this.values.length < this.cardinality + 1) {
            this.growUp();
        }
        if (this.cardinality - k > 0) {
            System.arraycopy(this.values, k, this.values, k + 1, this.cardinality - k);
            System.arraycopy(this.columnIndices, k, this.columnIndices, k + 1, this.cardinality - k);
        }
        this.values[k] = value;
        this.columnIndices[k] = j;
        int ii = i + 1;
        while (ii < this.rows + 1) {
            int n = ii++;
            this.rowPointers[n] = this.rowPointers[n] + 1;
        }
        ++this.cardinality;
    }

    private void remove(int k, int i) {
        --this.cardinality;
        if (this.cardinality - k > 0) {
            System.arraycopy(this.values, k + 1, this.values, k, this.cardinality - k);
            System.arraycopy(this.columnIndices, k + 1, this.columnIndices, k, this.cardinality - k);
        }
        int ii = i + 1;
        while (ii < this.rows + 1) {
            int n = ii++;
            this.rowPointers[n] = this.rowPointers[n] - 1;
        }
    }

    private void growUp() {
        if ((long)this.values.length == this.capacity()) {
            throw new IllegalStateException("This matrix can't grow up.");
        }
        int min = this.rows != 0 && this.columns > Integer.MAX_VALUE / this.rows ? Integer.MAX_VALUE : this.rows * this.columns;
        int capacity = Math.min(min, this.cardinality * 3 / 2 + 1);
        double[] $values = new double[capacity];
        int[] $columnIndices = new int[capacity];
        System.arraycopy(this.values, 0, $values, 0, this.cardinality);
        System.arraycopy(this.columnIndices, 0, $columnIndices, 0, this.cardinality);
        this.values = $values;
        this.columnIndices = $columnIndices;
    }

    private int align(int cardinality) {
        return (cardinality / 32 + 1) * 32;
    }

    @Override
    public double max() {
        double max = Double.NEGATIVE_INFINITY;
        for (int i = 0; i < this.cardinality; ++i) {
            if (!(this.values[i] > max)) continue;
            max = this.values[i];
        }
        return max > 0.0 ? max : 0.0;
    }

    @Override
    public double min() {
        double min = Double.POSITIVE_INFINITY;
        for (int i = 0; i < this.cardinality; ++i) {
            if (!(this.values[i] < min)) continue;
            min = this.values[i];
        }
        return min < 0.0 ? min : 0.0;
    }

    @Override
    public double maxInRow(int i) {
        double max = Double.NEGATIVE_INFINITY;
        for (int k = this.rowPointers[i]; k < this.rowPointers[i + 1]; ++k) {
            if (!(this.values[k] > max)) continue;
            max = this.values[k];
        }
        return max > 0.0 ? max : 0.0;
    }

    @Override
    public double minInRow(int i) {
        double min = Double.POSITIVE_INFINITY;
        for (int k = this.rowPointers[i]; k < this.rowPointers[i + 1]; ++k) {
            if (!(this.values[k] < min)) continue;
            min = this.values[k];
        }
        return min < 0.0 ? min : 0.0;
    }

    @Override
    public Matrix select(int[] rowIndices, int[] columnIndices) {
        int newRows = rowIndices.length;
        int newCols = columnIndices.length;
        if (newRows == 0 || newCols == 0) {
            this.fail("No rows or columns selected.");
        }
        int newCardinality = 0;
        for (int i = 0; i < newRows; ++i) {
            for (int j = 0; j < newCols; ++j) {
                if (this.get(rowIndices[i], columnIndices[j]) == 0.0) continue;
                ++newCardinality;
            }
        }
        double[] newValues = new double[newCardinality];
        int[] newColumnIndices = new int[newCardinality];
        int[] newRowPointers = new int[newRows + 1];
        newRowPointers[0] = 0;
        int endPtr = 0;
        for (int i = 0; i < newRows; ++i) {
            newRowPointers[i + 1] = newRowPointers[i];
            for (int j = 0; j < newCols; ++j) {
                double val = this.get(rowIndices[i], columnIndices[j]);
                if (val == 0.0) continue;
                newValues[endPtr] = val;
                newColumnIndices[endPtr] = j;
                ++endPtr;
                int n = i + 1;
                newRowPointers[n] = newRowPointers[n] + 1;
            }
        }
        return new CRSMatrix(newRows, newCols, newCardinality, newValues, newColumnIndices, newRowPointers);
    }

    @Override
    public <T extends Matrix> T to(MatrixFactory<T> factory) {
        if (factory.outputClass == CRSMatrix.class) {
            return (T)((Matrix)factory.outputClass.cast(this));
        }
        return super.to(factory);
    }

    @Override
    public Matrix blankOfShape(int rows, int columns) {
        return CRSMatrix.zero(rows, columns);
    }

    @Override
    public Iterator<Integer> iteratorOfNonZeroRows() {
        return new Iterator<Integer>(){
            private int i = -1;

            @Override
            public boolean hasNext() {
                while (this.i + 1 < CRSMatrix.this.rows && CRSMatrix.this.rowPointers[this.i + 1] < CRSMatrix.this.cardinality && CRSMatrix.this.rowPointers[this.i + 1] == CRSMatrix.this.rowPointers[this.i + 2]) {
                    ++this.i;
                }
                return this.i + 1 < CRSMatrix.this.rows && CRSMatrix.this.rowPointers[this.i + 1] < CRSMatrix.this.cardinality;
            }

            @Override
            public Integer next() {
                ++this.i;
                return this.i;
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException("Can not remove from this iterator.");
            }
        };
    }

    @Override
    public RowMajorMatrixIterator rowMajorIterator() {
        return new RowMajorMatrixIterator(this.rows, this.columns){
            private long limit;
            private boolean currentNonZero;
            private int i;
            private int k;
            {
                this.limit = (long)this.rows * (long)this.columns;
                this.currentNonZero = false;
                this.i = -1;
                this.k = 0;
            }

            @Override
            public int rowIndex() {
                return this.i / this.columns;
            }

            @Override
            public int columnIndex() {
                return this.i - this.rowIndex() * this.columns;
            }

            @Override
            public double get() {
                return this.currentNonZero ? CRSMatrix.this.values[this.k] : 0.0;
            }

            @Override
            public void set(double value) {
                if (this.currentNonZero) {
                    if (value == 0.0) {
                        CRSMatrix.this.remove(this.k, this.rowIndex());
                        this.currentNonZero = false;
                    } else {
                        ((CRSMatrix)CRSMatrix.this).values[this.k] = value;
                    }
                } else {
                    CRSMatrix.this.insert(this.k, this.rowIndex(), this.columnIndex(), value);
                    this.currentNonZero = true;
                }
            }

            @Override
            public boolean hasNext() {
                return (long)(this.i + 1) < this.limit;
            }

            @Override
            public Double next() {
                if (this.currentNonZero) {
                    ++this.k;
                }
                ++this.i;
                this.currentNonZero = this.k < CRSMatrix.this.rowPointers[this.rowIndex() + 1] && CRSMatrix.this.columnIndices[this.k] == this.columnIndex();
                return this.get();
            }
        };
    }

    @Override
    public RowMajorMatrixIterator nonZeroRowMajorIterator() {
        return new RowMajorMatrixIterator(this.rows, this.columns){
            private int i;
            private int k;
            private boolean currentIsRemoved;
            private int removedIndex;
            {
                this.i = 0;
                this.k = -1;
                this.currentIsRemoved = false;
                this.removedIndex = -1;
            }

            @Override
            public int rowIndex() {
                return this.i;
            }

            @Override
            public int columnIndex() {
                return this.currentIsRemoved ? this.removedIndex : CRSMatrix.this.columnIndices[this.k];
            }

            @Override
            public double get() {
                return this.currentIsRemoved ? 0.0 : CRSMatrix.this.values[this.k];
            }

            @Override
            public void set(double value) {
                if (value == 0.0 && !this.currentIsRemoved) {
                    this.currentIsRemoved = true;
                    this.removedIndex = CRSMatrix.this.columnIndices[this.k];
                    CRSMatrix.this.remove(this.k--, this.i);
                } else if (value != 0.0 && !this.currentIsRemoved) {
                    ((CRSMatrix)CRSMatrix.this).values[this.k] = value;
                } else {
                    this.currentIsRemoved = false;
                    CRSMatrix.this.insert(++this.k, this.i, this.removedIndex, value);
                }
            }

            @Override
            public boolean hasNext() {
                return this.k + 1 < CRSMatrix.this.cardinality;
            }

            @Override
            public Double next() {
                this.currentIsRemoved = false;
                ++this.k;
                while (CRSMatrix.this.rowPointers[this.i + 1] == this.k) {
                    ++this.i;
                }
                return this.get();
            }
        };
    }

    @Override
    public VectorIterator nonZeroIteratorOfRow(int i) {
        final int ii = i;
        return new VectorIterator(this.columns){
            private int k;
            private boolean currentIsRemoved;
            private int removedIndex;
            {
                super(length);
                this.k = CRSMatrix.this.rowPointers[ii] - 1;
                this.currentIsRemoved = false;
                this.removedIndex = -1;
            }

            @Override
            public int index() {
                return this.currentIsRemoved ? this.removedIndex : CRSMatrix.this.columnIndices[this.k];
            }

            @Override
            public double get() {
                return this.currentIsRemoved ? 0.0 : CRSMatrix.this.values[this.k];
            }

            @Override
            public void set(double value) {
                if (value == 0.0 && !this.currentIsRemoved) {
                    this.currentIsRemoved = true;
                    this.removedIndex = CRSMatrix.this.columnIndices[this.k];
                    CRSMatrix.this.remove(this.k--, ii);
                } else if (value != 0.0 && !this.currentIsRemoved) {
                    ((CRSMatrix)CRSMatrix.this).values[this.k] = value;
                } else {
                    this.currentIsRemoved = false;
                    CRSMatrix.this.insert(++this.k, ii, this.removedIndex, value);
                }
            }

            @Override
            public boolean hasNext() {
                return this.k + 1 < CRSMatrix.this.rowPointers[ii + 1];
            }

            @Override
            public Double next() {
                this.currentIsRemoved = false;
                return CRSMatrix.this.values[++this.k];
            }
        };
    }

    @Override
    public VectorIterator iteratorOfRow(int i) {
        final int ii = i;
        return new VectorIterator(this.columns){
            private int j;
            private int k;
            {
                super(length);
                this.j = -1;
                this.k = CRSMatrix.this.rowPointers[ii];
            }

            @Override
            public int index() {
                return this.j;
            }

            @Override
            public double get() {
                if (this.k < CRSMatrix.this.rowPointers[ii + 1] && CRSMatrix.this.columnIndices[this.k] == this.j) {
                    return CRSMatrix.this.values[this.k];
                }
                return 0.0;
            }

            @Override
            public void set(double value) {
                if (this.k < CRSMatrix.this.rowPointers[ii + 1] && CRSMatrix.this.columnIndices[this.k] == this.j) {
                    if (value == 0.0) {
                        CRSMatrix.this.remove(this.k, ii);
                    } else {
                        ((CRSMatrix)CRSMatrix.this).values[this.k] = value;
                    }
                } else {
                    CRSMatrix.this.insert(this.k, ii, this.j, value);
                }
            }

            @Override
            public boolean hasNext() {
                return this.j + 1 < CRSMatrix.this.columns;
            }

            @Override
            public Double next() {
                ++this.j;
                if (this.k < CRSMatrix.this.rowPointers[ii + 1] && CRSMatrix.this.columnIndices[this.k] == this.j - 1) {
                    ++this.k;
                }
                return this.get();
            }
        };
    }

    @Override
    public byte[] toBinary() {
        int i;
        int size = 13 + 8 * this.cardinality + 4 * this.cardinality + 4 * (this.rows + 1);
        ByteBuffer buffer = ByteBuffer.allocate(size);
        buffer.put((byte)32);
        buffer.putInt(this.rows);
        buffer.putInt(this.columns);
        buffer.putInt(this.cardinality);
        for (i = 0; i < this.cardinality; ++i) {
            buffer.putInt(this.columnIndices[i]);
            buffer.putDouble(this.values[i]);
        }
        for (i = 0; i < this.rows + 1; ++i) {
            buffer.putInt(this.rowPointers[i]);
        }
        return buffer.array();
    }
}

