/*
 * Decompiled with CFR 0.152.
 */
package org.matheclipse.parser.test.eval;

import junit.framework.TestCase;
import org.junit.Assert;
import org.matheclipse.parser.client.Parser;
import org.matheclipse.parser.client.ast.ASTNode;
import org.matheclipse.parser.client.ast.FunctionNode;
import org.matheclipse.parser.client.eval.BooleanVariable;
import org.matheclipse.parser.client.eval.ComplexEvaluator;
import org.matheclipse.parser.client.eval.ComplexVariable;
import org.matheclipse.parser.client.math.Complex;

public class EvalComplexTestCase
extends TestCase {
    public EvalComplexTestCase(String name) {
        super(name);
    }

    public void check(String in, String compareWith) {
        try {
            Parser p = new Parser();
            ASTNode obj = p.parse(in);
            ComplexEvaluator engine = new ComplexEvaluator();
            if (obj instanceof FunctionNode) {
                obj = engine.optimizeFunction((FunctionNode)obj);
            }
            Complex c = (Complex)engine.evaluateNode(obj);
            String result = ComplexEvaluator.toString(c);
            EvalComplexTestCase.assertEquals((String)result, (String)compareWith);
        }
        catch (Exception e) {
            e.printStackTrace();
            EvalComplexTestCase.assertEquals((String)"", (String)e.getMessage());
        }
    }

    public void testEval001() {
        this.check("-I", "-0.0+I*(-1.0)");
        this.check("I", "0.0+I*1.0");
        this.check("-42-I", "-42.0+I*(-1.0)");
        this.check("-42-I*1.0E10", "-42.0+I*(-1.0E10)");
        this.check("-42-I*1.0E+10", "-42.0+I*(-1.0E10)");
        this.check("-42-I*1.0E-10", "-42.0+I*(-1.0E-10)");
        this.check("42", "42.0");
        this.check("1.5", "1.5");
        this.check("-42", "-42.0");
        this.check("+42", "42.0");
        this.check("-42.1", "-42.1");
        this.check("+42.2", "42.2");
        this.check("-3/4", "-0.75");
        this.check("+3/4", "0.75");
        this.check("0^2", "0.0");
        this.check("0^0", "NaN+I*(NaN)");
        this.check("0^I", "0.0");
        this.check("I^0.5", "0.7071067811865476+I*0.7071067811865475");
        this.check("(-I)^(0.5)", "0.7071067811865476+I*(-0.7071067811865475)");
        this.check("(-1)^0.5", "0.0+I*1.0");
        this.check("3^3", "27.0");
        this.check("2^9", "511.99999999999994");
        this.check("2^3^2", "512.0000000000005");
        this.check("(2^3)^2", "63.99999999999998");
        this.check("3+4*7", "31.0");
        this.check("3+4*7*3", "87.0");
        this.check("1+2+3+4*7*3", "90.0");
        this.check("Sin[Cos[3.2]]", "-0.8405484252742996");
        this.check("Sin[Cos[3.2]*I]", "-0.0+I*(-1.1725716025387687)");
        this.check("90.0*Degree", "1.5707963267948966");
        this.check("Pi/2", "1.5707963267948966");
        this.check("3/2+Pi/2*I", "1.5+I*1.5707963267948966");
        this.check("Sin[Pi/2*Cos[Pi]]", "-1.0");
    }

    public void testEval002() {
        try {
            ComplexEvaluator engine = new ComplexEvaluator();
            Complex c = (Complex)engine.evaluate("Sin[Pi/2*Cos[Pi]]");
            EvalComplexTestCase.assertEquals((String)ComplexEvaluator.toString(c), (String)"-1.0");
        }
        catch (Exception e) {
            e.printStackTrace();
            EvalComplexTestCase.assertEquals((String)"", (String)e.getMessage());
        }
    }

    public void testEval003() {
        try {
            Parser p = new Parser();
            ASTNode obj = p.parse("x^2+3*x*I");
            ComplexVariable vc = new ComplexVariable(3.0);
            ComplexEvaluator engine = new ComplexEvaluator();
            engine.defineVariable("x", vc);
            Complex c = (Complex)engine.evaluateNode(obj);
            String result = ComplexEvaluator.toString(c);
            EvalComplexTestCase.assertEquals((String)result, (String)"9.000000000000002+I*9.0");
            vc.setValue(4.0);
            c = (Complex)engine.evaluateNode(obj);
            result = ComplexEvaluator.toString(c);
            EvalComplexTestCase.assertEquals((String)result, (String)"15.999999999999998+I*12.0");
        }
        catch (Exception e) {
            e.printStackTrace();
            EvalComplexTestCase.assertEquals((String)"", (String)e.getMessage());
        }
    }

    public void testEval006() {
        try {
            ComplexEvaluator engine = new ComplexEvaluator();
            BooleanVariable vb = new BooleanVariable(true);
            engine.defineVariable("$1", vb);
            BooleanVariable vb2 = new BooleanVariable(true);
            engine.defineVariable("$2", vb2);
            Complex cmp = (Complex)engine.evaluate("If[$1 && $2, 1, 0]");
            Assert.assertEquals((Object)ComplexEvaluator.toString(cmp), (Object)"1.0");
            vb.setValue(false);
            cmp = (Complex)engine.evaluate();
            Assert.assertEquals((Object)ComplexEvaluator.toString(cmp), (Object)"0.0");
        }
        catch (Exception e) {
            e.printStackTrace();
            Assert.assertEquals((Object)"", (Object)e.getMessage());
        }
    }

    public void testEval007() {
        try {
            ComplexEvaluator engine = new ComplexEvaluator();
            ComplexVariable vc = new ComplexVariable(3.0);
            engine.defineVariable("$1", vc);
            ComplexVariable vc2 = new ComplexVariable(-4.0);
            engine.defineVariable("$2", vc2);
            Complex cmp = (Complex)engine.evaluate("$i = $1+$2; If[$i==0, 1, -1]");
            Assert.assertEquals((Object)ComplexEvaluator.toString(cmp), (Object)"-1.0");
            vc2.setValue(-3.0);
            cmp = (Complex)engine.evaluate();
            Assert.assertEquals((Object)ComplexEvaluator.toString(cmp), (Object)"1.0");
        }
        catch (Exception e) {
            e.printStackTrace();
            Assert.assertEquals((Object)"", (Object)e.getMessage());
        }
    }
}

