/*
 * Decompiled with CFR 0.152.
 */
package org.matheclipse.parser.client.eval;

import org.matheclipse.parser.client.ast.ASTNode;
import org.matheclipse.parser.client.eval.ComplexEvaluator;
import org.matheclipse.parser.client.math.Complex;
import org.matheclipse.parser.client.math.MathUtils;

public class ComplexNode
extends ASTNode {
    private final Complex value;

    public ComplexNode(Complex comp) {
        super("ComplexNode");
        this.value = comp;
    }

    public ComplexNode(double real) {
        super("ComplexNode");
        this.value = new Complex(real, 0.0);
    }

    public ComplexNode(double real, double imag) {
        super("ComplexNode");
        this.value = new Complex(real, imag);
    }

    public Complex complexValue() {
        return this.value;
    }

    @Override
    public String toString() {
        return ComplexEvaluator.toString(this.value);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof ComplexNode) {
            return this.value == ((ComplexNode)obj).value;
        }
        return false;
    }

    @Override
    public int hashCode() {
        long rbits = MathUtils.hash(this.value.getReal());
        long ibits = MathUtils.hash(this.value.getImaginary());
        return (int)(rbits ^ ibits >>> 32);
    }
}

