/*
 * Decompiled with CFR 0.152.
 */
package org.matheclipse.core.reflection.system;

import org.matheclipse.core.eval.exception.JASConversionException;
import org.matheclipse.core.eval.exception.Validate;
import org.matheclipse.core.eval.interfaces.AbstractFunctionEvaluator;
import org.matheclipse.core.expression.F;
import org.matheclipse.core.interfaces.IAST;
import org.matheclipse.core.interfaces.IExpr;
import org.matheclipse.core.interfaces.ISymbol;
import org.matheclipse.core.reflection.system.Cancel;
import org.matheclipse.core.visit.VisitorExpr;
import org.matheclipse.parser.client.SyntaxError;

public class Together
extends AbstractFunctionEvaluator {
    private static final TogetherVisitor VISITOR = new TogetherVisitor();

    @Override
    public IExpr evaluate(IAST ast) {
        IExpr expr;
        Validate.checkSize(ast, 2);
        if (ast.arg1().isAST() && (expr = Together.together((IAST)ast.arg1())) != null) {
            return expr;
        }
        return ast.arg1();
    }

    public static IExpr together(IAST ast) {
        return F.eval(ast.accept(VISITOR));
    }

    @Override
    public void setUp(ISymbol symbol) throws SyntaxError {
        symbol.setAttributes(128);
        super.setUp(symbol);
    }

    static class TogetherVisitor
    extends VisitorExpr {
        @Override
        public IExpr visit(IAST ast) {
            IExpr temp = this.visitAST(ast);
            IAST astTemp = ast;
            if (temp != null) {
                if (temp.isAST()) {
                    astTemp = (IAST)temp;
                } else {
                    return temp;
                }
            }
            if (astTemp.isPlus()) {
                return this.visitPlus(astTemp);
            }
            if (astTemp.isTimes() || astTemp.isPower()) {
                try {
                    return Cancel.cancelPowerTimes(astTemp);
                }
                catch (JASConversionException jce) {
                    // empty catch block
                }
            }
            return astTemp;
        }

        private IExpr visitPlus(IAST plusAST) {
            int i;
            if (plusAST.size() <= 1) {
                return plusAST;
            }
            IAST numer = F.ast(F.Plus, plusAST.size(), false);
            IAST denom = F.ast(F.Times, plusAST.size(), false);
            for (i = 1; i < plusAST.size(); ++i) {
                numer.add(i, F.eval(F.Numerator((IExpr)plusAST.get(i))));
                denom.add(i, F.eval(F.Denominator((IExpr)plusAST.get(i))));
            }
            for (i = 1; i < plusAST.size(); ++i) {
                IAST ni = F.Times((IExpr)numer.get(i));
                for (int j = 1; j < plusAST.size(); ++j) {
                    IExpr temp;
                    if (i == j || (temp = (IExpr)denom.get(j)).equals(F.C1)) continue;
                    ni.add(temp);
                }
                numer.set(i, ni);
            }
            i = 1;
            while (denom.size() > i) {
                if (((IExpr)denom.get(i)).equals(F.C1)) {
                    denom.remove(i);
                    continue;
                }
                ++i;
            }
            IExpr exprNumerator = F.evalExpandAll(numer);
            if (denom.size() == 1) {
                return exprNumerator;
            }
            IExpr exprDenominator = F.evalExpandAll(denom);
            if (!exprDenominator.equals(F.C1)) {
                try {
                    IExpr[] result = Cancel.cancelGCD(exprNumerator, exprDenominator);
                    if (result != null) {
                        return F.Times(result[0], result[1], F.Power(result[2], F.CN1));
                    }
                }
                catch (JASConversionException jce) {
                    // empty catch block
                }
            }
            return F.Times(exprNumerator, (IExpr)F.Power(exprDenominator, F.CN1));
        }
    }
}

