/*
 * Decompiled with CFR 0.152.
 */
package org.matheclipse.core.reflection.system;

import com.google.common.base.Predicate;
import java.util.HashMap;
import org.matheclipse.core.eval.exception.Validate;
import org.matheclipse.core.expression.F;
import org.matheclipse.core.generic.Functors;
import org.matheclipse.core.interfaces.IAST;
import org.matheclipse.core.interfaces.IExpr;
import org.matheclipse.core.interfaces.IInteger;
import org.matheclipse.core.interfaces.ISymbol;
import org.matheclipse.core.reflection.system.Table;

public class Sum
extends Table {
    private static HashMap<IExpr, IExpr> MAP_0_N = new HashMap();

    @Override
    public IExpr evaluate(IAST ast) {
        IExpr temp;
        IAST list;
        Validate.checkRange(ast, 3);
        IExpr arg1 = ast.arg1();
        if (arg1.isPlus()) {
            IAST sum = ast.clone();
            sum.set(1, F.Null);
            return ((IAST)arg1).map(Functors.replace1st(sum));
        }
        IExpr arg2 = (IExpr)ast.get(2);
        if (ast.size() == 3 && arg2.isList() && ((IAST)arg2).size() == 4 ? (list = (IAST)arg2).arg1().isSymbol() && ((IExpr)list.get(2)).isInteger() && ((IExpr)list.get(3)).isSymbol() && (temp = this.definiteSum(arg1, list)) != null : ast.size() == 3 && arg2.isSymbol() && (temp = this.indefiniteSum(arg1, (ISymbol)arg2)) != null) {
            return temp;
        }
        IAST resultList = F.Plus();
        temp = Sum.evaluateTable(ast, resultList, F.C0);
        if (temp == null || temp.equals(resultList)) {
            return null;
        }
        return temp;
    }

    public IExpr definiteSum(IExpr arg1, IAST list) {
        final ISymbol var = (ISymbol)list.arg1();
        IInteger from = (IInteger)list.get(2);
        final ISymbol to = (ISymbol)list.get(3);
        if (arg1.isFree(var, true) && arg1.isFree(to, true)) {
            if (from.equals(F.C1)) {
                return F.Times((IExpr)to, arg1);
            }
            if (from.equals(F.C0)) {
                return F.Times((IExpr)F.Plus((IExpr)to, (IExpr)F.C1), arg1);
            }
        } else {
            if (arg1.isTimes()) {
                IAST filterCollector = F.Times();
                IAST restCollector = F.Times();
                ((IAST)arg1).filter(filterCollector, restCollector, new Predicate<IExpr>(){

                    public boolean apply(IExpr input) {
                        return input.isFree(var, true) && input.isFree(to, true);
                    }
                });
                if (filterCollector.size() > 1) {
                    if (restCollector.size() == 2) {
                        filterCollector.add(F.Sum(restCollector.arg1(), list));
                    } else {
                        filterCollector.add(F.Sum(restCollector, list));
                    }
                    return filterCollector;
                }
            }
            if (from.equals(F.C0)) {
                IExpr temp;
                if (arg1.isPower()) {
                    return this.sumPower((IAST)arg1, var, to);
                }
                if (arg1.equals(var)) {
                    return this.sumPowerFormula(to, F.C1);
                }
                IExpr repl = arg1.replaceAll(F.List((IExpr)F.Rule(var, F.Slot(F.C1)), (IExpr)F.Rule(to, F.Slot(F.C2))));
                if (repl != null && (temp = MAP_0_N.get(repl)) != null) {
                    return temp.replaceAll(F.Rule(F.Slot(F.C1), to));
                }
            }
        }
        if (from.isPositive()) {
            return F.Subtract(F.Sum(arg1, F.List(var, F.C0, to)), F.Sum(arg1, F.List(var, F.C0, from.minus(F.C1))));
        }
        return null;
    }

    public IExpr indefiniteSum(IExpr arg1, final ISymbol var) {
        IExpr temp;
        IExpr repl;
        if (arg1.isTimes()) {
            IAST filterCollector = F.Times();
            IAST restCollector = F.Times();
            ((IAST)arg1).filter(filterCollector, restCollector, new Predicate<IExpr>(){

                public boolean apply(IExpr input) {
                    return input.isFree(var, true);
                }
            });
            if (filterCollector.size() > 1) {
                if (restCollector.size() == 2) {
                    filterCollector.add(F.Sum(restCollector.arg1(), var));
                } else {
                    filterCollector.add(F.Sum(restCollector, var));
                }
                return filterCollector;
            }
        } else {
            if (arg1.isPower()) {
                return this.sumPower((IAST)arg1, var, var);
            }
            if (arg1.equals(var)) {
                return this.sumPowerFormula(var, F.C1);
            }
        }
        if ((repl = arg1.replaceAll(F.List((IExpr)F.Rule(var, F.Slot(F.C1))))) != null && (temp = MAP_0_N.get(repl)) != null) {
            return temp.replaceAll(F.Rule(F.Slot(F.C1), var));
        }
        return null;
    }

    public IExpr sumPower(IAST powAST, ISymbol var, IExpr to) {
        IInteger p;
        if (powAST.arg1().equals(var) && ((IExpr)powAST.get(2)).isInteger() && (p = (IInteger)powAST.get(2)).isPositive()) {
            return this.sumPowerFormula(to, p);
        }
        return null;
    }

    public IExpr sumPowerFormula(IExpr to, IInteger p) {
        return F.eval(F.ExpandAll(F.Plus((IExpr)F.Times((IExpr)F.Power((IExpr)F.Plus(to, (IExpr)F.C1), F.Plus((IExpr)p, (IExpr)F.C1)), (IExpr)F.Power((IExpr)F.Plus((IExpr)p, (IExpr)F.C1), F.CN1)), (IExpr)F.Sum(F.Times((IExpr)F.Times((IExpr)F.Times((IExpr)F.Power((IExpr)F.Plus(to, (IExpr)F.C1), F.Plus((IExpr)F.Plus((IExpr)p, (IExpr)F.Times((IExpr)F.CN1, (IExpr)F.k)), (IExpr)F.C1)), (IExpr)F.Binomial(p, F.k)), (IExpr)F.BernoulliB(F.k)), (IExpr)F.Power((IExpr)F.Plus((IExpr)F.Plus((IExpr)p, (IExpr)F.Times((IExpr)F.CN1, (IExpr)F.k)), (IExpr)F.C1), F.CN1)), F.List(F.k, F.C1, p)))));
    }

    static {
        MAP_0_N.put(F.Binomial(F.Slot(F.C2), F.Slot(F.C1)), F.Power((IExpr)F.C2, F.Slot(F.C1)));
        MAP_0_N.put(F.Times((IExpr)F.Slot(F.C1), (IExpr)F.Binomial(F.Slot(F.C2), F.Slot(F.C1))), F.Times((IExpr)F.Slot(F.C1), (IExpr)F.Power((IExpr)F.C2, F.Plus((IExpr)F.Slot(F.C1), (IExpr)F.Times((IExpr)F.CN1, (IExpr)F.C1)))));
    }
}

