/*
 * Decompiled with CFR 0.152.
 */
package org.matheclipse.core.reflection.system;

import java.math.BigInteger;
import org.matheclipse.core.eval.exception.Validate;
import org.matheclipse.core.eval.interfaces.AbstractFunctionEvaluator;
import org.matheclipse.core.expression.F;
import org.matheclipse.core.interfaces.IAST;
import org.matheclipse.core.interfaces.IExpr;
import org.matheclipse.core.interfaces.IInteger;

public class PowerMod
extends AbstractFunctionEvaluator {
    @Override
    public IExpr evaluate(IAST ast) {
        Validate.checkSize(ast, 4);
        for (int i = 1; i < ast.size(); ++i) {
            if (((IExpr)ast.get(i)).isInteger()) continue;
            return null;
        }
        try {
            BigInteger bigResult = PowerMod.powerMod(((IInteger)ast.arg1()).getBigNumerator(), ((IInteger)ast.get(2)).getBigNumerator(), ((IInteger)ast.arg3()).getBigNumerator());
            return F.integer(bigResult);
        }
        catch (ArithmeticException ae) {
            ae.printStackTrace();
            return null;
        }
    }

    public static BigInteger powerMod(BigInteger a, BigInteger b, BigInteger m) throws ArithmeticException {
        return a.modPow(b, m);
    }
}

