/*
 * Decompiled with CFR 0.152.
 */
package org.matheclipse.core.reflection.system;

import edu.jas.arith.ModLong;
import edu.jas.arith.ModLongRing;
import edu.jas.poly.ExpVector;
import edu.jas.poly.GenPolynomial;
import edu.jas.poly.Monomial;
import edu.jas.poly.TermOrder;
import java.util.List;
import org.matheclipse.core.convert.ExprVariables;
import org.matheclipse.core.convert.JASIExpr;
import org.matheclipse.core.convert.JASModInteger;
import org.matheclipse.core.eval.exception.JASConversionException;
import org.matheclipse.core.eval.exception.Validate;
import org.matheclipse.core.eval.interfaces.AbstractFunctionEvaluator;
import org.matheclipse.core.eval.util.Options;
import org.matheclipse.core.expression.ExprRingFactory;
import org.matheclipse.core.expression.F;
import org.matheclipse.core.interfaces.IAST;
import org.matheclipse.core.interfaces.IExpr;
import org.matheclipse.core.interfaces.ISignedNumber;
import org.matheclipse.core.interfaces.IStringX;
import org.matheclipse.core.interfaces.ISymbol;

public class MonomialList
extends AbstractFunctionEvaluator {
    @Override
    public IExpr evaluate(IAST ast) {
        ExprVariables eVar;
        Validate.checkRange(ast, 2, 5);
        IExpr expr = F.evalExpandAll(ast.arg1());
        if (ast.size() == 2) {
            eVar = new ExprVariables(ast.arg1());
        } else {
            IAST symbolList = Validate.checkSymbolOrSymbolList(ast, 2);
            eVar = new ExprVariables(symbolList);
        }
        int termOrder = 2;
        try {
            if (ast.size() > 3) {
                Options options;
                IExpr option;
                String orderStr;
                if (ast.arg3() instanceof IStringX && (orderStr = ast.arg3().toString()).equals("DegreeLexicographic")) {
                    termOrder = 1;
                }
                if ((option = (options = new Options(ast.topHead(), ast, 2)).getOption("Modulus")) != null && option.isSignedNumber()) {
                    return MonomialList.monomialListModulus(expr, eVar.getArrayList(), termOrder, option);
                }
            }
            return MonomialList.monomialList(expr, eVar.getArrayList(), termOrder);
        }
        catch (JASConversionException jce) {
            return null;
        }
    }

    public static IAST monomialList(IExpr polynomial, List<IExpr> variablesList, int termOrder) throws JASConversionException {
        JASIExpr jas = new JASIExpr(variablesList, new ExprRingFactory(), new TermOrder(termOrder));
        GenPolynomial<IExpr> polyExpr = jas.expr2IExprJAS(polynomial);
        IAST list = F.List();
        for (Monomial monomial : polyExpr) {
            IExpr coeff = (IExpr)monomial.coefficient();
            ExpVector exp = monomial.exponent();
            IAST monomTimes = F.Times(coeff);
            for (int i = 0; i < exp.length(); ++i) {
                long lExp = exp.getVal(i);
                if (lExp == 0L) continue;
                ISymbol variable = (ISymbol)variablesList.get(i);
                monomTimes.add(F.Power((IExpr)variable, F.integer(lExp)));
            }
            list.add(monomTimes);
        }
        return list;
    }

    private static IAST monomialListModulus(IExpr polynomial, List<IExpr> variablesList, int termOrder, IExpr option) throws JASConversionException {
        try {
            ModLongRing modIntegerRing = JASModInteger.option2ModLongRing((ISignedNumber)option);
            JASModInteger jas = new JASModInteger(variablesList, modIntegerRing);
            GenPolynomial<ModLong> polyExpr = jas.expr2JAS(polynomial);
            IAST list = F.List();
            for (Monomial monomial : polyExpr) {
                ModLong coeff = (ModLong)monomial.coefficient();
                ExpVector exp = monomial.exponent();
                IAST monomTimes = F.Times((IExpr)F.integer(coeff.getVal()));
                for (int i = 0; i < exp.length(); ++i) {
                    long lExp = exp.getVal(i);
                    if (lExp == 0L) continue;
                    ISymbol variable = (ISymbol)variablesList.get(i);
                    monomTimes.add(F.Power((IExpr)variable, F.integer(lExp)));
                }
                list.add(monomTimes);
            }
            return list;
        }
        catch (ArithmeticException ae) {
            return null;
        }
    }
}

