/*
 * Decompiled with CFR 0.152.
 */
package org.matheclipse.core.reflection.system;

import com.google.common.base.Predicate;
import edu.jas.arith.BigRational;
import edu.jas.poly.ExpVector;
import edu.jas.poly.GenPolynomial;
import edu.jas.poly.Monomial;
import edu.jas.structure.RingElem;
import edu.jas.ufd.FactorAbstract;
import edu.jas.ufd.FactorFactory;
import edu.jas.ufd.SquarefreeAbstract;
import edu.jas.ufd.SquarefreeFactory;
import java.io.PrintStream;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.List;
import java.util.SortedMap;
import org.matheclipse.core.convert.JASConvert;
import org.matheclipse.core.eval.EvalEngine;
import org.matheclipse.core.eval.exception.JASConversionException;
import org.matheclipse.core.eval.exception.RecursionLimitExceeded;
import org.matheclipse.core.eval.interfaces.AbstractFunctionEvaluator;
import org.matheclipse.core.expression.ASTRange;
import org.matheclipse.core.expression.F;
import org.matheclipse.core.expression.Symbol;
import org.matheclipse.core.generic.BinaryEval;
import org.matheclipse.core.generic.Functors;
import org.matheclipse.core.generic.Predicates;
import org.matheclipse.core.integrate.rubi.IndefiniteIntegrationRules0;
import org.matheclipse.core.integrate.rubi.IndefiniteIntegrationRules1;
import org.matheclipse.core.integrate.rubi.IndefiniteIntegrationRules10;
import org.matheclipse.core.integrate.rubi.IndefiniteIntegrationRules11;
import org.matheclipse.core.integrate.rubi.IndefiniteIntegrationRules12;
import org.matheclipse.core.integrate.rubi.IndefiniteIntegrationRules13;
import org.matheclipse.core.integrate.rubi.IndefiniteIntegrationRules14;
import org.matheclipse.core.integrate.rubi.IndefiniteIntegrationRules15;
import org.matheclipse.core.integrate.rubi.IndefiniteIntegrationRules16;
import org.matheclipse.core.integrate.rubi.IndefiniteIntegrationRules2;
import org.matheclipse.core.integrate.rubi.IndefiniteIntegrationRules3;
import org.matheclipse.core.integrate.rubi.IndefiniteIntegrationRules4;
import org.matheclipse.core.integrate.rubi.IndefiniteIntegrationRules5;
import org.matheclipse.core.integrate.rubi.IndefiniteIntegrationRules6;
import org.matheclipse.core.integrate.rubi.IndefiniteIntegrationRules7;
import org.matheclipse.core.integrate.rubi.IndefiniteIntegrationRules8;
import org.matheclipse.core.integrate.rubi.IndefiniteIntegrationRules9;
import org.matheclipse.core.integrate.rubi.UtilityFunctions0;
import org.matheclipse.core.integrate.rubi.UtilityFunctions1;
import org.matheclipse.core.integrate.rubi.UtilityFunctions2;
import org.matheclipse.core.integrate.rubi.UtilityFunctions3;
import org.matheclipse.core.integrate.rubi.UtilityFunctions4;
import org.matheclipse.core.integrate.rubi.UtilityFunctions5;
import org.matheclipse.core.integrate.rubi42.IntegrationRulesForExpressionsInvolvingAlgebraicBinomialsOfTheFollowingForms0;
import org.matheclipse.core.integrate.rubi42.IntegrationRulesForExpressionsInvolvingAlgebraicBinomialsOfTheFollowingForms1;
import org.matheclipse.core.integrate.rubi42.IntegrationRulesForExpressionsInvolvingAlgebraicBinomialsOfTheFollowingForms2;
import org.matheclipse.core.integrate.rubi42.IntegrationRulesForExpressionsInvolvingAlgebraicTrinomialsOfTheFollowingForms0;
import org.matheclipse.core.integrate.rubi42.IntegrationRulesForExpressionsInvolvingAlgebraicTrinomialsOfTheFollowingForms1;
import org.matheclipse.core.integrate.rubi42.IntegrationRulesForExpressionsInvolvingAlgebraicTrinomialsOfTheFollowingForms2;
import org.matheclipse.core.integrate.rubi42.IntegrationRulesForExpressionsInvolvingAlgebraicTrinomialsOfTheFollowingForms3;
import org.matheclipse.core.integrate.rubi42.IntegrationRulesForExpressionsInvolvingAlgebraicTrinomialsOfTheFollowingForms4;
import org.matheclipse.core.integrate.rubi42.IntegrationRulesForExpressionsInvolvingAlgebraicTrinomialsOfTheFollowingForms5;
import org.matheclipse.core.integrate.rubi42.IntegrationRulesForExpressionsInvolvingAlgebraicTrinomialsOfTheFollowingForms6;
import org.matheclipse.core.integrate.rubi42.IntegrationRulesForExpressionsInvolvingExponentialOrLogarithmFunctions0;
import org.matheclipse.core.integrate.rubi42.IntegrationRulesForExpressionsInvolvingExponentialOrLogarithmFunctions1;
import org.matheclipse.core.integrate.rubi42.IntegrationRulesForExpressionsInvolvingExponentialOrLogarithmFunctions2;
import org.matheclipse.core.integrate.rubi42.IntegrationRulesForExpressionsInvolvingExponentialOrLogarithmFunctions3;
import org.matheclipse.core.integrate.rubi42.IntegrationRulesForExpressionsInvolvingHyperbolicFunctionsOfTheFollowingForms0;
import org.matheclipse.core.integrate.rubi42.IntegrationRulesForExpressionsInvolvingHyperbolicFunctionsOfTheFollowingForms1;
import org.matheclipse.core.integrate.rubi42.IntegrationRulesForExpressionsInvolvingHyperbolicFunctionsOfTheFollowingForms2;
import org.matheclipse.core.integrate.rubi42.IntegrationRulesForExpressionsInvolvingHyperbolicFunctionsOfTheFollowingForms3;
import org.matheclipse.core.integrate.rubi42.IntegrationRulesForExpressionsInvolvingHyperbolicFunctionsOfTheFollowingForms4;
import org.matheclipse.core.integrate.rubi42.IntegrationRulesForExpressionsInvolvingHyperbolicFunctionsOfTheFollowingForms5;
import org.matheclipse.core.integrate.rubi42.IntegrationRulesForExpressionsInvolvingSpecialFunctions0;
import org.matheclipse.core.integrate.rubi42.IntegrationRulesForExpressionsInvolvingTrigFunctionsOfTheFollowingForms0;
import org.matheclipse.core.integrate.rubi42.IntegrationRulesForExpressionsInvolvingTrigFunctionsOfTheFollowingForms1;
import org.matheclipse.core.integrate.rubi42.IntegrationRulesForExpressionsInvolvingTrigFunctionsOfTheFollowingForms10;
import org.matheclipse.core.integrate.rubi42.IntegrationRulesForExpressionsInvolvingTrigFunctionsOfTheFollowingForms11;
import org.matheclipse.core.integrate.rubi42.IntegrationRulesForExpressionsInvolvingTrigFunctionsOfTheFollowingForms12;
import org.matheclipse.core.integrate.rubi42.IntegrationRulesForExpressionsInvolvingTrigFunctionsOfTheFollowingForms13;
import org.matheclipse.core.integrate.rubi42.IntegrationRulesForExpressionsInvolvingTrigFunctionsOfTheFollowingForms14;
import org.matheclipse.core.integrate.rubi42.IntegrationRulesForExpressionsInvolvingTrigFunctionsOfTheFollowingForms15;
import org.matheclipse.core.integrate.rubi42.IntegrationRulesForExpressionsInvolvingTrigFunctionsOfTheFollowingForms16;
import org.matheclipse.core.integrate.rubi42.IntegrationRulesForExpressionsInvolvingTrigFunctionsOfTheFollowingForms17;
import org.matheclipse.core.integrate.rubi42.IntegrationRulesForExpressionsInvolvingTrigFunctionsOfTheFollowingForms18;
import org.matheclipse.core.integrate.rubi42.IntegrationRulesForExpressionsInvolvingTrigFunctionsOfTheFollowingForms19;
import org.matheclipse.core.integrate.rubi42.IntegrationRulesForExpressionsInvolvingTrigFunctionsOfTheFollowingForms2;
import org.matheclipse.core.integrate.rubi42.IntegrationRulesForExpressionsInvolvingTrigFunctionsOfTheFollowingForms20;
import org.matheclipse.core.integrate.rubi42.IntegrationRulesForExpressionsInvolvingTrigFunctionsOfTheFollowingForms21;
import org.matheclipse.core.integrate.rubi42.IntegrationRulesForExpressionsInvolvingTrigFunctionsOfTheFollowingForms22;
import org.matheclipse.core.integrate.rubi42.IntegrationRulesForExpressionsInvolvingTrigFunctionsOfTheFollowingForms23;
import org.matheclipse.core.integrate.rubi42.IntegrationRulesForExpressionsInvolvingTrigFunctionsOfTheFollowingForms24;
import org.matheclipse.core.integrate.rubi42.IntegrationRulesForExpressionsInvolvingTrigFunctionsOfTheFollowingForms25;
import org.matheclipse.core.integrate.rubi42.IntegrationRulesForExpressionsInvolvingTrigFunctionsOfTheFollowingForms26;
import org.matheclipse.core.integrate.rubi42.IntegrationRulesForExpressionsInvolvingTrigFunctionsOfTheFollowingForms27;
import org.matheclipse.core.integrate.rubi42.IntegrationRulesForExpressionsInvolvingTrigFunctionsOfTheFollowingForms28;
import org.matheclipse.core.integrate.rubi42.IntegrationRulesForExpressionsInvolvingTrigFunctionsOfTheFollowingForms29;
import org.matheclipse.core.integrate.rubi42.IntegrationRulesForExpressionsInvolvingTrigFunctionsOfTheFollowingForms3;
import org.matheclipse.core.integrate.rubi42.IntegrationRulesForExpressionsInvolvingTrigFunctionsOfTheFollowingForms30;
import org.matheclipse.core.integrate.rubi42.IntegrationRulesForExpressionsInvolvingTrigFunctionsOfTheFollowingForms31;
import org.matheclipse.core.integrate.rubi42.IntegrationRulesForExpressionsInvolvingTrigFunctionsOfTheFollowingForms32;
import org.matheclipse.core.integrate.rubi42.IntegrationRulesForExpressionsInvolvingTrigFunctionsOfTheFollowingForms33;
import org.matheclipse.core.integrate.rubi42.IntegrationRulesForExpressionsInvolvingTrigFunctionsOfTheFollowingForms34;
import org.matheclipse.core.integrate.rubi42.IntegrationRulesForExpressionsInvolvingTrigFunctionsOfTheFollowingForms35;
import org.matheclipse.core.integrate.rubi42.IntegrationRulesForExpressionsInvolvingTrigFunctionsOfTheFollowingForms36;
import org.matheclipse.core.integrate.rubi42.IntegrationRulesForExpressionsInvolvingTrigFunctionsOfTheFollowingForms37;
import org.matheclipse.core.integrate.rubi42.IntegrationRulesForExpressionsInvolvingTrigFunctionsOfTheFollowingForms4;
import org.matheclipse.core.integrate.rubi42.IntegrationRulesForExpressionsInvolvingTrigFunctionsOfTheFollowingForms5;
import org.matheclipse.core.integrate.rubi42.IntegrationRulesForExpressionsInvolvingTrigFunctionsOfTheFollowingForms6;
import org.matheclipse.core.integrate.rubi42.IntegrationRulesForExpressionsInvolvingTrigFunctionsOfTheFollowingForms7;
import org.matheclipse.core.integrate.rubi42.IntegrationRulesForExpressionsInvolvingTrigFunctionsOfTheFollowingForms8;
import org.matheclipse.core.integrate.rubi42.IntegrationRulesForExpressionsInvolvingTrigFunctionsOfTheFollowingForms9;
import org.matheclipse.core.integrate.rubi42.IntegrationRulesForMiscellaneousExpressions0;
import org.matheclipse.core.integrate.rubi42.IntegrationRulesForMiscellaneousExpressions1;
import org.matheclipse.core.integrate.rubi42.IntegrationRulesForMiscellaneousExpressions10;
import org.matheclipse.core.integrate.rubi42.IntegrationRulesForMiscellaneousExpressions11;
import org.matheclipse.core.integrate.rubi42.IntegrationRulesForMiscellaneousExpressions12;
import org.matheclipse.core.integrate.rubi42.IntegrationRulesForMiscellaneousExpressions13;
import org.matheclipse.core.integrate.rubi42.IntegrationRulesForMiscellaneousExpressions2;
import org.matheclipse.core.integrate.rubi42.IntegrationRulesForMiscellaneousExpressions3;
import org.matheclipse.core.integrate.rubi42.IntegrationRulesForMiscellaneousExpressions4;
import org.matheclipse.core.integrate.rubi42.IntegrationRulesForMiscellaneousExpressions5;
import org.matheclipse.core.integrate.rubi42.IntegrationRulesForMiscellaneousExpressions6;
import org.matheclipse.core.integrate.rubi42.IntegrationRulesForMiscellaneousExpressions7;
import org.matheclipse.core.integrate.rubi42.IntegrationRulesForMiscellaneousExpressions8;
import org.matheclipse.core.integrate.rubi42.IntegrationRulesForMiscellaneousExpressions9;
import org.matheclipse.core.integrate.rubi42.UtilityFunctions;
import org.matheclipse.core.interfaces.IAST;
import org.matheclipse.core.interfaces.IExpr;
import org.matheclipse.core.interfaces.IFraction;
import org.matheclipse.core.interfaces.IInteger;
import org.matheclipse.core.interfaces.ISymbol;
import org.matheclipse.core.polynomials.PartialFractionIntegrateGenerator;
import org.matheclipse.core.reflection.system.Apart;
import org.matheclipse.core.reflection.system.PolynomialQ;

public class Integrate
extends AbstractFunctionEvaluator {
    public static final Integrate CONST = new Integrate();

    @Override
    public IExpr evaluate(IAST ast) {
        IExpr temp;
        IAST xList;
        if (ast.size() < 3) {
            return null;
        }
        IExpr fx = ast.arg1();
        if (ast.size() > 3) {
            return ast.range(2).foldRight(new BinaryEval(F.Integrate), fx);
        }
        if (ast.arg1().isAST() && (fx = F.eval(F.Expand(ast.arg1()))).isPlus()) {
            return ((IAST)fx).map(Functors.replace1st(F.Integrate(F.Null, ast.arg2())));
        }
        if (ast.arg2().isList() && (xList = (IAST)ast.arg2()).isVector() == 3) {
            IAST clone = ast.clone();
            clone.set(2, xList.arg1());
            temp = F.eval(clone);
            if (temp.isFree(F.Integrate, true)) {
                IExpr Fb = F.eval(F.subst(temp, F.Rule(xList.arg1(), (IExpr)xList.get(3))));
                IExpr Fa = F.eval(F.subst(temp, F.Rule(xList.arg1(), xList.arg2())));
                EvalEngine engine = EvalEngine.get();
                if (!Fb.isFree(F.DirectedInfinity, true) || !Fb.isFree(F.Indeterminate, true)) {
                    PrintStream stream = engine.getOutPrintStream();
                    if (stream == null) {
                        stream = System.out;
                    }
                    if (!engine.isQuietMode()) {
                        stream.println("Not integrable: " + temp + " for " + xList.arg1() + " = " + xList.get(3));
                    }
                    return null;
                }
                if (!Fa.isFree(F.DirectedInfinity, true) || !Fa.isFree(F.Indeterminate, true)) {
                    PrintStream stream = engine.getOutPrintStream();
                    if (stream == null) {
                        stream = System.out;
                    }
                    if (!engine.isQuietMode()) {
                        stream.println("Not integrable: " + temp + " for " + xList.arg1() + " = " + xList.arg2());
                    }
                    return null;
                }
                return F.Subtract(Fb, Fa);
            }
        }
        if (ast.arg2().isSymbol()) {
            final ISymbol x = (ISymbol)ast.arg2();
            if (fx.isNumber()) {
                return F.Times(fx, (IExpr)x);
            }
            if (fx.isFree(x, false)) {
                return F.Times(fx, (IExpr)x);
            }
            if (fx.equals(x)) {
                return F.Times((IExpr)F.C1D2, (IExpr)F.Power(fx, F.C2));
            }
            if (fx.isAST()) {
                IAST apartPlus;
                IExpr[] parts;
                IExpr head;
                IExpr temp2;
                IAST arg1 = (IAST)fx;
                if (arg1.size() == 2 && x.equals(arg1.arg1()) && (temp2 = this.integrate1ArgumentFunctions(head = arg1.head(), x)) != null) {
                    return temp2;
                }
                if (arg1.isPower()) {
                    IExpr i;
                    if (x.equals(arg1.arg1()) && arg1.arg2().isFree(x, false) && !(i = arg1.arg2()).isMinusOne()) {
                        i = F.Plus(i, (IExpr)F.C1);
                        return F.Times((IExpr)F.Power(i, F.CN1), (IExpr)F.Power((IExpr)x, i));
                    }
                    if (x.equals(arg1.arg2()) && arg1.arg1().isFree(x, false)) {
                        if (arg1.arg1().equals(F.E)) {
                            return arg1;
                        }
                        return F.Times((IExpr)arg1, (IExpr)F.Power((IExpr)F.Log(arg1.arg1()), F.CN1));
                    }
                }
                if (arg1.isTimes()) {
                    temp = this.integrateTimesTrigFunctions(arg1, x);
                    if (temp != null) {
                        return temp;
                    }
                    IAST filterCollector = F.Times();
                    IAST restCollector = F.Times();
                    arg1.filter(filterCollector, restCollector, new Predicate<IExpr>(){

                        public boolean apply(IExpr input) {
                            return input.isFree(x, true);
                        }
                    });
                    if (filterCollector.size() > 1) {
                        if (restCollector.size() > 1) {
                            filterCollector.add(F.Integrate(restCollector.getOneIdentity(F.C0), x));
                        }
                        return filterCollector;
                    }
                }
                if (!ast.arg1().equals(fx)) {
                    return F.Integrate.evalDownRule(EvalEngine.get(), ast);
                }
                IExpr header = arg1.head();
                if (arg1.size() >= 3 && (header == F.Times || header == F.Power) && !arg1.isEvalFlagOn(128) && ast.arg2().isSymbol() && (parts = Apart.getFractionalParts(arg1)) != null && (apartPlus = Apart.partialFractionDecompositionRational(new PartialFractionIntegrateGenerator(x), parts, x)) != null && apartPlus.size() > 1) {
                    if (apartPlus.size() == 2) {
                        if (ast.equals(apartPlus.arg1())) {
                            return null;
                        }
                        return apartPlus.arg1();
                    }
                    if (ast.equals(apartPlus)) {
                        return null;
                    }
                    return apartPlus;
                }
                return F.Integrate.evalDownRule(EvalEngine.get(), ast);
            }
        }
        return null;
    }

    private IExpr integrate1ArgumentFunctions(IExpr head, ISymbol x) {
        if (head.equals(F.ArcCos)) {
            return F.Subtract(F.Times((IExpr)x, (IExpr)F.ArcCos(x)), F.Sqrt(F.Subtract(F.C1, F.Sqr(x))));
        }
        if (head.equals(F.ArcCosh)) {
            return F.Subtract(F.Times((IExpr)x, (IExpr)F.ArcCosh(x)), F.Times((IExpr)F.Sqrt(F.Plus((IExpr)x, (IExpr)F.C1)), (IExpr)F.Sqrt(F.Plus((IExpr)x, (IExpr)F.CN1))));
        }
        if (head.equals(F.ArcCot)) {
            return F.Plus((IExpr)F.Times((IExpr)x, (IExpr)F.ArcCot(x)), (IExpr)F.Times((IExpr)F.C1D2, (IExpr)F.Log(F.Plus((IExpr)F.C1, (IExpr)F.Sqr(x)))));
        }
        if (head.equals(F.ArcCoth)) {
            return F.Plus((IExpr)F.Times((IExpr)x, (IExpr)F.ArcCoth(x)), (IExpr)F.Times((IExpr)F.C1D2, (IExpr)F.Log(F.Subtract(F.C1, F.Sqr(x)))));
        }
        if (head.equals(F.ArcCsc)) {
            return F.Plus((IExpr)F.Times((IExpr)x, (IExpr)F.ArcCsc(x)), (IExpr)F.Times(F.Sqrt(F.Plus((IExpr)F.C1, (IExpr)F.Times((IExpr)F.CN1, (IExpr)F.Power((IExpr)x, F.CN2)))), x, F.Log(F.Plus((IExpr)x, (IExpr)F.Sqrt(F.Plus((IExpr)F.CN1, (IExpr)F.Power((IExpr)x, F.C2))))), F.Power((IExpr)F.Sqrt(F.Plus((IExpr)F.CN1, (IExpr)F.Power((IExpr)x, F.C2))), F.CN1)));
        }
        if (head.equals(F.ArcCsch)) {
            return F.Times((IExpr)x, (IExpr)F.Plus((IExpr)F.ArcCsch(x), (IExpr)F.Times(F.Sqrt(F.Plus((IExpr)F.C1, (IExpr)F.Power((IExpr)x, F.CN2))), F.ArcSinh(x), F.Power((IExpr)F.Sqrt(F.Plus((IExpr)F.C1, (IExpr)F.Power((IExpr)x, F.C2))), F.CN1))));
        }
        if (head.equals(F.ArcSec)) {
            return F.Plus((IExpr)F.Times((IExpr)x, (IExpr)F.ArcSec(x)), (IExpr)F.Times(F.CN1, F.Sqrt(F.Plus((IExpr)F.C1, (IExpr)F.Times((IExpr)F.CN1, (IExpr)F.Power((IExpr)x, F.CN2)))), x, F.Log(F.Plus((IExpr)x, (IExpr)F.Sqrt(F.Plus((IExpr)F.CN1, (IExpr)F.Power((IExpr)x, F.C2))))), F.Power((IExpr)F.Sqrt(F.Plus((IExpr)F.CN1, (IExpr)F.Power((IExpr)x, F.C2))), F.CN1)));
        }
        if (head.equals(F.ArcSech)) {
            return F.Plus((IExpr)F.Times((IExpr)x, (IExpr)F.ArcSech(x)), (IExpr)F.Times(F.CN1, F.C2, F.Sqrt(F.Times((IExpr)F.Plus((IExpr)F.C1, (IExpr)F.Times((IExpr)F.CN1, (IExpr)x)), (IExpr)F.Power((IExpr)F.Plus((IExpr)F.C1, (IExpr)x), F.CN1))), F.Sqrt(F.Plus((IExpr)F.C1, (IExpr)F.Times((IExpr)F.CN1, (IExpr)F.Power((IExpr)x, F.C2)))), F.ArcSin(F.Times((IExpr)F.Sqrt(F.Plus((IExpr)F.C1, (IExpr)x)), (IExpr)F.Power((IExpr)F.Sqrt(F.C2), F.CN1))), F.Power((IExpr)F.Plus((IExpr)F.CN1, (IExpr)x), F.CN1)));
        }
        if (head.equals(F.ArcSin)) {
            return F.Plus((IExpr)F.Times((IExpr)x, (IExpr)F.ArcSin(x)), (IExpr)F.Sqrt(F.Subtract(F.C1, F.Sqr(x))));
        }
        if (head.equals(F.ArcSinh)) {
            return F.Subtract(F.Times((IExpr)x, (IExpr)F.ArcSinh(x)), F.Sqrt(F.Plus((IExpr)F.C1, (IExpr)F.Sqr(x))));
        }
        if (head.equals(F.ArcTan)) {
            return F.Subtract(F.Times((IExpr)x, (IExpr)F.ArcTan(x)), F.Times((IExpr)F.C1D2, (IExpr)F.Log(F.Plus((IExpr)F.C1, (IExpr)F.Sqr(x)))));
        }
        if (head.equals(F.ArcTanh)) {
            return F.Plus((IExpr)F.Times((IExpr)x, (IExpr)F.ArcTanh(x)), (IExpr)F.Times((IExpr)F.C1D2, (IExpr)F.Log(F.Subtract(F.C1, F.Sqr(x)))));
        }
        if (head.equals(F.Cos)) {
            return F.Sin(x);
        }
        if (head.equals(F.Cosh)) {
            return F.Sinh(x);
        }
        if (head.equals(F.Cot)) {
            return F.Log(F.Sin(x));
        }
        if (head.equals(F.Coth)) {
            return F.Log(F.Sinh(x));
        }
        if (head.equals(F.Csc)) {
            return F.Subtract(F.Log(F.Sin(F.Times((IExpr)F.C1D2, (IExpr)x))), F.Log(F.Cos(F.Times((IExpr)F.C1D2, (IExpr)x))));
        }
        if (head.equals(F.Csch)) {
            return F.Plus((IExpr)F.Times((IExpr)F.CN1, (IExpr)F.Log(F.Cosh(F.Times((IExpr)F.C1D2, (IExpr)x)))), (IExpr)F.Log(F.Sinh(F.Times((IExpr)F.C1D2, (IExpr)x))));
        }
        if (head.equals(F.Log)) {
            return F.Subtract(F.Times((IExpr)x, (IExpr)F.Log(x)), x);
        }
        if (head.equals(F.Sec)) {
            return F.Subtract(F.Log(F.Plus((IExpr)F.Sin(F.Times((IExpr)F.C1D2, (IExpr)x)), (IExpr)F.Cos(F.Times((IExpr)F.C1D2, (IExpr)x)))), F.Log(F.Subtract(F.Cos(F.Times((IExpr)F.C1D2, (IExpr)x)), F.Sin(F.Times((IExpr)F.C1D2, (IExpr)x)))));
        }
        if (head.equals(F.Sech)) {
            return F.Times((IExpr)F.C2, (IExpr)F.ArcTan(F.Tanh(F.Times((IExpr)F.C1D2, (IExpr)x))));
        }
        if (head.equals(F.Sin)) {
            return F.Times((IExpr)F.CN1, (IExpr)F.Cos(x));
        }
        if (head.equals(F.Sinh)) {
            return F.Cosh(x);
        }
        if (head.equals(F.Tan)) {
            return F.Times((IExpr)F.CN1, (IExpr)F.Log(F.Cos(x)));
        }
        if (head.equals(F.Tanh)) {
            return F.Log(F.Cosh(x));
        }
        return null;
    }

    private IExpr integrateTimesTrigFunctions(IAST timesAST, ISymbol arg2) {
        Predicate<IExpr> isTrigFunction = Predicates.isAST(new ISymbol[]{F.Cos, F.Sin});
        if (timesAST.isMember(isTrigFunction, false)) {
            Symbol pSymbol = new Symbol("$x$");
            IExpr fx = F.eval(F.TrigReduce(timesAST));
            if (fx.isPlus()) {
                fx = F.eval(F.ReplaceAll(fx, F.List((IExpr)F.Rule(F.Sin(F.$p(pSymbol)), F.Sin(F.Collect(pSymbol, arg2))), (IExpr)F.Rule(F.Cos(F.$p(pSymbol)), F.Cos(F.Collect(pSymbol, arg2))))));
                return ((IAST)fx).map(Functors.replace1st(F.Integrate(F.Null, arg2)));
            }
        }
        return null;
    }

    public static boolean isQuadratic(GenPolynomial<BigRational> poly, BigRational[] result) {
        if (poly.degree() <= 2L && poly.numberOfVariables() == 1) {
            result[0] = BigRational.ZERO;
            result[1] = BigRational.ZERO;
            result[2] = BigRational.ZERO;
            for (Monomial monomial : poly) {
                BigRational coeff = (BigRational)monomial.coefficient();
                ExpVector exp = monomial.exponent();
                for (int i = 0; i < exp.length(); ++i) {
                    result[(int)exp.getVal((int)i)] = coeff;
                }
            }
            return true;
        }
        return false;
    }

    public static boolean isQuadratic(GenPolynomial<edu.jas.arith.BigInteger> poly, edu.jas.arith.BigInteger[] result) {
        if (poly.degree() <= 2L && poly.numberOfVariables() == 1) {
            result[0] = edu.jas.arith.BigInteger.ZERO;
            result[1] = edu.jas.arith.BigInteger.ZERO;
            result[2] = edu.jas.arith.BigInteger.ZERO;
            for (Monomial monomial : poly) {
                edu.jas.arith.BigInteger coeff = (edu.jas.arith.BigInteger)monomial.coefficient();
                ExpVector exp = monomial.exponent();
                for (int i = 0; i < exp.length(); ++i) {
                    result[(int)exp.getVal((int)i)] = coeff;
                }
            }
            return true;
        }
        return false;
    }

    private static IAST integrateByPartialFractions(IExpr[] parts, ISymbol x) {
        try {
            IAST variableList = F.List((IExpr)x);
            IExpr exprNumerator = F.evalExpandAll(parts[0]);
            IExpr exprDenominator = F.evalExpandAll(parts[1]);
            ASTRange r = new ASTRange(variableList, 1);
            List<IExpr> varList = r.toList();
            String[] varListStr = new String[]{variableList.arg1().toString()};
            JASConvert jas = new JASConvert((List<? extends IExpr>)varList, BigRational.ZERO);
            GenPolynomial numerator = jas.expr2JAS(exprNumerator);
            GenPolynomial denominator = jas.expr2JAS(exprDenominator);
            FactorAbstract factorAbstract = FactorFactory.getImplementation((BigRational)BigRational.ZERO);
            SortedMap sfactors = factorAbstract.baseFactors(denominator);
            ArrayList D2 = new ArrayList(sfactors.keySet());
            SquarefreeAbstract sqf = SquarefreeFactory.getImplementation((BigRational)BigRational.ZERO);
            List Ai = sqf.basePartialFraction(numerator, sfactors);
            if (Ai.size() > 0) {
                IExpr temp;
                IAST result = F.Plus();
                if (!((GenPolynomial)((List)Ai.get(0)).get(0)).isZERO()) {
                    temp = F.eval(jas.poly2Expr((GenPolynomial<BigRational>)((GenPolynomial)((List)Ai.get(0)).get(0))));
                    if (temp.isAST()) {
                        ((IAST)temp).addEvalFlags(128);
                    }
                    result.add(F.Integrate(temp, x));
                }
                for (int i = 1; i < Ai.size(); ++i) {
                    List list = (List)Ai.get(i);
                    long j = 0L;
                    for (GenPolynomial genPolynomial : list) {
                        if (!genPolynomial.isZERO()) {
                            boolean isDegreeLE2;
                            BigRational[] numer = new BigRational[3];
                            BigRational[] denom = new BigRational[3];
                            boolean bl = isDegreeLE2 = ((GenPolynomial)D2.get(i - 1)).degree() <= 2L;
                            if (isDegreeLE2 && j == 1L) {
                                Object[] objects = jas.factorTerms((GenPolynomial<BigRational>)genPolynomial);
                                BigInteger gcd = (BigInteger)objects[0];
                                BigInteger lcm = (BigInteger)objects[1];
                                GenPolynomial genPolynomial2 = ((GenPolynomial)objects[2]).multiply((RingElem)edu.jas.arith.BigInteger.valueOf((BigInteger)gcd));
                                GenPolynomial Di_1 = ((GenPolynomial)D2.get(i - 1)).multiply((RingElem)BigRational.valueOf((BigInteger)lcm));
                                if (genPolynomial2.isONE()) {
                                    Integrate.isQuadratic((GenPolynomial<BigRational>)Di_1, denom);
                                    IFraction a = F.fraction(denom[2].numerator(), denom[2].denominator());
                                    IFraction b = F.fraction(denom[1].numerator(), denom[1].denominator());
                                    IFraction c = F.fraction(denom[0].numerator(), denom[0].denominator());
                                    if (a.isZero()) {
                                        result.add(F.Times((IExpr)F.Log(F.Plus((IExpr)c, (IExpr)F.Times((IExpr)b, (IExpr)x))), (IExpr)F.Power((IExpr)b, F.CN1)));
                                    } else {
                                        BigRational cmp = denom[1].multiply(denom[1]).subtract(BigRational.valueOf((long)4L).multiply(denom[2]).multiply(denom[0]));
                                        int cmpTo = cmp.compareTo(BigRational.ZERO);
                                        IAST ax2Plusb = F.Plus((IExpr)F.Times(F.C2, a, x), (IExpr)b);
                                        if (cmpTo == 0) {
                                            result.add(F.Times((IExpr)F.integer(-2L), (IExpr)F.Power((IExpr)ax2Plusb, F.CN1)));
                                        } else if (cmpTo > 0) {
                                            temp = F.eval(F.Power((IExpr)F.Subtract(F.Sqr(b), F.Times(F.C4, a, c)), F.C1D2));
                                            result.add(F.Times((IExpr)F.Power(temp, F.CN1), (IExpr)F.Log(F.Times((IExpr)F.Subtract(ax2Plusb, temp), (IExpr)F.Power((IExpr)F.Plus((IExpr)ax2Plusb, temp), F.CN1)))));
                                        } else {
                                            temp = F.eval(F.Power((IExpr)F.Subtract(F.Times(F.C4, a, c), F.Sqr(b)), F.CN1D2));
                                            result.add(F.Times(F.C2, temp, F.ArcTan(F.Times((IExpr)ax2Plusb, temp))));
                                        }
                                    }
                                } else {
                                    Integrate.isQuadratic((GenPolynomial<BigRational>)genPolynomial, numer);
                                    IFraction A = F.fraction(numer[1].numerator(), numer[1].denominator());
                                    IFraction B = F.fraction(numer[0].numerator(), numer[0].denominator());
                                    Integrate.isQuadratic((GenPolynomial<BigRational>)((GenPolynomial)D2.get(i - 1)), denom);
                                    IFraction p = F.fraction(denom[1].numerator(), denom[1].denominator());
                                    IFraction q = F.fraction(denom[0].numerator(), denom[0].denominator());
                                    temp = A.isZero() ? F.Times(B, F.Log(F.Plus((IExpr)q, (IExpr)F.Times((IExpr)p, (IExpr)x))), F.Power((IExpr)p, F.CN1)) : F.Plus((IExpr)F.Times(F.C1D2, A, F.Log(F.Plus(q, F.Times((IExpr)p, (IExpr)x), F.Power((IExpr)x, F.C2)))), (IExpr)F.Times(F.ArcTan(F.Times((IExpr)F.Plus((IExpr)p, (IExpr)F.Times((IExpr)F.C2, (IExpr)x)), (IExpr)F.Power((IExpr)F.Plus((IExpr)F.Times((IExpr)F.CN1, (IExpr)F.Power((IExpr)p, F.C2)), (IExpr)F.Times((IExpr)F.C4, (IExpr)q)), F.CN1D2))), F.Plus((IExpr)F.Times((IExpr)F.C2, (IExpr)B), (IExpr)F.Times(F.CN1, A, p)), F.Power((IExpr)F.Plus((IExpr)F.Times((IExpr)F.CN1, (IExpr)F.Power((IExpr)p, F.C2)), (IExpr)F.Times((IExpr)F.C4, (IExpr)q)), F.CN1D2)));
                                    result.add(F.eval(temp));
                                }
                            } else if (isDegreeLE2 && j > 1L) {
                                Integrate.isQuadratic((GenPolynomial<BigRational>)genPolynomial, numer);
                                IFraction A = F.fraction(numer[1].numerator(), numer[1].denominator());
                                IFraction B = F.fraction(numer[0].numerator(), numer[0].denominator());
                                Integrate.isQuadratic((GenPolynomial<BigRational>)((GenPolynomial)D2.get(i - 1)), denom);
                                IFraction a = F.fraction(denom[2].numerator(), denom[2].denominator());
                                IFraction b = F.fraction(denom[1].numerator(), denom[1].denominator());
                                IFraction c = F.fraction(denom[0].numerator(), denom[0].denominator());
                                IInteger k = F.integer(j);
                                temp = A.isZero() ? F.Times((IExpr)B, (IExpr)F.Plus((IExpr)F.Times(F.Integrate(F.Power((IExpr)F.Plus(c, F.Times((IExpr)b, (IExpr)x), F.Times((IExpr)a, (IExpr)F.Power((IExpr)x, F.C2))), F.Plus((IExpr)F.C1, (IExpr)F.Times((IExpr)F.CN1, (IExpr)k))), x), F.Plus((IExpr)F.Times((IExpr)F.integer(-6L), (IExpr)a), (IExpr)F.Times(F.C4, a, k)), F.Power((IExpr)F.Plus((IExpr)F.CN1, (IExpr)k), F.CN1), F.Power((IExpr)F.Plus((IExpr)F.Times((IExpr)F.CN1, (IExpr)F.Power((IExpr)b, F.C2)), (IExpr)F.Times(F.C4, a, c)), F.CN1)), (IExpr)F.Times(F.Plus((IExpr)b, (IExpr)F.Times(F.C2, a, x)), F.Power((IExpr)F.Plus((IExpr)F.CN1, (IExpr)k), F.CN1), F.Power((IExpr)F.Plus((IExpr)F.Times((IExpr)F.CN1, (IExpr)F.Power((IExpr)b, F.C2)), (IExpr)F.Times(F.C4, a, c)), F.CN1), F.Power((IExpr)F.Plus(c, F.Times((IExpr)b, (IExpr)x), F.Times((IExpr)a, (IExpr)F.Power((IExpr)x, F.C2))), F.Times((IExpr)F.CN1, (IExpr)F.Plus((IExpr)F.CN1, (IExpr)k)))))) : F.Plus((IExpr)F.Times((IExpr)F.Integrate(F.Power((IExpr)F.Plus(c, F.Times((IExpr)b, (IExpr)x), F.Times((IExpr)a, (IExpr)F.Power((IExpr)x, F.C2))), F.Times((IExpr)F.CN1, (IExpr)k)), x), (IExpr)F.Plus((IExpr)B, (IExpr)F.Times(F.CN1D2, A, F.Power((IExpr)a, F.CN1), b))), (IExpr)F.Times(F.CN1D2, A, F.Power((IExpr)a, F.CN1), F.Power((IExpr)F.Plus((IExpr)F.CN1, (IExpr)k), F.CN1), F.Power((IExpr)F.Plus(c, F.Times((IExpr)b, (IExpr)x), F.Times((IExpr)a, (IExpr)F.Power((IExpr)x, F.C2))), F.Times((IExpr)F.CN1, (IExpr)F.Plus((IExpr)F.CN1, (IExpr)k)))));
                                result.add(F.eval(temp));
                            } else {
                                temp = F.eval(F.Times((IExpr)jas.poly2Expr((GenPolynomial<BigRational>)genPolynomial), (IExpr)F.Power((IExpr)jas.poly2Expr((GenPolynomial<BigRational>)((GenPolynomial)D2.get(i - 1))), F.integer(j * -1L))));
                                if (!temp.equals(F.C0)) {
                                    if (temp.isAST()) {
                                        ((IAST)temp).addEvalFlags(128);
                                    }
                                    result.add(F.Integrate(temp, x));
                                }
                            }
                        }
                        ++j;
                    }
                }
                return result;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        catch (JASConversionException jASConversionException) {
            // empty catch block
        }
        return null;
    }

    private static IExpr integratePolynomialByParts(IAST arg1, ISymbol symbol) {
        IAST fTimes = F.Times();
        IAST gTimes = F.Times();
        Integrate.collectPolynomialTerms(arg1, symbol, fTimes, gTimes);
        IExpr f = fTimes;
        IExpr g = gTimes;
        if (fTimes.size() == 1) {
            return null;
        }
        if (fTimes.size() == 2) {
            f = fTimes.arg1();
        }
        if (gTimes.size() == 1) {
            return null;
        }
        if (gTimes.size() == 2) {
            g = gTimes.arg1();
        }
        return Integrate.integrateByParts(f, g, symbol);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static IExpr integrateByParts(IExpr f, IExpr g, ISymbol symbol) {
        EvalEngine engine = EvalEngine.get();
        int limit = engine.getRecursionLimit();
        try {
            IExpr fIntegrated;
            if (limit <= 0) {
                engine.setRecursionLimit(128);
            }
            if (!(fIntegrated = F.eval(F.Integrate(f, symbol))).isFree(F.Integrate, true)) {
                IExpr iExpr = null;
                return iExpr;
            }
            IExpr gDerived = F.eval(F.D(g, symbol));
            IExpr iExpr = F.eval(F.Plus((IExpr)F.Times(fIntegrated, g), (IExpr)F.Times((IExpr)F.CN1, (IExpr)F.Integrate(F.Times(fIntegrated, gDerived), symbol))));
            return iExpr;
        }
        catch (RecursionLimitExceeded rle) {
            engine.setRecursionLimit(limit);
        }
        finally {
            engine.setRecursionLimit(limit);
        }
        return null;
    }

    private static void collectPolynomialTerms(IAST timesAST, ISymbol symbol, IAST fTimes, IAST gTimes) {
        for (int i = 1; i < timesAST.size(); ++i) {
            IExpr temp = (IExpr)timesAST.get(i);
            if (temp.isFree(symbol, true)) {
                fTimes.add(temp);
                continue;
            }
            if (temp.equals(symbol)) {
                fTimes.add(temp);
                continue;
            }
            if (PolynomialQ.polynomialQ(temp, F.List((IExpr)symbol))) {
                fTimes.add(temp);
                continue;
            }
            gTimes.add(temp);
        }
    }

    @Override
    public IAST getRuleAST() {
        IAST ast = F.ast(F.List, 10000, false);
        this.getRuleASTRubi2(ast);
        return ast;
    }

    private void getRuleASTRubi42(IAST ast) {
        ast.addAll(IntegrationRulesForExpressionsInvolvingAlgebraicBinomialsOfTheFollowingForms0.RULES);
        ast.addAll(IntegrationRulesForExpressionsInvolvingAlgebraicBinomialsOfTheFollowingForms1.RULES);
        ast.addAll(IntegrationRulesForExpressionsInvolvingAlgebraicBinomialsOfTheFollowingForms2.RULES);
        ast.addAll(IntegrationRulesForExpressionsInvolvingAlgebraicTrinomialsOfTheFollowingForms0.RULES);
        ast.addAll(IntegrationRulesForExpressionsInvolvingAlgebraicTrinomialsOfTheFollowingForms1.RULES);
        ast.addAll(IntegrationRulesForExpressionsInvolvingAlgebraicTrinomialsOfTheFollowingForms2.RULES);
        ast.addAll(IntegrationRulesForExpressionsInvolvingAlgebraicTrinomialsOfTheFollowingForms3.RULES);
        ast.addAll(IntegrationRulesForExpressionsInvolvingAlgebraicTrinomialsOfTheFollowingForms4.RULES);
        ast.addAll(IntegrationRulesForExpressionsInvolvingAlgebraicTrinomialsOfTheFollowingForms5.RULES);
        ast.addAll(IntegrationRulesForExpressionsInvolvingAlgebraicTrinomialsOfTheFollowingForms6.RULES);
        ast.addAll(IntegrationRulesForExpressionsInvolvingExponentialOrLogarithmFunctions0.RULES);
        ast.addAll(IntegrationRulesForExpressionsInvolvingExponentialOrLogarithmFunctions1.RULES);
        ast.addAll(IntegrationRulesForExpressionsInvolvingExponentialOrLogarithmFunctions2.RULES);
        ast.addAll(IntegrationRulesForExpressionsInvolvingExponentialOrLogarithmFunctions3.RULES);
        ast.addAll(IntegrationRulesForExpressionsInvolvingHyperbolicFunctionsOfTheFollowingForms0.RULES);
        ast.addAll(IntegrationRulesForExpressionsInvolvingHyperbolicFunctionsOfTheFollowingForms1.RULES);
        ast.addAll(IntegrationRulesForExpressionsInvolvingHyperbolicFunctionsOfTheFollowingForms2.RULES);
        ast.addAll(IntegrationRulesForExpressionsInvolvingHyperbolicFunctionsOfTheFollowingForms3.RULES);
        ast.addAll(IntegrationRulesForExpressionsInvolvingHyperbolicFunctionsOfTheFollowingForms4.RULES);
        ast.addAll(IntegrationRulesForExpressionsInvolvingHyperbolicFunctionsOfTheFollowingForms5.RULES);
        ast.addAll(IntegrationRulesForExpressionsInvolvingSpecialFunctions0.RULES);
        ast.addAll(IntegrationRulesForExpressionsInvolvingTrigFunctionsOfTheFollowingForms0.RULES);
        ast.addAll(IntegrationRulesForExpressionsInvolvingTrigFunctionsOfTheFollowingForms1.RULES);
        ast.addAll(IntegrationRulesForExpressionsInvolvingTrigFunctionsOfTheFollowingForms10.RULES);
        ast.addAll(IntegrationRulesForExpressionsInvolvingTrigFunctionsOfTheFollowingForms11.RULES);
        ast.addAll(IntegrationRulesForExpressionsInvolvingTrigFunctionsOfTheFollowingForms12.RULES);
        ast.addAll(IntegrationRulesForExpressionsInvolvingTrigFunctionsOfTheFollowingForms13.RULES);
        ast.addAll(IntegrationRulesForExpressionsInvolvingTrigFunctionsOfTheFollowingForms14.RULES);
        ast.addAll(IntegrationRulesForExpressionsInvolvingTrigFunctionsOfTheFollowingForms15.RULES);
        ast.addAll(IntegrationRulesForExpressionsInvolvingTrigFunctionsOfTheFollowingForms16.RULES);
        ast.addAll(IntegrationRulesForExpressionsInvolvingTrigFunctionsOfTheFollowingForms17.RULES);
        ast.addAll(IntegrationRulesForExpressionsInvolvingTrigFunctionsOfTheFollowingForms18.RULES);
        ast.addAll(IntegrationRulesForExpressionsInvolvingTrigFunctionsOfTheFollowingForms19.RULES);
        ast.addAll(IntegrationRulesForExpressionsInvolvingTrigFunctionsOfTheFollowingForms2.RULES);
        ast.addAll(IntegrationRulesForExpressionsInvolvingTrigFunctionsOfTheFollowingForms20.RULES);
        ast.addAll(IntegrationRulesForExpressionsInvolvingTrigFunctionsOfTheFollowingForms21.RULES);
        ast.addAll(IntegrationRulesForExpressionsInvolvingTrigFunctionsOfTheFollowingForms22.RULES);
        ast.addAll(IntegrationRulesForExpressionsInvolvingTrigFunctionsOfTheFollowingForms23.RULES);
        ast.addAll(IntegrationRulesForExpressionsInvolvingTrigFunctionsOfTheFollowingForms24.RULES);
        ast.addAll(IntegrationRulesForExpressionsInvolvingTrigFunctionsOfTheFollowingForms25.RULES);
        ast.addAll(IntegrationRulesForExpressionsInvolvingTrigFunctionsOfTheFollowingForms26.RULES);
        ast.addAll(IntegrationRulesForExpressionsInvolvingTrigFunctionsOfTheFollowingForms27.RULES);
        ast.addAll(IntegrationRulesForExpressionsInvolvingTrigFunctionsOfTheFollowingForms28.RULES);
        ast.addAll(IntegrationRulesForExpressionsInvolvingTrigFunctionsOfTheFollowingForms29.RULES);
        ast.addAll(IntegrationRulesForExpressionsInvolvingTrigFunctionsOfTheFollowingForms3.RULES);
        ast.addAll(IntegrationRulesForExpressionsInvolvingTrigFunctionsOfTheFollowingForms30.RULES);
        ast.addAll(IntegrationRulesForExpressionsInvolvingTrigFunctionsOfTheFollowingForms31.RULES);
        ast.addAll(IntegrationRulesForExpressionsInvolvingTrigFunctionsOfTheFollowingForms32.RULES);
        ast.addAll(IntegrationRulesForExpressionsInvolvingTrigFunctionsOfTheFollowingForms33.RULES);
        ast.addAll(IntegrationRulesForExpressionsInvolvingTrigFunctionsOfTheFollowingForms34.RULES);
        ast.addAll(IntegrationRulesForExpressionsInvolvingTrigFunctionsOfTheFollowingForms35.RULES);
        ast.addAll(IntegrationRulesForExpressionsInvolvingTrigFunctionsOfTheFollowingForms36.RULES);
        ast.addAll(IntegrationRulesForExpressionsInvolvingTrigFunctionsOfTheFollowingForms37.RULES);
        ast.addAll(IntegrationRulesForExpressionsInvolvingTrigFunctionsOfTheFollowingForms4.RULES);
        ast.addAll(IntegrationRulesForExpressionsInvolvingTrigFunctionsOfTheFollowingForms5.RULES);
        ast.addAll(IntegrationRulesForExpressionsInvolvingTrigFunctionsOfTheFollowingForms6.RULES);
        ast.addAll(IntegrationRulesForExpressionsInvolvingTrigFunctionsOfTheFollowingForms7.RULES);
        ast.addAll(IntegrationRulesForExpressionsInvolvingTrigFunctionsOfTheFollowingForms8.RULES);
        ast.addAll(IntegrationRulesForExpressionsInvolvingTrigFunctionsOfTheFollowingForms9.RULES);
        ast.addAll(IntegrationRulesForMiscellaneousExpressions0.RULES);
        ast.addAll(IntegrationRulesForMiscellaneousExpressions1.RULES);
        ast.addAll(IntegrationRulesForMiscellaneousExpressions2.RULES);
        ast.addAll(IntegrationRulesForMiscellaneousExpressions3.RULES);
        ast.addAll(IntegrationRulesForMiscellaneousExpressions4.RULES);
        ast.addAll(IntegrationRulesForMiscellaneousExpressions5.RULES);
        ast.addAll(IntegrationRulesForMiscellaneousExpressions6.RULES);
        ast.addAll(IntegrationRulesForMiscellaneousExpressions7.RULES);
        ast.addAll(IntegrationRulesForMiscellaneousExpressions8.RULES);
        ast.addAll(IntegrationRulesForMiscellaneousExpressions9.RULES);
        ast.addAll(IntegrationRulesForMiscellaneousExpressions10.RULES);
        ast.addAll(IntegrationRulesForMiscellaneousExpressions11.RULES);
        ast.addAll(IntegrationRulesForMiscellaneousExpressions12.RULES);
        ast.addAll(IntegrationRulesForMiscellaneousExpressions13.RULES);
        UtilityFunctions.init();
    }

    private void getRuleASTRubi2(IAST ast) {
        ast.addAll(IndefiniteIntegrationRules0.RULES);
        ast.addAll(IndefiniteIntegrationRules1.RULES);
        ast.addAll(IndefiniteIntegrationRules2.RULES);
        ast.addAll(IndefiniteIntegrationRules3.RULES);
        ast.addAll(IndefiniteIntegrationRules4.RULES);
        ast.addAll(IndefiniteIntegrationRules5.RULES);
        ast.addAll(IndefiniteIntegrationRules6.RULES);
        ast.addAll(IndefiniteIntegrationRules7.RULES);
        ast.addAll(IndefiniteIntegrationRules8.RULES);
        ast.addAll(IndefiniteIntegrationRules9.RULES);
        ast.addAll(IndefiniteIntegrationRules10.RULES);
        ast.addAll(IndefiniteIntegrationRules11.RULES);
        ast.addAll(IndefiniteIntegrationRules12.RULES);
        ast.addAll(IndefiniteIntegrationRules13.RULES);
        ast.addAll(IndefiniteIntegrationRules14.RULES);
        ast.addAll(IndefiniteIntegrationRules15.RULES);
        ast.addAll(IndefiniteIntegrationRules16.RULES);
        org.matheclipse.core.integrate.rubi.UtilityFunctions.init();
    }

    public static IAST getUtilityFunctionsRuleAST() {
        IAST ast = F.ast(F.List, 10000, false);
        Integrate.getUtilityFunctionsRuleASTRubi2(ast);
        return ast;
    }

    private static void getUtilityFunctionsRuleASTRubi42(IAST ast) {
        ast.addAll(org.matheclipse.core.integrate.rubi42.UtilityFunctions0.RULES);
        ast.addAll(org.matheclipse.core.integrate.rubi42.UtilityFunctions1.RULES);
        ast.addAll(org.matheclipse.core.integrate.rubi42.UtilityFunctions2.RULES);
        ast.addAll(org.matheclipse.core.integrate.rubi42.UtilityFunctions3.RULES);
        ast.addAll(org.matheclipse.core.integrate.rubi42.UtilityFunctions4.RULES);
        ast.addAll(org.matheclipse.core.integrate.rubi42.UtilityFunctions5.RULES);
    }

    private static void getUtilityFunctionsRuleASTRubi2(IAST ast) {
        ast.addAll(UtilityFunctions0.RULES);
        ast.addAll(UtilityFunctions1.RULES);
        ast.addAll(UtilityFunctions2.RULES);
        ast.addAll(UtilityFunctions3.RULES);
        ast.addAll(UtilityFunctions4.RULES);
        ast.addAll(UtilityFunctions5.RULES);
    }
}

