/*
 * Decompiled with CFR 0.152.
 */
package org.matheclipse.core.reflection.system;

import org.matheclipse.core.eval.exception.Validate;
import org.matheclipse.core.eval.interfaces.AbstractFunctionEvaluator;
import org.matheclipse.core.expression.F;
import org.matheclipse.core.generic.Functors;
import org.matheclipse.core.interfaces.IAST;
import org.matheclipse.core.interfaces.IComplexNum;
import org.matheclipse.core.interfaces.IExpr;
import org.matheclipse.core.interfaces.INum;
import org.matheclipse.core.interfaces.ISymbol;

public class Chop
extends AbstractFunctionEvaluator {
    public final double DEFAULT_CHOP_DELTA = 1.0E-9;

    @Override
    public IExpr evaluate(IAST ast) {
        Validate.checkRange(ast, 2, 3);
        IExpr arg1 = ast.arg1();
        double delta = 1.0E-9;
        if (ast.size() == 3 && ast.arg2() instanceof INum) {
            delta = ((INum)ast.arg2()).getRealPart();
        }
        try {
            arg1 = F.eval(arg1);
            if (arg1 instanceof INum) {
                if (F.isZero(((INum)arg1).getRealPart(), delta)) {
                    return F.C0;
                }
                return arg1;
            }
            if (arg1 instanceof IComplexNum) {
                if (F.isZero(((IComplexNum)arg1).getRealPart(), delta)) {
                    if (F.isZero(((IComplexNum)arg1).getImaginaryPart(), delta)) {
                        return F.C0;
                    }
                    return F.complexNum(0.0, ((IComplexNum)arg1).getImaginaryPart());
                }
                if (F.isZero(((IComplexNum)arg1).getImaginaryPart(), delta)) {
                    return F.complexNum(((IComplexNum)arg1).getRealPart(), 0.0);
                }
                return arg1;
            }
            if (arg1.isAST()) {
                IAST list = (IAST)arg1;
                return list.map(Functors.replace1st(F.Chop(F.Null)));
            }
            return arg1;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    @Override
    public void setUp(ISymbol symbol) {
        symbol.setAttributes(24704);
    }
}

