/*
 * Decompiled with CFR 0.152.
 */
package org.matheclipse.core.reflection.system;

import com.google.common.base.Predicate;
import edu.jas.arith.BigInteger;
import edu.jas.arith.BigRational;
import edu.jas.poly.GenPolynomial;
import edu.jas.ufd.GCDFactory;
import edu.jas.ufd.GreatestCommonDivisorAbstract;
import java.util.List;
import org.matheclipse.core.convert.ExprVariables;
import org.matheclipse.core.convert.JASConvert;
import org.matheclipse.core.eval.EvalEngine;
import org.matheclipse.core.eval.exception.JASConversionException;
import org.matheclipse.core.eval.exception.Validate;
import org.matheclipse.core.eval.interfaces.AbstractFunctionEvaluator;
import org.matheclipse.core.expression.ASTRange;
import org.matheclipse.core.expression.F;
import org.matheclipse.core.generic.Functors;
import org.matheclipse.core.interfaces.IAST;
import org.matheclipse.core.interfaces.IExpr;
import org.matheclipse.core.interfaces.IInteger;
import org.matheclipse.core.interfaces.ISymbol;
import org.matheclipse.core.reflection.system.Apart;
import org.matheclipse.parser.client.SyntaxError;

public class Cancel
extends AbstractFunctionEvaluator {
    @Override
    public IExpr evaluate(IAST ast) {
        Validate.checkRange(ast, 2, 3);
        IExpr arg = F.evalExpandAll(ast.arg1());
        try {
            if (arg.isPlus()) {
                IAST result = ((IAST)arg).map(Functors.evalArg(F.Cancel(F.Slot1), 1, EvalEngine.get()));
                if (result == null) {
                    return arg;
                }
                return result;
            }
            if (arg.isTimes() || arg.isPower()) {
                return Cancel.cancelPowerTimes(arg);
            }
        }
        catch (JASConversionException jASConversionException) {
            // empty catch block
        }
        return arg;
    }

    public static IExpr cancelPowerTimes(IExpr powerTimesAST) throws JASConversionException {
        IExpr[] parts = Apart.getFractionalParts(powerTimesAST);
        if (parts != null && parts[0].isPlus() && parts[1].isPlus()) {
            IExpr[] result;
            IAST[] numParts = ((IAST)parts[0]).split(new PolynomialPredicate());
            IAST[] denParts = ((IAST)parts[1]).split(new PolynomialPredicate());
            IExpr denParts0 = F.eval(denParts[0]);
            if (!denParts0.equals(F.C1) && (result = Cancel.cancelGCD(numParts[0], denParts0)) != null) {
                return F.Times(result[0], result[1], numParts[1], F.Power((IExpr)F.Times(result[2], (IExpr)denParts[1]), F.CN1));
            }
        }
        return powerTimesAST;
    }

    public static IExpr[] cancelGCD(IExpr poly1, IExpr poly2) throws JASConversionException {
        try {
            ExprVariables eVar = new ExprVariables(poly1);
            eVar.addVarList(poly2);
            ASTRange r = new ASTRange(eVar.getVarList(), 1);
            JASConvert jas = new JASConvert((List<? extends IExpr>)r.toList(), BigRational.ZERO);
            GenPolynomial p1 = jas.expr2JAS(poly1);
            GenPolynomial p2 = jas.expr2JAS(poly2);
            BigRational cofac = new BigRational();
            GreatestCommonDivisorAbstract engine = GCDFactory.getImplementation((BigRational)cofac);
            GenPolynomial gcd = engine.gcd(p1, p2);
            IExpr[] result = new IExpr[3];
            if (gcd.isONE()) {
                result[0] = jas.rationalPoly2Expr((GenPolynomial<BigRational>)gcd);
                result[1] = jas.rationalPoly2Expr(p1);
                result[2] = jas.rationalPoly2Expr(p2);
            } else {
                Object[] objects = jas.factorTerms((GenPolynomial<BigRational>)p1.divide(gcd));
                java.math.BigInteger commonNumerator = (java.math.BigInteger)objects[0];
                result[1] = jas.integerPoly2Expr((GenPolynomial<BigInteger>)((GenPolynomial)objects[2]));
                objects = jas.factorTerms((GenPolynomial<BigRational>)p2.divide(gcd));
                java.math.BigInteger commonDenominator = (java.math.BigInteger)objects[0];
                result[2] = jas.integerPoly2Expr((GenPolynomial<BigInteger>)((GenPolynomial)objects[2]));
                result[0] = F.fraction(commonNumerator, commonDenominator);
            }
            return result;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    @Override
    public void setUp(ISymbol symbol) throws SyntaxError {
        symbol.setAttributes(128);
        super.setUp(symbol);
    }

    private static final class PolynomialPredicate
    implements Predicate<IExpr> {
        private PolynomialPredicate() {
        }

        public boolean apply(IExpr expr) {
            if (expr.isRational()) {
                return true;
            }
            if (expr.isSymbol()) {
                return true;
            }
            if (expr.isTimes() || expr.isPlus()) {
                IAST ast = (IAST)expr;
                for (int i = 1; i < ast.size(); ++i) {
                    if (this.apply((IExpr)ast.get(i))) continue;
                    return false;
                }
                return true;
            }
            if (expr.isPower() && ((IAST)expr).arg1().isSymbol() && ((IAST)expr).arg2().isInteger()) {
                try {
                    int in = ((IInteger)((IAST)expr).arg2()).toInt();
                    if (in > 0) {
                        return true;
                    }
                }
                catch (ArithmeticException arithmeticException) {
                    // empty catch block
                }
                return false;
            }
            return false;
        }
    }
}

