/*
 * Decompiled with CFR 0.152.
 */
package org.matheclipse.core.patternmatching;

import java.io.Serializable;
import org.matheclipse.core.builtin.function.Condition;
import org.matheclipse.core.builtin.function.Module;
import org.matheclipse.core.eval.EvalEngine;
import org.matheclipse.core.eval.exception.ConditionException;
import org.matheclipse.core.eval.exception.ReturnException;
import org.matheclipse.core.expression.F;
import org.matheclipse.core.interfaces.IAST;
import org.matheclipse.core.interfaces.IExpr;
import org.matheclipse.core.interfaces.ISymbol;
import org.matheclipse.core.patternmatching.PatternMap;
import org.matheclipse.core.patternmatching.PatternMatcher;

public class PatternMatcherAndEvaluator
extends PatternMatcher
implements Serializable {
    private static final long serialVersionUID = 2241135467123931061L;
    private IExpr fRightHandSide;
    private ISymbol fSetSymbol;

    public PatternMatcherAndEvaluator(ISymbol setSymbol, IExpr leftHandSide, IExpr rightHandSide) {
        super(leftHandSide);
        this.fSetSymbol = setSymbol;
        this.fRightHandSide = rightHandSide;
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        PatternMatcherAndEvaluator v = (PatternMatcherAndEvaluator)super.clone();
        v.fRightHandSide = this.fRightHandSide;
        v.fSetSymbol = this.fSetSymbol;
        return v;
    }

    @Override
    public boolean equals(Object obj) {
        PatternMatcherAndEvaluator pm;
        if (this == obj) {
            return true;
        }
        if (obj instanceof PatternMatcherAndEvaluator && super.equals(pm = (PatternMatcherAndEvaluator)obj)) {
            if (this.fRightHandSide.isCondition()) {
                if (pm.fRightHandSide.isCondition()) {
                    return PatternMatcherAndEvaluator.equivalentRHS(this.fRightHandSide.getAt(2), pm.fRightHandSide.getAt(2), this.fPatternMap, pm.fPatternMap);
                }
                return false;
            }
            if (pm.fRightHandSide.isCondition()) {
                return false;
            }
            if (this.fRightHandSide.isModule()) {
                if (pm.fRightHandSide.isModule()) {
                    return PatternMatcherAndEvaluator.equivalentRHS(this.fRightHandSide.getAt(2), pm.fRightHandSide.getAt(2), this.fPatternMap, pm.fPatternMap);
                }
                return false;
            }
            return !pm.fRightHandSide.isModule();
        }
        return false;
    }

    private static boolean equivalentRHS(IExpr patternExpr1, IExpr patternExpr2, PatternMap pm1, PatternMap pm2) {
        if (patternExpr1.isCondition()) {
            if (patternExpr2.isCondition()) {
                return PatternMatcherAndEvaluator.equivalentRHS(patternExpr1.getAt(2), patternExpr2.getAt(2), pm1, pm2);
            }
            return false;
        }
        if (patternExpr2.isCondition()) {
            return false;
        }
        if (patternExpr1.isModule()) {
            if (patternExpr2.isModule()) {
                return PatternMatcherAndEvaluator.equivalentRHS(patternExpr1.getAt(2), patternExpr2.getAt(2), pm1, pm2);
            }
            return false;
        }
        if (patternExpr2.isModule()) {
            return false;
        }
        return PatternMatcherAndEvaluator.equivalent(patternExpr1, patternExpr2);
    }

    @Override
    public int hashCode() {
        return super.hashCode() * 53;
    }

    @Override
    public boolean checkRHSCondition(EvalEngine engine) {
        if (!this.fRightHandSide.isModule() && !this.fRightHandSide.isCondition()) {
            return true;
        }
        if (!this.fPatternMap.isAllPatternsAssigned()) {
            return true;
        }
        IExpr substConditon = this.fPatternMap.substitutePatternSymbols(this.fRightHandSide);
        if (substConditon.isCondition()) {
            return Condition.checkCondition(substConditon.getAt(1), substConditon.getAt(2), engine);
        }
        if (substConditon.isModule()) {
            return Module.checkModuleCondition(substConditon.getAt(1), substConditon.getAt(2), engine);
        }
        return true;
    }

    @Override
    public IExpr eval(IExpr lhsEvalExpr) {
        IExpr result;
        if (this.isRuleWithoutPatterns()) {
            if (this.fLhsPatternExpr.equals(lhsEvalExpr)) {
                IExpr result2 = this.fRightHandSide;
                try {
                    IExpr temp = F.eval(result2);
                    if (temp != null) {
                        return temp;
                    }
                    return result2;
                }
                catch (ConditionException e) {
                    return null;
                }
                catch (ReturnException e) {
                    return e.getValue();
                }
            }
            if (!(this.fLhsPatternExpr.isOrderlessAST() && lhsEvalExpr.isOrderlessAST() || this.fLhsPatternExpr.isFlatAST() && lhsEvalExpr.isFlatAST())) {
                return null;
            }
        }
        if (this.fLhsPatternExpr.isAST() && lhsEvalExpr.isAST()) {
            this.fPatternMap.initPattern();
            result = this.evalAST((IAST)this.fLhsPatternExpr, (IAST)lhsEvalExpr, this.fRightHandSide, new PatternMatcher.StackMatcher());
            if (result != null) {
                return result;
            }
        }
        this.fPatternMap.initPattern();
        if (this.matchExpr(this.fLhsPatternExpr, lhsEvalExpr)) {
            result = this.fPatternMap.substitutePatternSymbols(this.fRightHandSide);
            try {
                result = F.eval(result);
            }
            catch (ConditionException e) {
                return null;
            }
            catch (ReturnException e) {
                result = e.getValue();
            }
            return result;
        }
        return null;
    }

    @Override
    public IExpr getRHS() {
        return this.fRightHandSide;
    }

    public ISymbol getSetSymbol() {
        return this.fSetSymbol;
    }
}

