/*
 * Decompiled with CFR 0.152.
 */
package org.matheclipse.core.generic;

import org.matheclipse.core.basic.Alloc;
import org.matheclipse.core.eval.EvalDouble;
import org.matheclipse.core.expression.ComplexNum;
import org.matheclipse.core.expression.F;
import org.matheclipse.core.expression.Num;
import org.matheclipse.core.generic.BinaryFunctorImpl;
import org.matheclipse.core.interfaces.IExpr;
import org.matheclipse.core.interfaces.ISymbol;

public class BinaryNumerical
extends BinaryFunctorImpl<IExpr> {
    IExpr fun;
    ISymbol variable1;
    ISymbol variable2;

    public BinaryNumerical(IExpr fn, ISymbol v1, ISymbol v2) {
        this.variable1 = v1;
        this.variable2 = v2;
        this.fun = fn;
    }

    @Override
    public IExpr apply(IExpr firstArg, IExpr secondArg) {
        return F.evaln(F.subst(this.fun, F.List((IExpr)F.Rule(this.variable1, firstArg), (IExpr)F.Rule(this.variable2, secondArg))));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public double value(double x, double y) {
        double result = 0.0;
        try {
            this.variable1.pushLocalVariable(Num.valueOf(x));
            this.variable2.pushLocalVariable(Num.valueOf(y));
            double[] stack = Alloc.vector(10);
            result = EvalDouble.eval(stack, 0, this.fun);
        }
        finally {
            this.variable2.popLocalVariable();
            this.variable1.popLocalVariable();
        }
        return result;
    }

    public ComplexNum value(ComplexNum z1, ComplexNum z2) {
        IExpr temp = this.apply(z1, z2);
        if (temp instanceof ComplexNum) {
            return (ComplexNum)temp;
        }
        if (temp instanceof Num) {
            return ComplexNum.valueOf(((Num)temp).getRealPart());
        }
        throw new ArithmeticException("Numerical complex value expected");
    }
}

