/*
 * Decompiled with CFR 0.152.
 */
package org.matheclipse.core.expression;

import java.math.BigInteger;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.apache.commons.math3.fraction.BigFraction;
import org.matheclipse.core.eval.EvalEngine;
import org.matheclipse.core.expression.ExprImpl;
import org.matheclipse.core.expression.F;
import org.matheclipse.core.expression.FractionSym;
import org.matheclipse.core.expression.Num;
import org.matheclipse.core.expression.NumberUtil;
import org.matheclipse.core.expression.Primality;
import org.matheclipse.core.form.output.OutputFormFactory;
import org.matheclipse.core.interfaces.IAST;
import org.matheclipse.core.interfaces.IExpr;
import org.matheclipse.core.interfaces.IInteger;
import org.matheclipse.core.interfaces.INumber;
import org.matheclipse.core.interfaces.ISignedNumber;
import org.matheclipse.core.interfaces.ISymbol;
import org.matheclipse.core.visit.IVisitor;
import org.matheclipse.core.visit.IVisitorBoolean;
import org.matheclipse.core.visit.IVisitorInt;

public class IntegerSym
extends ExprImpl
implements IInteger {
    public static final BigInteger BI_MINUS_ONE = BigInteger.valueOf(-1L);
    private static final long serialVersionUID = 6389228668633533063L;
    BigInteger fInteger = null;
    private transient int fHashValue = 0;

    protected static IntegerSym newInstance(BigInteger value) {
        IntegerSym z = new IntegerSym();
        z.fInteger = value;
        return z;
    }

    public static IntegerSym valueOf(long value) {
        IntegerSym z = new IntegerSym();
        z.fInteger = BigInteger.valueOf(value);
        return z;
    }

    public static IntegerSym valueOf(String integerString, int radix) {
        IntegerSym z = new IntegerSym();
        z.fInteger = new BigInteger(integerString, radix);
        return z;
    }

    private IntegerSym() {
    }

    @Override
    public boolean equalsInt(int i) {
        return this.fInteger.equals(BigInteger.valueOf(i));
    }

    @Override
    public IExpr evaluate(EvalEngine engine) {
        if (engine.isNumericMode()) {
            return this.numericNumber();
        }
        return null;
    }

    @Override
    public final INumber numericNumber() {
        return F.num(this);
    }

    @Override
    public int hierarchy() {
        return 8;
    }

    @Override
    public IInteger add(IInteger val) {
        return IntegerSym.newInstance(this.fInteger.add(val.getBigNumerator()));
    }

    @Override
    public IInteger multiply(IInteger val) {
        return IntegerSym.newInstance(this.fInteger.multiply(val.getBigNumerator()));
    }

    public boolean equals(Object obj) {
        if (this.hashCode() != obj.hashCode()) {
            return false;
        }
        if (obj instanceof IntegerSym) {
            if (this == obj) {
                return true;
            }
            return this.fInteger.equals(((IntegerSym)obj).fInteger);
        }
        return false;
    }

    public static IntegerSym valueOf(BigInteger bigInteger) {
        return IntegerSym.newInstance(bigInteger);
    }

    @Override
    public IntegerSym eabs() {
        return IntegerSym.newInstance(this.fInteger.abs());
    }

    public IntegerSym add(IntegerSym that) {
        return IntegerSym.newInstance(this.fInteger.add(that.fInteger));
    }

    public int bitLength() {
        return this.fInteger.bitLength();
    }

    public BigInteger divide(long val) {
        return this.fInteger.divide(BigInteger.valueOf(val));
    }

    public BigInteger divide(BigInteger that) {
        return this.fInteger.divide(that);
    }

    public IntegerSym quotient(IntegerSym that) {
        return IntegerSym.newInstance(this.fInteger.divide(that.fInteger));
    }

    @Override
    public double doubleValue() {
        return this.fInteger.doubleValue();
    }

    public IntegerSym gcd(IntegerSym that) {
        return IntegerSym.newInstance(this.fInteger.gcd(that.fInteger));
    }

    @Override
    public IInteger gcd(IInteger that) {
        return IntegerSym.newInstance(this.fInteger.gcd(((IntegerSym)that).fInteger));
    }

    public IntegerSym lcm(IntegerSym that) {
        if (this.isZero() && that.isZero()) {
            return (IntegerSym)F.C0;
        }
        BigInteger a = this.fInteger.abs();
        BigInteger b = that.fInteger.abs();
        BigInteger gcd = this.fInteger.gcd(b);
        BigInteger lcm = a.multiply(b).divide(gcd);
        return IntegerSym.newInstance(lcm);
    }

    @Override
    public IInteger lcm(IInteger that) {
        return this.lcm((IntegerSym)that);
    }

    public final int hashCode() {
        if (this.fHashValue == 0) {
            this.fHashValue = this.fInteger.hashCode();
        }
        return this.fHashValue;
    }

    public boolean isLargerThan(BigInteger that) {
        return this.fInteger.compareTo(that) > 0;
    }

    @Override
    public boolean isNegative() {
        return this.fInteger.compareTo(BigInteger.ZERO) < 0;
    }

    @Override
    public boolean isNumEqualInteger(IInteger ii) throws ArithmeticException {
        return this.equals(ii);
    }

    @Override
    public boolean isPositive() {
        return this.fInteger.compareTo(BigInteger.ZERO) > 0;
    }

    @Override
    public boolean isZero() {
        return this.fInteger.equals(BigInteger.ZERO);
    }

    @Override
    public boolean isOne() {
        return this.fInteger.equals(BigInteger.ONE);
    }

    @Override
    public boolean isMinusOne() {
        return this.fInteger.equals(BI_MINUS_ONE);
    }

    @Override
    public int intValue() {
        return (int)this.fInteger.longValue();
    }

    @Override
    public long longValue() {
        return this.fInteger.longValue();
    }

    public IntegerSym mod(IntegerSym that) {
        return IntegerSym.newInstance(this.fInteger.mod(that.fInteger));
    }

    public IntegerSym multiply(IntegerSym that) {
        return IntegerSym.newInstance(this.fInteger.multiply(that.fInteger));
    }

    public BigInteger multiply(long val) {
        return this.fInteger.multiply(BigInteger.valueOf(val));
    }

    @Override
    public ISignedNumber negate() {
        return IntegerSym.newInstance(this.fInteger.negate());
    }

    @Override
    public ISignedNumber opposite() {
        return IntegerSym.newInstance(this.fInteger.negate());
    }

    @Override
    public IExpr plus(IExpr that) {
        if (that instanceof IntegerSym) {
            return this.add((IntegerSym)that);
        }
        if (this.isZero()) {
            return that;
        }
        if (that instanceof FractionSym) {
            return FractionSym.valueOf(this.fInteger).add((FractionSym)that);
        }
        return super.plus(that);
    }

    @Override
    public ISignedNumber divideBy(ISignedNumber that) {
        if (that instanceof IntegerSym) {
            return FractionSym.valueOf(this.fInteger).divideBy(that);
        }
        if (that instanceof FractionSym) {
            return FractionSym.valueOf(this.fInteger).divideBy(that);
        }
        return Num.valueOf(this.fInteger.doubleValue() / that.doubleValue());
    }

    @Override
    public ISignedNumber subtractFrom(ISignedNumber that) {
        if (that instanceof IntegerSym) {
            return this.add((IntegerSym)that.negate());
        }
        if (this.isZero()) {
            return that.negate();
        }
        if (that instanceof FractionSym) {
            return FractionSym.valueOf(this.fInteger).subtractFrom(that);
        }
        return Num.valueOf(this.fInteger.doubleValue() - that.doubleValue());
    }

    @Override
    public IntegerSym pow(int exp) {
        return IntegerSym.newInstance(this.fInteger.pow(exp));
    }

    @Override
    public ISignedNumber inverse() {
        if (NumberUtil.isNegative(this.fInteger)) {
            return FractionSym.valueOf(BigInteger.valueOf(-1L), this.fInteger.negate());
        }
        return FractionSym.valueOf(BigInteger.ONE, this.fInteger);
    }

    public BigInteger shiftLeft(int n) {
        return this.fInteger.shiftLeft(n);
    }

    public BigInteger shiftRight(int n) {
        return this.fInteger.shiftRight(n);
    }

    public BigInteger subtract(BigInteger that) {
        return this.fInteger.subtract(that);
    }

    @Override
    public IInteger subtract(IInteger that) {
        return IntegerSym.newInstance(this.fInteger.subtract(that.getBigNumerator()));
    }

    @Override
    public IExpr times(IExpr that) {
        if (that instanceof IntegerSym) {
            return this.multiply((IntegerSym)that);
        }
        if (this.isZero()) {
            return F.C0;
        }
        if (that instanceof FractionSym) {
            return FractionSym.valueOf(this.fInteger).multiply((FractionSym)that);
        }
        return super.times(that);
    }

    public byte[] toByteArray() {
        return this.fInteger.toByteArray();
    }

    @Override
    public BigInteger getBigNumerator() {
        return this.fInteger;
    }

    @Override
    public IInteger getNumerator() {
        return this;
    }

    @Override
    public IInteger getDenominator() {
        return F.C1;
    }

    @Override
    public BigFraction getFraction() {
        return new BigFraction(this.fInteger);
    }

    public List<IInteger> factorize() {
        ArrayList<IInteger> result = new ArrayList<IInteger>();
        IntegerSym b = this;
        if (this.sign() < 0) {
            b = b.multiply(IntegerSym.valueOf(-1L));
            result.add(IntegerSym.valueOf(-1L));
        } else {
            if (b.fInteger.equals(BigInteger.ZERO)) {
                result.add(IntegerSym.valueOf(0L));
                return result;
            }
            if (b.fInteger.equals(BigInteger.ONE)) {
                result.add(IntegerSym.valueOf(1L));
                return result;
            }
        }
        TreeMap<Integer, Integer> map = new TreeMap<Integer, Integer>();
        BigInteger rest = Primality.countPrimes1021(b.fInteger, map);
        for (Map.Entry entry : map.entrySet()) {
            int key = (Integer)entry.getKey();
            IntegerSym is = IntegerSym.valueOf(key);
            for (int i = 0; i < (Integer)entry.getValue(); ++i) {
                result.add(is);
            }
        }
        if (rest.equals(BigInteger.ONE)) {
            return result;
        }
        b = IntegerSym.valueOf(rest);
        TreeMap<BigInteger, Integer> bigMap = new TreeMap<BigInteger, Integer>();
        Primality.pollardRhoFactors(b.getBigNumerator(), bigMap);
        for (Map.Entry entry : bigMap.entrySet()) {
            BigInteger key = (BigInteger)entry.getKey();
            IntegerSym is = IntegerSym.valueOf(key);
            for (int i = 0; i < (Integer)entry.getValue(); ++i) {
                result.add(is);
            }
        }
        return result;
    }

    public IAST factorInteger() {
        IInteger last = IntegerSym.valueOf(-2L);
        int count = 0;
        List<IInteger> iFactors = this.factorize();
        IAST list = F.List();
        IAST subList = null;
        for (int i = 0; i < iFactors.size(); ++i) {
            IInteger factor = iFactors.get(i);
            if (!((Object)last).equals(factor)) {
                if (subList != null) {
                    subList.add(IntegerSym.valueOf(count));
                    list.add(subList);
                }
                count = 0;
                subList = F.List((IExpr)factor);
            }
            ++count;
            last = factor;
        }
        if (subList != null) {
            subList.add(IntegerSym.valueOf(count));
            list.add(subList);
        }
        return list;
    }

    public IInteger eulerPhi() throws ArithmeticException {
        IAST ast = this.factorInteger();
        IInteger phi = IntegerSym.valueOf(1L);
        for (int i = 1; i < ast.size(); ++i) {
            IAST element = (IAST)ast.get(i);
            IntegerSym q = (IntegerSym)element.get(1);
            int c = ((IInteger)element.get(2)).toInt();
            phi = c == 1 ? phi.multiply(q.subtract(IntegerSym.valueOf(1L))) : phi.multiply(q.subtract(IntegerSym.valueOf(1L)).multiply(q.pow(c - 1)));
        }
        return phi;
    }

    public IntegerSym moebiusMu() {
        if (this.compareTo(IntegerSym.valueOf(1L)) == 0) {
            return IntegerSym.valueOf(1L);
        }
        IAST ast = this.factorInteger();
        IntegerSym max = IntegerSym.valueOf(1L);
        for (int i = 1; i < ast.size(); ++i) {
            IAST element = (IAST)ast.get(i);
            IntegerSym c = (IntegerSym)element.get(2);
            if (c.compareTo(max) <= 0) continue;
            max = c;
        }
        if (max.compareTo(IntegerSym.valueOf(1L)) > 0) {
            return IntegerSym.valueOf(0L);
        }
        if ((ast.size() - 1 & 1) == 1) {
            return IntegerSym.valueOf(-1L);
        }
        return IntegerSym.valueOf(1L);
    }

    private IntegerSym jacobiSymbolF() {
        IntegerSym a = this.mod(IntegerSym.valueOf(8L));
        if (a.compareTo(IntegerSym.valueOf(1L)) == 0) {
            return IntegerSym.valueOf(1L);
        }
        if (a.compareTo(IntegerSym.valueOf(7L)) == 0) {
            return IntegerSym.valueOf(1L);
        }
        return IntegerSym.valueOf(-1L);
    }

    private IntegerSym jacobiSymbolG(IntegerSym i2) {
        IntegerSym a = this.mod(IntegerSym.valueOf(4L));
        if (a.compareTo(IntegerSym.valueOf(1L)) == 0) {
            return IntegerSym.valueOf(1L);
        }
        IntegerSym b = this.mod(IntegerSym.valueOf(4L));
        if (b.compareTo(IntegerSym.valueOf(1L)) == 0) {
            return IntegerSym.valueOf(1L);
        }
        return IntegerSym.valueOf(-1L);
    }

    public IntegerSym jacobiSymbol(IntegerSym b) {
        if (this.isOne()) {
            return IntegerSym.valueOf(1L);
        }
        if (this.compareTo(IntegerSym.valueOf(2L)) == 0) {
            return b.jacobiSymbolF();
        }
        if (!this.isOdd()) {
            return this.quotient(IntegerSym.valueOf(2L)).jacobiSymbol(b).multiply(IntegerSym.valueOf(2L).jacobiSymbol(b));
        }
        return b.quotient(this).jacobiSymbol(this).multiply(this.jacobiSymbolG(b));
    }

    public IInteger[] primitiveRoots() throws ArithmeticException {
        IntegerSym phi = (IntegerSym)this.eulerPhi();
        int size = phi.eulerPhi().toInt();
        if (size <= 0) {
            return null;
        }
        IAST ast = phi.factorInteger();
        IntegerSym[] d = new IntegerSym[ast.size() - 1];
        for (int i = 1; i < ast.size(); ++i) {
            IAST element = (IAST)ast.get(i);
            IntegerSym q = (IntegerSym)element.get(1);
            d[i - 1] = phi.quotient(q);
        }
        int k = 0;
        IntegerSym n = this;
        IntegerSym m = IntegerSym.valueOf(1L);
        IInteger[] resultArray = new IntegerSym[size];
        while (m.compareTo(n) < 0) {
            boolean b = m.gcd(n).compareTo(IntegerSym.valueOf(1L)) == 0;
            for (int i = 0; i < d.length; ++i) {
                b = b && m.modPow(d[i], n).compareTo(IntegerSym.valueOf(1L)) > 0;
            }
            if (b) {
                resultArray[k++] = m;
            }
            m = m.add(IntegerSym.valueOf(1L));
        }
        if (resultArray[0] == null) {
            return new IntegerSym[0];
        }
        return resultArray;
    }

    @Override
    public int compareTo(IntegerSym that) {
        return this.fInteger.compareTo(that.fInteger);
    }

    public IntegerSym[] divideAndRemainder(IntegerSym that) {
        IntegerSym[] res = new IntegerSym[2];
        BigInteger[] largeRes = this.fInteger.divideAndRemainder(that.fInteger);
        res[0] = IntegerSym.newInstance(largeRes[0]);
        res[1] = IntegerSym.newInstance(largeRes[1]);
        return res;
    }

    @Override
    public boolean isEven() {
        return NumberUtil.isEven(this.fInteger);
    }

    @Override
    public boolean isOdd() {
        return NumberUtil.isOdd(this.fInteger);
    }

    public IntegerSym modInverse(IntegerSym m) {
        return IntegerSym.newInstance(this.fInteger.modInverse(m.fInteger));
    }

    public IntegerSym modPow(IntegerSym exp, IntegerSym m) {
        return IntegerSym.newInstance(this.fInteger.modPow(exp.fInteger, m.fInteger));
    }

    @Override
    public int toInt() throws ArithmeticException {
        return NumberUtil.toInt(this.fInteger);
    }

    @Override
    public long toLong() throws ArithmeticException {
        return NumberUtil.toLong(this.fInteger);
    }

    @Override
    public int sign() {
        return this.fInteger.signum();
    }

    public IInteger sqrt() throws ArithmeticException {
        return this.nthRoot(2);
    }

    @Override
    public IInteger nthRoot(int n) throws ArithmeticException {
        IntegerSym result;
        if (this.sign() == 0) {
            return IntegerSym.valueOf(0L);
        }
        if (this.sign() < 0) {
            if (n % 2 == 0) {
                throw new ArithmeticException();
            }
            return (IntegerSym)((IntegerSym)this.negate()).nthRoot(n).negate();
        }
        IntegerSym temp = this;
        do {
            result = temp;
        } while ((temp = this.divideAndRemainder(temp.pow(n - 1))[0].add(temp.multiply(IntegerSym.valueOf(n - 1))).divideAndRemainder(IntegerSym.valueOf(n))[0]).compareTo(result) < 0);
        return result;
    }

    @Override
    public IInteger[] nthRootSplit(int n) throws ArithmeticException {
        IInteger[] result = new IInteger[2];
        if (this.sign() == 0) {
            result[0] = IntegerSym.valueOf(0L);
            result[1] = IntegerSym.valueOf(1L);
            return result;
        }
        if (this.sign() < 0) {
            if (n % 2 == 0) {
                throw new ArithmeticException();
            }
            result = ((IntegerSym)this.negate()).nthRootSplit(n);
            result[1] = (IInteger)result[1].negate();
            return result;
        }
        IntegerSym b = this;
        TreeMap<Integer, Integer> map = new TreeMap<Integer, Integer>();
        BigInteger rest = Primality.countPrimes1021(b.fInteger, map);
        IntegerSym nthRoot = IntegerSym.valueOf(1L);
        IntegerSym restFactors = IntegerSym.valueOf(rest);
        for (Map.Entry entry : map.entrySet()) {
            int mod;
            IntegerSym primeLE1021 = IntegerSym.valueOf(((Integer)entry.getKey()).intValue());
            int primeCounter = (Integer)entry.getValue();
            int div = primeCounter / n;
            if (div > 0) {
                nthRoot = nthRoot.multiply(primeLE1021.pow(div));
            }
            if ((mod = primeCounter % n) <= 0) continue;
            restFactors = restFactors.multiply(primeLE1021.pow(mod));
        }
        result[0] = nthRoot;
        result[1] = restFactors;
        return result;
    }

    @Override
    public int complexSign() {
        return this.sign();
    }

    @Override
    public IInteger ceil() {
        return this;
    }

    @Override
    public IInteger floor() {
        return this;
    }

    @Override
    public IInteger round() {
        return this;
    }

    @Override
    public int compareTo(IExpr obj) {
        if (obj instanceof IntegerSym) {
            return this.fInteger.compareTo(((IntegerSym)obj).fInteger);
        }
        if (obj instanceof FractionSym) {
            return -((FractionSym)obj).fRational.compareTo(new BigFraction(this.fInteger, BigInteger.ONE));
        }
        return this.hierarchy() - obj.hierarchy();
    }

    @Override
    public boolean isLessThan(ISignedNumber obj) {
        if (obj instanceof IntegerSym) {
            return this.fInteger.compareTo(((IntegerSym)obj).fInteger) < 0;
        }
        if (obj instanceof FractionSym) {
            return -((FractionSym)obj).fRational.compareTo(new BigFraction(this.fInteger, BigInteger.ONE)) < 0;
        }
        return this.fInteger.doubleValue() < obj.doubleValue();
    }

    @Override
    public boolean isGreaterThan(ISignedNumber obj) {
        if (obj instanceof IntegerSym) {
            return this.fInteger.compareTo(((IntegerSym)obj).fInteger) > 0;
        }
        if (obj instanceof FractionSym) {
            return -((FractionSym)obj).fRational.compareTo(new BigFraction(this.fInteger, BigInteger.ONE)) > 0;
        }
        return this.fInteger.doubleValue() < obj.doubleValue();
    }

    @Override
    public ISymbol head() {
        return F.IntegerHead;
    }

    public String toString() {
        try {
            StringBuilder sb = new StringBuilder();
            OutputFormFactory.get().convertInteger(sb, this, Integer.MIN_VALUE);
            return sb.toString();
        }
        catch (Exception exception) {
            return this.fInteger.toString();
        }
    }

    @Override
    public String internalFormString(boolean symbolsAsFactoryMethod, int depth) {
        int value = NumberUtil.toInt(this.fInteger);
        switch (value) {
            case -1: {
                return "CN1";
            }
            case -2: {
                return "CN2";
            }
            case -3: {
                return "CN3";
            }
            case -4: {
                return "CN4";
            }
            case -5: {
                return "CN5";
            }
            case 0: {
                return "C0";
            }
            case 1: {
                return "C1";
            }
            case 2: {
                return "C2";
            }
            case 3: {
                return "C3";
            }
            case 4: {
                return "C4";
            }
            case 5: {
                return "C5";
            }
        }
        return "ZZ(" + value + "L)";
    }

    @Override
    public <T> T accept(IVisitor<T> visitor) {
        return visitor.visit(this);
    }

    @Override
    public boolean accept(IVisitorBoolean visitor) {
        return visitor.visit(this);
    }

    @Override
    public int accept(IVisitorInt visitor) {
        return visitor.visit(this);
    }

    @Override
    public ISignedNumber getIm() {
        return F.C0;
    }

    @Override
    public ISignedNumber getRe() {
        return this;
    }
}

