/*
 * Decompiled with CFR 0.152.
 */
package org.matheclipse.core.eval.interfaces;

import org.apache.commons.math3.linear.FieldMatrix;
import org.apache.commons.math3.linear.RealMatrix;
import org.matheclipse.core.convert.Convert;
import org.matheclipse.core.eval.exception.Validate;
import org.matheclipse.core.eval.interfaces.AbstractFunctionEvaluator;
import org.matheclipse.core.expression.ExprFieldElement;
import org.matheclipse.core.interfaces.IAST;
import org.matheclipse.core.interfaces.IExpr;

public abstract class AbstractMatrix1Matrix
extends AbstractFunctionEvaluator {
    @Override
    public IExpr evaluate(IAST function) {
        try {
            Validate.checkSize(function, 2);
            IAST list = (IAST)function.get(1);
            FieldMatrix<ExprFieldElement> matrix = Convert.list2Matrix(list);
            matrix = this.matrixEval(matrix);
            return Convert.matrix2List(matrix);
        }
        catch (ClassCastException e) {
            e.printStackTrace();
        }
        catch (IndexOutOfBoundsException e) {
            e.printStackTrace();
        }
        return null;
    }

    @Override
    public IExpr numericEval(IAST function) {
        try {
            if (function.size() == 2) {
                IAST list = (IAST)function.get(1);
                RealMatrix matrix = Convert.list2RealMatrix(list);
                matrix = this.realMatrixEval(matrix);
                return Convert.realMatrix2List(matrix);
            }
        }
        catch (ClassCastException e) {
            e.printStackTrace();
        }
        catch (IndexOutOfBoundsException e) {
            e.printStackTrace();
        }
        return this.evaluate(function);
    }

    public abstract FieldMatrix<ExprFieldElement> matrixEval(FieldMatrix<ExprFieldElement> var1);

    public abstract RealMatrix realMatrixEval(RealMatrix var1);
}

