/*
 * Decompiled with CFR 0.152.
 */
package org.matheclipse.core.eval.interfaces;

import org.matheclipse.core.convert.AST2Expr;
import org.matheclipse.core.eval.EvalEngine;
import org.matheclipse.core.eval.interfaces.IFunctionEvaluator;
import org.matheclipse.core.expression.F;
import org.matheclipse.core.interfaces.IAST;
import org.matheclipse.core.interfaces.IComplex;
import org.matheclipse.core.interfaces.IExpr;
import org.matheclipse.core.interfaces.INumber;
import org.matheclipse.core.interfaces.ISymbol;
import org.matheclipse.core.patternmatching.PatternMatcherAndInvoker;
import org.matheclipse.parser.client.Parser;
import org.matheclipse.parser.client.SyntaxError;
import org.matheclipse.parser.client.ast.ASTNode;

public abstract class AbstractFunctionEvaluator
implements IFunctionEvaluator {
    @Override
    public IExpr numericEval(IAST ast) {
        return this.evaluate(ast);
    }

    public IAST getRuleAST() {
        return null;
    }

    @Override
    public void setUp(ISymbol symbol) throws SyntaxError {
        EvalEngine engine = EvalEngine.get();
        IAST ruleList = this.getRuleAST();
        if (ruleList != null) {
            engine.addRules(ruleList);
        }
        F.SYMBOL_OBSERVER.createPredefinedSymbol(symbol.toString());
    }

    private void setUpRules(String[] rules, Parser parser, EvalEngine engine) {
        for (int i = 0; i < rules.length; ++i) {
            ASTNode parsedAST = parser.parse(rules[i]);
            IExpr obj = AST2Expr.CONST.convert(parsedAST);
            engine.evaluate(obj);
        }
    }

    @Override
    public abstract IExpr evaluate(IAST var1);

    public void createRuleFromMethod(ISymbol symbol, String patternString, String methodName) {
        PatternMatcherAndInvoker pm = new PatternMatcherAndInvoker(patternString, (IFunctionEvaluator)this, methodName);
        symbol.putDownRule(pm);
    }

    public static boolean isNegativeExpression(IExpr expr) {
        IAST plus;
        IAST times;
        return expr.isNumber() ? ((INumber)expr).complexSign() < 0 : (expr.isTimes() ? (times = (IAST)expr).arg1().isNumber() && ((INumber)times.arg1()).complexSign() < 0 : expr.isPlus() && (plus = (IAST)expr).arg1().isNumber() && ((INumber)plus.arg1()).complexSign() < 0);
    }

    public static IExpr getPureImaginaryPart(IExpr expr) {
        IAST times;
        IExpr arg1;
        if (expr.isComplex() && ((IComplex)expr).getRe().isZero()) {
            IComplex compl = (IComplex)expr;
            return compl.getIm();
        }
        if (expr.isTimes() && (arg1 = (times = (IAST)expr).arg1()).isComplex() && ((IComplex)arg1).getRe().isZero()) {
            times = times.clone();
            times.set(1, ((IComplex)arg1).getIm());
            return times;
        }
        return null;
    }

    public static IExpr[] getPeriodicParts(IExpr expr) {
        if (expr.isPlus()) {
            IAST plus = (IAST)expr;
            for (int i = 0; i < plus.size(); ++i) {
                IAST times;
                if (!((IExpr)plus.get(i)).isTimes() || (times = (IAST)plus.get(i)).size() != 3 || !times.arg2().equals(F.Pi) || !times.arg1().isRational()) continue;
                IExpr[] result = new IExpr[2];
                IAST cloned = plus.clone();
                cloned.remove(i);
                result[0] = cloned;
                result[1] = times.arg1();
                return result;
            }
        }
        return null;
    }
}

