/*
 * Decompiled with CFR 0.152.
 */
package org.matheclipse.core.eval;

import com.google.common.base.Predicate;
import java.io.Writer;
import org.matheclipse.core.convert.AST2Expr;
import org.matheclipse.core.eval.EvalEngine;
import org.matheclipse.core.eval.MathMLUtilities;
import org.matheclipse.core.interfaces.IAST;
import org.matheclipse.core.interfaces.IExpr;
import org.matheclipse.parser.client.Parser;
import org.matheclipse.parser.client.SyntaxError;
import org.matheclipse.parser.client.ast.ASTNode;
import org.matheclipse.parser.client.math.MathException;

public class EvalUtilities
extends MathMLUtilities {
    public EvalUtilities() {
        this(new EvalEngine(), false, false);
    }

    public EvalUtilities(boolean mathMTagPrefix, boolean relaxedSyntax) {
        this(new EvalEngine(relaxedSyntax), mathMTagPrefix, relaxedSyntax);
    }

    public EvalUtilities(EvalEngine evalEngine, boolean mathMTagPrefix, boolean relaxedSyntax) {
        super(evalEngine, mathMTagPrefix, relaxedSyntax);
    }

    public IExpr evaluate(String inputExpression) throws MathException {
        if (inputExpression != null) {
            this.startRequest();
            this.fEvalEngine.reset();
            IExpr parsedExpression = this.fEvalEngine.parse(inputExpression);
            if (parsedExpression != null) {
                this.fEvalEngine.reset();
                IExpr temp = this.fEvalEngine.evaluate(parsedExpression);
                this.fEvalEngine.addOut(temp);
                return temp;
            }
        }
        return null;
    }

    public static IExpr eval(String inputExpression, EvalEngine evalEngine) throws MathException {
        if (inputExpression != null) {
            IExpr parsedExpression;
            EvalEngine.set(evalEngine);
            boolean SIMPLE_SYNTAX = true;
            ASTNode node = null;
            try {
                Parser parser = new Parser(SIMPLE_SYNTAX);
                node = parser.parse(inputExpression);
            }
            catch (SyntaxError se1) {
                try {
                    SIMPLE_SYNTAX = false;
                    Parser parser = new Parser(SIMPLE_SYNTAX);
                    node = parser.parse(inputExpression);
                }
                catch (SyntaxError se2) {
                    throw se1;
                }
            }
            if (node != null && (parsedExpression = AST2Expr.CONST.convert(node)) != null) {
                evalEngine.reset();
                IExpr temp = evalEngine.evaluate(parsedExpression);
                evalEngine.addOut(temp);
                return temp;
            }
        }
        return null;
    }

    public IExpr evaluate(IExpr parsedExpression) throws MathException {
        if (parsedExpression != null) {
            this.startRequest();
            this.fEvalEngine.reset();
            IExpr temp = this.fEvalEngine.evaluate(parsedExpression);
            this.fEvalEngine.addOut(temp);
            return temp;
        }
        return null;
    }

    public String toJavaForm(String inputExpression) throws MathException {
        IExpr parsedExpression = null;
        if (inputExpression != null) {
            ASTNode node = this.fEvalEngine.parseNode(inputExpression);
            parsedExpression = AST2Expr.CONST.convert(node);
            return parsedExpression.internalFormString(false, 0);
        }
        return "";
    }

    public IAST evalTrace(String inputExpression, Predicate<IExpr> matcher, IAST list) throws MathException {
        IExpr parsedExpression = null;
        if (inputExpression != null) {
            this.startRequest();
            this.fEvalEngine.reset();
            parsedExpression = this.fEvalEngine.parse(inputExpression);
            if (parsedExpression != null) {
                this.fEvalEngine.reset();
                IAST temp = this.fEvalEngine.evalTrace(parsedExpression, matcher, list);
                this.fEvalEngine.addOut(temp);
                return temp;
            }
        }
        return null;
    }

    public IAST evalTrace(IExpr parsedExpression, Predicate<IExpr> matcher, IAST list) throws RuntimeException {
        if (parsedExpression != null) {
            this.startRequest();
            this.fEvalEngine.reset();
            IAST temp = this.fEvalEngine.evalTrace(parsedExpression, matcher, list);
            return temp;
        }
        return null;
    }

    @Override
    public synchronized void toMathML(String inputExpression, Writer out) {
        try {
            IExpr result = this.evaluate(inputExpression);
            if (result != null) {
                this.toMathML(result, out);
            }
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
    }
}

