/*
 * Decompiled with CFR 0.152.
 */
package org.matheclipse.core.builtin.function;

import org.matheclipse.core.eval.exception.Validate;
import org.matheclipse.core.eval.interfaces.AbstractCoreFunctionEvaluator;
import org.matheclipse.core.expression.F;
import org.matheclipse.core.generic.BinaryMap;
import org.matheclipse.core.generic.interfaces.BiFunction;
import org.matheclipse.core.interfaces.IAST;
import org.matheclipse.core.interfaces.IExpr;
import org.matheclipse.core.interfaces.ISymbol;

public class FoldList
extends AbstractCoreFunctionEvaluator {
    @Override
    public IExpr evaluate(IAST ast) {
        Validate.checkSize(ast, 4);
        return FoldList.evaluateNestList(ast, F.List());
    }

    public static IExpr evaluateNestList(IAST ast, IAST resultList) {
        try {
            IExpr temp = F.eval((IExpr)ast.get(3));
            if (temp.isAST()) {
                IAST list = (IAST)temp;
                IExpr arg1 = F.eval(ast.arg1());
                IExpr arg2 = F.eval(ast.arg2());
                FoldList.foldLeft(arg2, list, 1, list.size(), new BinaryMap(F.ast(arg1)), resultList);
                return resultList;
            }
        }
        catch (ArithmeticException arithmeticException) {
            // empty catch block
        }
        return null;
    }

    @Override
    public void setUp(ISymbol symbol) {
        symbol.setAttributes(96);
    }

    public static IAST foldLeft(IExpr expr, IAST list, int start, int end, BiFunction<IExpr, IExpr, ? extends IExpr> binaryFunction, IAST resultCollection) {
        if (start < end) {
            IExpr elem = expr;
            resultCollection.add(elem);
            for (int i = start; i < end; ++i) {
                elem = binaryFunction.apply(elem, (IExpr)list.get(i));
                resultCollection.add(elem);
            }
        }
        return resultCollection;
    }
}

