/*
 * Decompiled with CFR 0.152.
 */
package org.matheclipse.core.builtin.function;

import org.matheclipse.core.eval.exception.Validate;
import org.matheclipse.core.eval.interfaces.AbstractCoreFunctionEvaluator;
import org.matheclipse.core.expression.F;
import org.matheclipse.core.interfaces.IAST;
import org.matheclipse.core.interfaces.IExpr;

public class Depth
extends AbstractCoreFunctionEvaluator {
    @Override
    public IExpr evaluate(IAST ast) {
        Validate.checkSize(ast, 2);
        IExpr arg1 = F.eval(ast.arg1());
        if (!arg1.isAST()) {
            return F.C1;
        }
        return F.integer(Depth.depth((IAST)ast.arg1(), 1));
    }

    public static int depth(IAST list, int headOffset) {
        int maxDepth = 1;
        for (int i = headOffset; i < list.size(); ++i) {
            int d;
            if (!((IExpr)list.get(i)).isAST() || (d = Depth.depth((IAST)list.get(i), headOffset)) <= maxDepth) continue;
            maxDepth = d;
        }
        return ++maxDepth;
    }
}

