/*
 * Decompiled with CFR 0.152.
 */
package org.matheclipse.core.builtin.function;

import org.matheclipse.core.builtin.function.Module;
import org.matheclipse.core.eval.EvalEngine;
import org.matheclipse.core.eval.exception.ConditionException;
import org.matheclipse.core.eval.exception.Validate;
import org.matheclipse.core.eval.interfaces.AbstractCoreFunctionEvaluator;
import org.matheclipse.core.expression.F;
import org.matheclipse.core.interfaces.IAST;
import org.matheclipse.core.interfaces.IExpr;
import org.matheclipse.core.interfaces.ISymbol;

public class Condition
extends AbstractCoreFunctionEvaluator {
    @Override
    public IExpr evaluate(IAST ast) {
        Validate.checkSize(ast, 3);
        if (F.evalTrue(ast.arg2())) {
            return F.eval(ast.arg1());
        }
        if (EvalEngine.get().isEvalLHSMode()) {
            return null;
        }
        throw new ConditionException(ast);
    }

    public static boolean checkCondition(IExpr arg1, IExpr arg2, EvalEngine engine) {
        if (F.evalTrue(arg2)) {
            if (arg1.isCondition()) {
                return Condition.checkCondition(arg1.getAt(1), arg1.getAt(2), engine);
            }
            if (arg2.isModule()) {
                return Module.checkModuleCondition(arg2.getAt(1), arg2.getAt(2), engine);
            }
            return true;
        }
        return false;
    }

    @Override
    public void setUp(ISymbol symbol) {
        symbol.setAttributes(96);
    }
}

