/*
 * Decompiled with CFR 0.152.
 */
package org.matheclipse.combinatoric;

import java.util.List;
import org.matheclipse.combinatoric.AbstractListStepVisitor;

public abstract class AbstractMultisetStepVisitor<T>
extends AbstractListStepVisitor<T> {
    protected int[] multiset;

    public AbstractMultisetStepVisitor(List<? extends T> sortedList) {
        this(sortedList, 0, sortedList.size());
    }

    public AbstractMultisetStepVisitor(List<? extends T> sortedList, int start) {
        this(sortedList, start, sortedList.size());
    }

    public AbstractMultisetStepVisitor(List<? extends T> sortedList, int start, int end) {
        super(sortedList, start, end);
        this.toIntArray(sortedList, start, end);
    }

    private final void toIntArray(List<? extends T> sortedList, int start, int end) {
        this.multiset = new int[end - start];
        this.array = new Object[end - start];
        T lastT = sortedList.get(start);
        int index = 0;
        int j = 0;
        this.multiset[j++] = index;
        this.array[index] = lastT;
        for (int i = start + 1; i < end; ++i) {
            T currentT = sortedList.get(i);
            if (currentT.equals(lastT)) {
                this.multiset[j++] = index;
            } else {
                this.multiset[j++] = ++index;
                this.array[index] = currentT;
            }
            lastT = currentT;
        }
    }

    @Override
    public int[] getMultisetArray() {
        return this.multiset;
    }
}

