/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.svn.core.wc;

import org.tmatesoft.svn.core.ISVNCanceller;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.SVNURL;
import org.tmatesoft.svn.core.auth.ISVNAuthenticationManager;
import org.tmatesoft.svn.core.internal.wc.DefaultSVNOptions;
import org.tmatesoft.svn.core.io.SVNRepository;
import org.tmatesoft.svn.core.io.SVNRepositoryFactory;
import org.tmatesoft.svn.core.wc.DefaultSVNRepositoryPool;
import org.tmatesoft.svn.core.wc.ISVNEventHandler;
import org.tmatesoft.svn.core.wc.ISVNOptions;
import org.tmatesoft.svn.core.wc.ISVNRepositoryPool;
import org.tmatesoft.svn.core.wc.SVNChangelistClient;
import org.tmatesoft.svn.core.wc.SVNCommitClient;
import org.tmatesoft.svn.core.wc.SVNCopyClient;
import org.tmatesoft.svn.core.wc.SVNDiffClient;
import org.tmatesoft.svn.core.wc.SVNLogClient;
import org.tmatesoft.svn.core.wc.SVNMoveClient;
import org.tmatesoft.svn.core.wc.SVNStatusClient;
import org.tmatesoft.svn.core.wc.SVNUpdateClient;
import org.tmatesoft.svn.core.wc.SVNWCClient;
import org.tmatesoft.svn.core.wc.SVNWCUtil;
import org.tmatesoft.svn.core.wc.admin.SVNAdminClient;
import org.tmatesoft.svn.core.wc.admin.SVNLookClient;
import org.tmatesoft.svn.util.ISVNDebugLog;
import org.tmatesoft.svn.util.SVNDebugLog;

public class SVNClientManager
implements ISVNRepositoryPool {
    private ISVNOptions myOptions;
    private SVNCommitClient myCommitClient;
    private SVNCopyClient myCopyClient;
    private SVNDiffClient myDiffClient;
    private SVNLogClient myLogClient;
    private SVNMoveClient myMoveClient;
    private SVNStatusClient myStatusClient;
    private SVNUpdateClient myUpdateClient;
    private SVNWCClient myWCClient;
    private SVNChangelistClient myChangelistClient;
    private SVNAdminClient myAdminClient;
    private SVNLookClient myLookClient;
    private ISVNEventHandler myEventHandler;
    private ISVNRepositoryPool myRepositoryPool;
    private ISVNDebugLog myDebugLog;
    private boolean myIsIgnoreExternals;

    private SVNClientManager(ISVNOptions options, ISVNRepositoryPool repositoryPool) {
        this.myOptions = options;
        if (this.myOptions == null) {
            this.myOptions = SVNWCUtil.createDefaultOptions(true);
        }
        this.myRepositoryPool = repositoryPool;
    }

    private SVNClientManager(ISVNOptions options, ISVNAuthenticationManager authManager) {
        this(options, new DefaultSVNRepositoryPool(authManager == null ? SVNWCUtil.createDefaultAuthenticationManager() : authManager, options));
    }

    public static SVNClientManager newInstance() {
        return new SVNClientManager(null, (ISVNAuthenticationManager)null);
    }

    public static SVNClientManager newInstance(ISVNOptions options) {
        return new SVNClientManager(options, (ISVNAuthenticationManager)null);
    }

    public static SVNClientManager newInstance(ISVNOptions options, ISVNAuthenticationManager authManager) {
        return new SVNClientManager(options, authManager);
    }

    public static SVNClientManager newInstance(ISVNOptions options, ISVNRepositoryPool repositoryPool) {
        return new SVNClientManager(options, repositoryPool);
    }

    public static SVNClientManager newInstance(DefaultSVNOptions options, String userName, String password) {
        boolean storeAuth = options == null ? true : options.isAuthStorageEnabled();
        ISVNAuthenticationManager authManager = SVNWCUtil.createDefaultAuthenticationManager(null, userName, password, storeAuth);
        return new SVNClientManager((ISVNOptions)options, authManager);
    }

    public SVNRepository createRepository(SVNURL url, boolean mayReuse) throws SVNException {
        if (this.myRepositoryPool != null) {
            return this.myRepositoryPool.createRepository(url, mayReuse);
        }
        SVNRepository repository = SVNRepositoryFactory.create(url);
        repository.setAuthenticationManager(SVNWCUtil.createDefaultAuthenticationManager());
        repository.setDebugLog(this.getDebugLog());
        return repository;
    }

    public void shutdownConnections(boolean shutdownAll) {
        if (this.myRepositoryPool != null) {
            this.myRepositoryPool.dispose();
        }
    }

    public void dispose() {
        if (this.myRepositoryPool != null) {
            this.myRepositoryPool.dispose();
        }
    }

    public ISVNOptions getOptions() {
        return this.myOptions;
    }

    public void setEventHandler(ISVNEventHandler handler) {
        this.myEventHandler = handler;
        this.setCanceller(handler);
        if (this.myCommitClient != null) {
            this.myCommitClient.setEventHandler(handler);
        }
        if (this.myCopyClient != null) {
            this.myCopyClient.setEventHandler(handler);
        }
        if (this.myDiffClient != null) {
            this.myDiffClient.setEventHandler(handler);
        }
        if (this.myLogClient != null) {
            this.myLogClient.setEventHandler(handler);
        }
        if (this.myMoveClient != null) {
            this.myMoveClient.setEventHandler(handler);
        }
        if (this.myStatusClient != null) {
            this.myStatusClient.setEventHandler(handler);
        }
        if (this.myUpdateClient != null) {
            this.myUpdateClient.setEventHandler(handler);
        }
        if (this.myWCClient != null) {
            this.myWCClient.setEventHandler(handler);
        }
        if (this.myChangelistClient != null) {
            this.myChangelistClient.setEventHandler(handler);
        }
        if (this.myAdminClient != null) {
            this.myAdminClient.setEventHandler(handler);
        }
        if (this.myLookClient != null) {
            this.myLookClient.setEventHandler(handler);
        }
    }

    public void setIgnoreExternals(boolean isIgnoreExternals) {
        this.myIsIgnoreExternals = isIgnoreExternals;
        if (this.myCommitClient != null) {
            this.myCommitClient.setIgnoreExternals(this.myIsIgnoreExternals);
        }
        if (this.myCopyClient != null) {
            this.myCopyClient.setIgnoreExternals(this.myIsIgnoreExternals);
        }
        if (this.myDiffClient != null) {
            this.myDiffClient.setIgnoreExternals(this.myIsIgnoreExternals);
        }
        if (this.myLogClient != null) {
            this.myLogClient.setIgnoreExternals(this.myIsIgnoreExternals);
        }
        if (this.myMoveClient != null) {
            this.myMoveClient.setIgnoreExternals(this.myIsIgnoreExternals);
        }
        if (this.myStatusClient != null) {
            this.myStatusClient.setIgnoreExternals(this.myIsIgnoreExternals);
        }
        if (this.myUpdateClient != null) {
            this.myUpdateClient.setIgnoreExternals(this.myIsIgnoreExternals);
        }
        if (this.myWCClient != null) {
            this.myWCClient.setIgnoreExternals(this.myIsIgnoreExternals);
        }
        if (this.myChangelistClient != null) {
            this.myChangelistClient.setIgnoreExternals(this.myIsIgnoreExternals);
        }
        if (this.myAdminClient != null) {
            this.myAdminClient.setIgnoreExternals(this.myIsIgnoreExternals);
        }
        if (this.myLookClient != null) {
            this.myLookClient.setIgnoreExternals(this.myIsIgnoreExternals);
        }
    }

    public boolean isIgnoreExternals() {
        return this.myIsIgnoreExternals;
    }

    public void setOptions(ISVNOptions options) {
        this.myOptions = options;
        if (this.myCommitClient != null) {
            this.myCommitClient.setOptions(options);
        }
        if (this.myCopyClient != null) {
            this.myCopyClient.setOptions(options);
        }
        if (this.myDiffClient != null) {
            this.myDiffClient.setOptions(options);
        }
        if (this.myLogClient != null) {
            this.myLogClient.setOptions(options);
        }
        if (this.myMoveClient != null) {
            this.myMoveClient.setOptions(options);
        }
        if (this.myStatusClient != null) {
            this.myStatusClient.setOptions(options);
        }
        if (this.myUpdateClient != null) {
            this.myUpdateClient.setOptions(options);
        }
        if (this.myWCClient != null) {
            this.myWCClient.setOptions(options);
        }
        if (this.myAdminClient != null) {
            this.myAdminClient.setOptions(options);
        }
        if (this.myLookClient != null) {
            this.myLookClient.setOptions(options);
        }
    }

    public SVNCommitClient getCommitClient() {
        if (this.myCommitClient == null) {
            this.myCommitClient = new SVNCommitClient(this, this.myOptions);
            this.myCommitClient.setEventHandler(this.myEventHandler);
            this.myCommitClient.setDebugLog(this.getDebugLog());
            this.myCommitClient.setIgnoreExternals(this.myIsIgnoreExternals);
        }
        return this.myCommitClient;
    }

    public SVNAdminClient getAdminClient() {
        if (this.myAdminClient == null) {
            this.myAdminClient = new SVNAdminClient(this, this.myOptions);
            this.myAdminClient.setEventHandler(this.myEventHandler);
            this.myAdminClient.setDebugLog(this.getDebugLog());
            this.myAdminClient.setIgnoreExternals(this.myIsIgnoreExternals);
        }
        return this.myAdminClient;
    }

    public SVNLookClient getLookClient() {
        if (this.myLookClient == null) {
            this.myLookClient = new SVNLookClient(this, this.myOptions);
            this.myLookClient.setEventHandler(this.myEventHandler);
            this.myLookClient.setDebugLog(this.getDebugLog());
            this.myLookClient.setIgnoreExternals(this.myIsIgnoreExternals);
        }
        return this.myLookClient;
    }

    public SVNCopyClient getCopyClient() {
        if (this.myCopyClient == null) {
            this.myCopyClient = new SVNCopyClient(this, this.myOptions);
            this.myCopyClient.setEventHandler(this.myEventHandler);
            this.myCopyClient.setDebugLog(this.getDebugLog());
            this.myCopyClient.setIgnoreExternals(this.myIsIgnoreExternals);
        }
        return this.myCopyClient;
    }

    public SVNDiffClient getDiffClient() {
        if (this.myDiffClient == null) {
            this.myDiffClient = new SVNDiffClient(this, this.myOptions);
            this.myDiffClient.setEventHandler(this.myEventHandler);
            this.myDiffClient.setDebugLog(this.getDebugLog());
            this.myDiffClient.setIgnoreExternals(this.myIsIgnoreExternals);
        }
        return this.myDiffClient;
    }

    public SVNLogClient getLogClient() {
        if (this.myLogClient == null) {
            this.myLogClient = new SVNLogClient(this, this.myOptions);
            this.myLogClient.setEventHandler(this.myEventHandler);
            this.myLogClient.setDebugLog(this.getDebugLog());
            this.myLogClient.setIgnoreExternals(this.myIsIgnoreExternals);
        }
        return this.myLogClient;
    }

    public SVNMoveClient getMoveClient() {
        if (this.myMoveClient == null) {
            this.myMoveClient = new SVNMoveClient(this, this.myOptions);
            this.myMoveClient.setEventHandler(this.myEventHandler);
            this.myMoveClient.setDebugLog(this.getDebugLog());
            this.myMoveClient.setIgnoreExternals(this.myIsIgnoreExternals);
        }
        return this.myMoveClient;
    }

    public SVNStatusClient getStatusClient() {
        if (this.myStatusClient == null) {
            this.myStatusClient = new SVNStatusClient(this, this.myOptions);
            this.myStatusClient.setEventHandler(this.myEventHandler);
            this.myStatusClient.setDebugLog(this.getDebugLog());
            this.myStatusClient.setIgnoreExternals(this.myIsIgnoreExternals);
        }
        return this.myStatusClient;
    }

    public SVNUpdateClient getUpdateClient() {
        if (this.myUpdateClient == null) {
            this.myUpdateClient = new SVNUpdateClient(this, this.myOptions);
            this.myUpdateClient.setEventHandler(this.myEventHandler);
            this.myUpdateClient.setDebugLog(this.getDebugLog());
            this.myUpdateClient.setIgnoreExternals(this.myIsIgnoreExternals);
        }
        return this.myUpdateClient;
    }

    public SVNWCClient getWCClient() {
        if (this.myWCClient == null) {
            this.myWCClient = new SVNWCClient(this, this.myOptions);
            this.myWCClient.setEventHandler(this.myEventHandler);
            this.myWCClient.setDebugLog(this.getDebugLog());
            this.myWCClient.setIgnoreExternals(this.myIsIgnoreExternals);
        }
        return this.myWCClient;
    }

    public SVNChangelistClient getChangelistClient() {
        if (this.myChangelistClient == null) {
            this.myChangelistClient = new SVNChangelistClient(this, this.myOptions);
            this.myChangelistClient.setEventHandler(this.myEventHandler);
            this.myChangelistClient.setDebugLog(this.getDebugLog());
            this.myChangelistClient.setIgnoreExternals(this.myIsIgnoreExternals);
        }
        return this.myChangelistClient;
    }

    public ISVNDebugLog getDebugLog() {
        if (this.myDebugLog == null) {
            return SVNDebugLog.getDefaultLog();
        }
        return this.myDebugLog;
    }

    public void setDebugLog(ISVNDebugLog log) {
        this.myDebugLog = log;
        if (this.myCommitClient != null) {
            this.myCommitClient.setDebugLog(log);
        }
        if (this.myCopyClient != null) {
            this.myCopyClient.setDebugLog(log);
        }
        if (this.myDiffClient != null) {
            this.myDiffClient.setDebugLog(log);
        }
        if (this.myLogClient != null) {
            this.myLogClient.setDebugLog(log);
        }
        if (this.myMoveClient != null) {
            this.myMoveClient.setDebugLog(log);
        }
        if (this.myStatusClient != null) {
            this.myStatusClient.setDebugLog(log);
        }
        if (this.myUpdateClient != null) {
            this.myUpdateClient.setDebugLog(log);
        }
        if (this.myWCClient != null) {
            this.myWCClient.setDebugLog(log);
        }
        if (this.myChangelistClient != null) {
            this.myChangelistClient.setDebugLog(log);
        }
        if (this.myAdminClient != null) {
            this.myAdminClient.setDebugLog(log);
        }
        if (this.myLookClient != null) {
            this.myLookClient.setDebugLog(log);
        }
        if (this.myRepositoryPool != null) {
            this.myRepositoryPool.setDebugLog(log);
        }
    }

    public void setAuthenticationManager(ISVNAuthenticationManager authManager) {
        if (this.myRepositoryPool != null) {
            this.myRepositoryPool.setAuthenticationManager(authManager);
        }
    }

    public void setCanceller(ISVNCanceller canceller) {
        if (this.myRepositoryPool != null) {
            this.myRepositoryPool.setCanceller(canceller);
        }
    }

    public ISVNRepositoryPool getRepositoryPool() {
        return this.myRepositoryPool;
    }
}

