/*
 * Decompiled with CFR 0.152.
 */
package jnumeric;

import java.lang.reflect.Array;
import jnumeric.PyMultiarray;
import jnumeric.UnaryFunction;

final class Cos
extends UnaryFunction {
    Cos() {
    }

    @Override
    String docString() {
        return "cos(a [,r]) returns cos(a) and stores the result in r if supplied.\n";
    }

    @Override
    public PyMultiarray Double(PyMultiarray a) {
        for (int i = 0; i < Array.getLength(a.data); ++i) {
            Array.setDouble(a.data, i, Math.cos(Array.getDouble(a.data, i)));
        }
        return a;
    }

    @Override
    public PyMultiarray ComplexDouble(PyMultiarray a) {
        for (int i = 0; i < Array.getLength(a.data); i += 2) {
            double re = Array.getDouble(a.data, i);
            double im = Array.getDouble(a.data, i + 1);
            double eim = Math.exp(im);
            double cosre = Math.cos(re);
            double sinre = Math.sin(re);
            Array.setDouble(a.data, i, 0.5 * cosre * (eim + 1.0 / eim));
            Array.setDouble(a.data, i + 1, -0.5 * sinre * (eim - 1.0 / eim));
        }
        return a;
    }
}

