/*
 * Decompiled with CFR 0.152.
 */
package jnumeric;

import java.lang.reflect.Array;
import jnumeric.PyMultiarray;
import jnumeric.Umath;
import jnumeric.UnaryFunction;

final class Arctanh
extends UnaryFunction {
    Arctanh() {
    }

    @Override
    String docString() {
        return "arctanh(a [,r]) returns arctanh(a) and stores the result in r if supplied.\n";
    }

    @Override
    public PyMultiarray Double(PyMultiarray a) {
        for (int i = 0; i < Array.getLength(a.data); ++i) {
            double d = Array.getDouble(a.data, i);
            Array.setDouble(a.data, i, 0.5 * Math.log((1.0 + d) / (1.0 - d)));
        }
        return a;
    }

    @Override
    public PyMultiarray ComplexDouble(PyMultiarray a) {
        return PyMultiarray.asarray(UnaryFunction.cp1_2.__mul__(Umath.log.__call__(UnaryFunction.cp1.__add__(a).__div__(UnaryFunction.cp1.__sub__(a)))));
    }
}

