/*
 * Decompiled with CFR 0.152.
 */
package tabclose;

import java.awt.Window;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.event.WindowFocusListener;
import java.util.EventListener;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JTabbedPane;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import javax.swing.plaf.TabbedPaneUI;
import tabclose.CloseListener;
import tabclose.CloseTabPaneEnhancedUI;
import tabclose.CloseTabPaneUI;
import tabclose.DoubleClickListener;
import tabclose.MaxListener;
import tabclose.PopupOutsideListener;

public class CloseTabbedPane
extends JTabbedPane {
    private int overTabIndex = -1;
    private int ImageType;
    private CloseTabPaneUI paneUI;

    public CloseTabbedPane(int ImageType) {
        super.setTabLayoutPolicy(1);
        this.ImageType = ImageType;
        this.paneUI = new CloseTabPaneEnhancedUI();
        this.setCloseImage(this.ImageType);
        super.setUI(this.paneUI);
    }

    public int getOverTabIndex() {
        return this.overTabIndex;
    }

    public void setCloseImage(int ii) {
        this.paneUI.setCloseImage(ii);
    }

    public boolean isCloseEnabled() {
        return this.paneUI.isCloseEnabled();
    }

    @Override
    public void setTabLayoutPolicy(int tabLayoutPolicy) {
    }

    @Override
    public void setTabPlacement(int tabPlacement) {
    }

    @Override
    public void setUI(TabbedPaneUI ui) {
    }

    public void setCloseIcon(boolean b) {
        this.paneUI.setCloseIcon(b);
    }

    public void detachTab(int index) {
        if (index < 0 || index >= this.getTabCount()) {
            return;
        }
        System.out.println(index);
        final JFrame frame = new JFrame();
        Window parentWindow = SwingUtilities.windowForComponent(this);
        final int tabIndex = index;
        final JComponent c = (JComponent)this.getComponentAt(tabIndex);
        final Icon icon = this.getIconAt(tabIndex);
        final String title = this.getTitleAt(tabIndex);
        final String toolTip = this.getToolTipTextAt(tabIndex);
        final Border border = c.getBorder();
        this.removeTabAt(index);
        c.setPreferredSize(c.getSize());
        frame.setTitle(title);
        frame.getContentPane().add(c);
        frame.setLocation(parentWindow.getLocation());
        frame.pack();
        frame.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent event) {
                frame.dispose();
                CloseTabbedPane.this.insertTab(title, icon, c, toolTip, Math.min(tabIndex, CloseTabbedPane.this.getTabCount()));
                c.setBorder(border);
                CloseTabbedPane.this.setSelectedComponent(c);
            }
        });
        WindowFocusListener windowFocusListener = new WindowFocusListener(){
            long start;
            long end;

            @Override
            public void windowGainedFocus(WindowEvent e) {
                this.start = System.currentTimeMillis();
            }

            @Override
            public void windowLostFocus(WindowEvent e) {
                this.end = System.currentTimeMillis();
                long elapsed = this.end - this.start;
                if (elapsed < 100L) {
                    frame.toFront();
                }
                frame.removeWindowFocusListener(this);
            }
        };
        frame.addWindowFocusListener(windowFocusListener);
        frame.setVisible(true);
        frame.toFront();
    }

    public synchronized void addCloseListener(CloseListener l) {
        this.listenerList.add(CloseListener.class, l);
    }

    public synchronized void addMaxListener(MaxListener l) {
        this.listenerList.add(MaxListener.class, l);
    }

    public synchronized void addDoubleClickListener(DoubleClickListener l) {
        this.listenerList.add(DoubleClickListener.class, l);
    }

    public synchronized void addPopupOutsideListener(PopupOutsideListener l) {
        this.listenerList.add(PopupOutsideListener.class, l);
    }

    public synchronized void removeCloseListener(CloseListener l) {
        this.listenerList.remove(CloseListener.class, l);
    }

    public synchronized void removeMaxListener(MaxListener l) {
        this.listenerList.remove(MaxListener.class, l);
    }

    public synchronized void removeDoubleClickListener(DoubleClickListener l) {
        this.listenerList.remove(DoubleClickListener.class, l);
    }

    public synchronized void removePopupOutsideListener(PopupOutsideListener l) {
        this.listenerList.remove(PopupOutsideListener.class, l);
    }

    public void fireCloseTabEvent(MouseEvent e, int overTabIndex) {
        this.overTabIndex = overTabIndex;
        EventListener[] closeListeners = this.getListeners(CloseListener.class);
        for (int i = 0; i < closeListeners.length; ++i) {
            ((CloseListener)closeListeners[i]).closeOperation(e);
        }
    }

    public void fireMaxTabEvent(MouseEvent e, int overTabIndex) {
        this.overTabIndex = overTabIndex;
        EventListener[] maxListeners = this.getListeners(MaxListener.class);
        for (int i = 0; i < maxListeners.length; ++i) {
            ((MaxListener)maxListeners[i]).maxOperation(e);
        }
    }

    public void fireDoubleClickTabEvent(MouseEvent e, int overTabIndex) {
        this.overTabIndex = overTabIndex;
        EventListener[] dClickListeners = this.getListeners(DoubleClickListener.class);
        for (int i = 0; i < dClickListeners.length; ++i) {
            ((DoubleClickListener)dClickListeners[i]).doubleClickOperation(e);
        }
    }

    public void firePopupOutsideTabEvent(MouseEvent e) {
        this.overTabIndex = -1;
        EventListener[] popupListeners = this.getListeners(PopupOutsideListener.class);
        for (int i = 0; i < popupListeners.length; ++i) {
            ((PopupOutsideListener)popupListeners[i]).popupOutsideOperation(e);
        }
    }
}

