/*
 * Decompiled with CFR 0.152.
 */
package jehep.utils.downloadman;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.RandomAccessFile;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.Observable;
import jehep.ui.SetEnv;
import jehep.utils.Utils;

class Download
extends Observable
implements Runnable {
    private static final int MAX_BUFFER_SIZE = 1024;
    public static final String[] STATUSES = new String[]{"Downloading", "Paused", "Complete", "Cancelled", "Error"};
    public static final int DOWNLOADING = 0;
    public static final int PAUSED = 1;
    public static final int COMPLETE = 2;
    public static final int CANCELLED = 3;
    public static final int ERROR = 4;
    private URL url;
    private int size;
    private int downloaded;
    private int status;
    private String filepath;
    private int totaljars = 0;
    private int ncurrent = 0;

    public Download(URL url, String filepath, int totaljars, int ncurrent) {
        this.url = url;
        this.size = -1;
        this.downloaded = 0;
        this.status = 0;
        this.filepath = filepath;
        this.totaljars = totaljars;
        this.ncurrent = ncurrent;
        this.renameFiles(filepath, filepath + "_old");
        this.download();
    }

    public String getUrl() {
        return this.url.toString();
    }

    public int getSize() {
        return this.size;
    }

    public float getProgress() {
        return (float)this.downloaded / (float)this.size * 100.0f;
    }

    public int getStatus() {
        return this.status;
    }

    public void pause() {
        this.status = 1;
        this.stateChanged();
    }

    public void resume() {
        this.status = 0;
        this.stateChanged();
        this.download();
    }

    public void cancel() {
        this.status = 3;
        this.stateChanged();
    }

    private void error() {
        this.status = 4;
        this.stateChanged();
    }

    private void download() {
        Thread thread = new Thread(this);
        thread.start();
    }

    private String getFileName(URL url) {
        String fileName = url.getFile();
        return fileName.substring(fileName.lastIndexOf(47) + 1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        RandomAccessFile file2 = null;
        InputStream stream = null;
        try {
            byte[] buffer;
            int read;
            int contentLength;
            HttpURLConnection connection = (HttpURLConnection)this.url.openConnection();
            connection.setRequestProperty("Range", "bytes=" + this.downloaded + "-");
            connection.connect();
            if (connection.getResponseCode() / 100 != 2) {
                this.error();
            }
            if ((contentLength = connection.getContentLength()) < 1) {
                this.error();
            }
            if (this.size == -1) {
                this.size = contentLength;
                this.stateChanged();
            }
            file2 = new RandomAccessFile(this.filepath, "rw");
            file2.seek(this.downloaded);
            stream = connection.getInputStream();
            while (this.status == 0 && (read = stream.read(buffer = this.size - this.downloaded > 1024 ? new byte[1024] : new byte[this.size - this.downloaded])) != -1) {
                file2.write(buffer, 0, read);
                this.downloaded += read;
                this.stateChanged();
            }
            if (this.status == 0) {
                this.status = 2;
                this.stateChanged();
                if (this.ncurrent == this.totaljars - 1 && (SetEnv.hasToBeRestarted = true)) {
                    Utils.userMessage("Message", "DataMelt has to be restarted after this update", 1);
                    SetEnv.hasToBeRestarted = false;
                }
            }
        }
        catch (Exception e) {
            this.error();
        }
        finally {
            if (file2 != null) {
                try {
                    file2.close();
                }
                catch (Exception exception) {}
            }
            if (stream != null) {
                try {
                    stream.close();
                }
                catch (Exception exception) {}
            }
        }
    }

    private void stateChanged() {
        this.setChanged();
        this.notifyObservers();
    }

    void renameFiles(String oldName, String newName) {
        String sCurrentLine = "";
        try {
            BufferedReader br = new BufferedReader(new FileReader(oldName));
            BufferedWriter bw = new BufferedWriter(new FileWriter(newName));
            while ((sCurrentLine = br.readLine()) != null) {
                bw.write(sCurrentLine);
                bw.newLine();
            }
            br.close();
            bw.close();
            File org = new File(oldName);
            org.delete();
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

