/*
 * Decompiled with CFR 0.152.
 */
package jehep.ui.codeview;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import javax.imageio.ImageIO;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import jehep.ui.mainGUI;
import org.scilab.forge.jlatexmath.TeXFormula;
import org.scilab.forge.jlatexmath.TeXIcon;

public class Design
extends JPanel {
    private static final long serialVersionUID = 1L;
    BufferedImage image;

    public Design(mainGUI win, String latex, String imagename, int fSize) {
        File file2 = new File(imagename);
        if (file2.exists()) {
            return;
        }
        this.setBackground(Color.white);
        this.setPreferredSize(new Dimension(fSize, fSize));
        TeXFormula formula = null;
        TeXIcon icon = null;
        try {
            formula = new TeXFormula(latex);
            icon = formula.createTeXIcon(0, (float)fSize);
        }
        catch (Exception e) {
            JOptionPane.showMessageDialog(win, "Error in LaTeX parsing the line:" + latex);
            return;
        }
        icon.setInsets(new Insets(5, 5, 5, 5));
        this.setPreferredSize(new Dimension(icon.getIconWidth(), icon.getIconHeight()));
        this.image = new BufferedImage(icon.getIconWidth(), icon.getIconHeight(), 2);
        Graphics2D g2 = this.image.createGraphics();
        g2.setColor(Color.white);
        g2.fillRect(0, 0, icon.getIconWidth(), icon.getIconHeight());
        JLabel jl = new JLabel();
        jl.setForeground(new Color(0, 0, 0));
        icon.paintIcon((Component)jl, (Graphics)g2, 0, -1 * (int)((double)fSize * 0.25));
        try {
            ImageIO.write((RenderedImage)this.image, "png", file2.getAbsoluteFile());
        }
        catch (IOException ex) {
            JOptionPane.showMessageDialog(win, "Error in generation of LaTeX image:" + latex);
            return;
        }
    }

    @Override
    protected void paintComponent(Graphics g) {
        super.paintComponent(g);
        if (this.image != null) {
            int height = this.getSize().height;
            int width = this.getSize().width;
            g.drawImage(this.image, 0, 0, width, height, this);
        }
    }
}

