/*
 * Decompiled with CFR 0.152.
 */
package jehep.ui;

import java.awt.BorderLayout;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.BorderFactory;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.border.Border;
import jehep.ui.BIcon;
import jehep.ui.BMark;
import jehep.ui.Constants;
import jehep.ui.Editor;
import jehep.ui.SetEnv;
import jehep.ui.mainGUI;

public class PanelRight
extends JPanel
implements MouseListener,
Constants {
    private mainGUI win;
    private static final long serialVersionUID = 1L;
    private int width = 7;
    private static int Counter = 0;
    private static int TOTlines = 0;
    private JPopupMenu menu;

    public PanelRight(mainGUI win) {
        this.win = win;
        this.setOpaque(true);
        this.setMinimumSize(new Dimension(this.width, this.width));
        this.setPreferredSize(new Dimension(this.width, win.getWinHeight()));
        this.setMaximumSize(new Dimension(this.width, 1000000));
        this.setLayout(new BorderLayout());
        this.setToolTipText("Click here for bookmarks");
        Border myborder = BorderFactory.createEmptyBorder();
        this.setBorder(myborder);
        this.addMouseListener(this);
    }

    @Override
    public void paint(Graphics g) {
        super.paint(g);
        if (SetEnv.isCodeView > -1) {
            return;
        }
        Dimension size = this.getSize();
        double h = size.getHeight();
        h -= 40.0;
        int msize = Editor.bmarks[Editor.Selected].mark.size();
        for (int i = 0; i < msize; ++i) {
            BMark bm = Editor.bmarks[Editor.Selected].mark.get(i);
            int p = bm.getLinePos();
            int tot = TOTlines;
            int pp = 20 + (int)(h * (double)p / (double)tot);
            BIcon bi = bm.getIcon();
            bi.paintIcon(this, g, 0, pp);
        }
    }

    public void addBookmark(int cpos, int lpos, int totlines) {
        Editor.bmarks[Editor.Selected].mark.add(new BMark(cpos, lpos, totlines, "Bookmark " + Integer.toString(Counter + 1), new BIcon()));
    }

    public void RepaintBookmarks(int totlines) {
        TOTlines = totlines;
        this.repaint();
    }

    public void ClearBookmarks() {
        Editor.bmarks[Editor.Selected].mark.clear();
    }

    @Override
    public void mouseClicked(MouseEvent e) {
        int msize = Editor.bmarks[Editor.Selected].mark.size();
        int ikk = 0;
        for (int i = 0; i < msize; ++i) {
            BMark bm = Editor.bmarks[Editor.Selected].mark.get(i);
            BIcon bi = bm.getIcon();
            Rectangle rect = bi.getBounds();
            if (!rect.contains(e.getX(), e.getY())) continue;
            int p = bm.getLinePos();
            int c = bm.getCaretPos();
            SetEnv.MessageBar.setText("Jumped to the bookmark at line " + p);
            this.win.goToLine(p);
            ++ikk;
        }
        if (ikk == 0) {
            this.win.addBookMark();
        }
    }

    @Override
    public void mouseEntered(MouseEvent e) {
        int msize = Editor.bmarks[Editor.Selected].mark.size();
        for (int i = 0; i < msize; ++i) {
            BMark bm = Editor.bmarks[Editor.Selected].mark.get(i);
            BIcon bi = bm.getIcon();
            Rectangle rect = bi.getBounds();
            if (!rect.contains(e.getX(), e.getY())) continue;
            int p = bm.getLinePos();
            SetEnv.MessageBar.setText(bm.getName() + " at line " + p);
        }
    }

    @Override
    public void mouseExited(MouseEvent e) {
        SetEnv.MessageBar.setText("");
    }

    @Override
    public void mousePressed(MouseEvent e) {
    }

    @Override
    public void mouseReleased(MouseEvent e) {
    }
}

