/*
 * Decompiled with CFR 0.152.
 */
package jehep.syntax;

import javax.swing.text.Segment;
import jehep.syntax.KeywordMap;
import jehep.syntax.TokenMarker;

public class TextTokenMarker
extends TokenMarker {
    public static final String METHOD_DELIMITERS = " \t~!%^*()-+=|\\#/{}[]:;\"'<>,.?@";
    private static KeywordMap textKeywords;
    protected boolean spell;
    protected boolean javadoc;
    protected KeywordMap keywords;
    protected int lastOffset;
    protected int lastKeyword;
    protected int lastWhitespace;

    public TextTokenMarker() {
        this(true, false, TextTokenMarker.getKeywords());
        this.spell = false;
        this.javadoc = false;
    }

    public TextTokenMarker(boolean spell, boolean javadoc, KeywordMap keywords) {
        this.spell = spell;
        this.javadoc = javadoc;
        this.keywords = keywords;
        spell = false;
        javadoc = false;
    }

    @Override
    public byte markTokensImpl(byte token, Segment line, int lineIndex) {
        int offset;
        char[] array = line.array;
        this.lastOffset = offset = line.offset;
        this.lastKeyword = offset;
        int length = line.count + offset;
        boolean backslash = false;
        block11: for (int i = offset; i < length; ++i) {
            char c = array[i];
            if (c == '\\') {
                backslash = !backslash;
                continue;
            }
            switch (token) {
                case 0: {
                    switch (c) {
                        default: 
                    }
                    backslash = false;
                    if (!Character.isLetterOrDigit(c) && c != '_') {
                        this.doKeyword(line, i, c);
                    }
                    if (METHOD_DELIMITERS.indexOf(c) != -1) {
                        this.lastWhitespace = i;
                    }
                }
                case 1: 
                case 2: {
                    backslash = false;
                    continue block11;
                }
                case 4: {
                    if (backslash) {
                        backslash = false;
                    }
                }
                default: {
                    throw new InternalError("Invalid state: " + token);
                }
            }
        }
        if (token == 0) {
            this.doKeyword(line, length, '\u0000');
        }
        switch (token) {
            case 3: 
            case 4: {
                this.addToken(length - this.lastOffset, (byte)10);
                token = 0;
                break;
            }
            case 7: {
                this.addToken(length - this.lastOffset, token);
                if (!backslash) {
                    token = 0;
                }
            }
            default: {
                this.addToken(length - this.lastOffset, token);
            }
        }
        return token;
    }

    public static KeywordMap getKeywords() {
        if (textKeywords == null) {
            textKeywords = new KeywordMap(true);
        }
        return textKeywords;
    }

    protected boolean doKeyword(Segment line, int i, char c) {
        int i1 = i + 1;
        int len = i - this.lastKeyword;
        byte id = this.keywords.lookup(line, this.lastKeyword, len);
        if (id != 0) {
            if (this.lastKeyword != this.lastOffset) {
                this.addToken(this.lastKeyword - this.lastOffset, (byte)0);
            }
            this.addToken(len, id);
            this.lastOffset = i;
            this.lastKeyword = i1;
            this.lastWhitespace = i;
            return true;
        }
        this.lastKeyword = i1;
        return true;
    }
}

