/*
 * Decompiled with CFR 0.152.
 */
package jehep.syntax;

import javax.swing.text.Segment;
import jehep.syntax.KeywordMap;
import jehep.syntax.TokenMarker;

public class TSQLTokenMarker
extends TokenMarker {
    boolean bracket = false;
    protected static KeywordMap sqlKeywords;
    protected KeywordMap keywords;
    private int lastOffset;
    private int lastKeyword;

    public TSQLTokenMarker() {
        this(TSQLTokenMarker.getKeywords());
    }

    public TSQLTokenMarker(KeywordMap keywords) {
        this.keywords = keywords;
    }

    @Override
    public byte markTokensImpl(byte token, Segment line, int lineIndex) {
        int offset;
        char[] array = line.array;
        this.lastOffset = offset = line.offset;
        this.lastKeyword = offset;
        int length = line.count + offset;
        block21: for (int i = offset; i < length; ++i) {
            int i1 = i + 1;
            char c = array[i];
            switch (token) {
                case 0: {
                    switch (c) {
                        case '[': {
                            this.bracket = true;
                        }
                        case '\"': {
                            this.doKeyword(line, i, c);
                            this.addToken(i - this.lastOffset, token);
                            token = (byte)3;
                            this.lastOffset = this.lastKeyword = i;
                            break;
                        }
                        case '\'': {
                            this.doKeyword(line, i, c);
                            this.addToken(i - this.lastOffset, token);
                            token = (byte)4;
                            this.lastOffset = this.lastKeyword = i;
                            break;
                        }
                        case ':': {
                            if (this.lastKeyword == offset) {
                                if (this.doKeyword(line, i, c)) break;
                                this.addToken(i1 - this.lastOffset, (byte)5);
                                this.lastOffset = this.lastKeyword = i1;
                                break;
                            }
                            if (!this.doKeyword(line, i, c)) continue block21;
                            break;
                        }
                        case '/': {
                            this.doKeyword(line, i, c);
                            if (length - i <= 1 || array[i1] != '*') continue block21;
                            this.addToken(i - this.lastOffset, token);
                            this.lastOffset = this.lastKeyword = i;
                            token = (byte)2;
                            break;
                        }
                        case '-': {
                            this.doKeyword(line, i, c);
                            if (length - i <= 1) continue block21;
                            switch (array[i1]) {
                                case '-': {
                                    this.addToken(i - this.lastOffset, token);
                                    this.addToken(length - i, (byte)1);
                                    this.lastOffset = this.lastKeyword = length;
                                    break block21;
                                }
                            }
                            continue block21;
                        }
                        default: {
                            if (Character.isLetterOrDigit(c) || c == '_') continue block21;
                            this.doKeyword(line, i, c);
                            break;
                        }
                    }
                    continue block21;
                }
                case 2: {
                    if (c != '*' || length - i <= 1 || array[i1] != '/') continue block21;
                    this.addToken(++i + 1 - this.lastOffset, token);
                    token = 0;
                    this.lastOffset = this.lastKeyword = i + 1;
                    continue block21;
                }
                case 3: {
                    if (c != '\"' && c != ']') continue block21;
                    this.addToken(i1 - this.lastOffset, token);
                    token = 0;
                    this.lastOffset = this.lastKeyword = i1;
                    this.bracket = false;
                    continue block21;
                }
                case 4: {
                    if (c != '\'') continue block21;
                    this.addToken(i1 - this.lastOffset, token);
                    token = 0;
                    this.lastOffset = this.lastKeyword = i1;
                    continue block21;
                }
                default: {
                    throw new InternalError("Invalid state: " + token);
                }
            }
        }
        if (token == 0) {
            this.doKeyword(line, length, '\u0000');
        }
        switch (token) {
            case 3: 
            case 4: {
                this.addToken(length - this.lastOffset, this.bracket ? (byte)3 : 10);
                token = (byte)(this.bracket ? 3 : 0);
                break;
            }
            case 7: {
                this.addToken(length - this.lastOffset, token);
                token = 0;
                break;
            }
            default: {
                this.addToken(length - this.lastOffset, token);
            }
        }
        return token;
    }

    public static KeywordMap getKeywords() {
        if (sqlKeywords == null) {
            sqlKeywords = new KeywordMap(true);
            sqlKeywords.add("ADD", (byte)6);
            sqlKeywords.add("ALTER", (byte)6);
            sqlKeywords.add("ANSI_NULLS", (byte)6);
            sqlKeywords.add("AS", (byte)6);
            sqlKeywords.add("ASC", (byte)6);
            sqlKeywords.add("AUTHORIZATION", (byte)6);
            sqlKeywords.add("BACKUP", (byte)6);
            sqlKeywords.add("BEGIN", (byte)6);
            sqlKeywords.add("BREAK", (byte)6);
            sqlKeywords.add("BROWSE", (byte)6);
            sqlKeywords.add("BULK", (byte)6);
            sqlKeywords.add("BY", (byte)6);
            sqlKeywords.add("CASCADE", (byte)6);
            sqlKeywords.add("CHECK", (byte)6);
            sqlKeywords.add("CHECKPOINT", (byte)6);
            sqlKeywords.add("CLOSE", (byte)6);
            sqlKeywords.add("CLUSTERED", (byte)6);
            sqlKeywords.add("COLUMN", (byte)6);
            sqlKeywords.add("COMMIT", (byte)6);
            sqlKeywords.add("COMMITTED", (byte)6);
            sqlKeywords.add("COMPUTE", (byte)6);
            sqlKeywords.add("CONFIRM", (byte)6);
            sqlKeywords.add("CONSTRAINT", (byte)6);
            sqlKeywords.add("CONTAINS", (byte)6);
            sqlKeywords.add("CONTAINSTABLE", (byte)6);
            sqlKeywords.add("CONTINUE", (byte)6);
            sqlKeywords.add("CONTROLROW", (byte)6);
            sqlKeywords.add("CREATE", (byte)6);
            sqlKeywords.add("CURRENT", (byte)6);
            sqlKeywords.add("CURRENT_DATE", (byte)6);
            sqlKeywords.add("CURRENT_TIME", (byte)6);
            sqlKeywords.add("CURSOR", (byte)6);
            sqlKeywords.add("DATABASE", (byte)6);
            sqlKeywords.add("DBCC", (byte)6);
            sqlKeywords.add("DEALLOCATE", (byte)6);
            sqlKeywords.add("DECLARE", (byte)6);
            sqlKeywords.add("DEFAULT", (byte)6);
            sqlKeywords.add("DELETE", (byte)6);
            sqlKeywords.add("DENY", (byte)6);
            sqlKeywords.add("DESC", (byte)6);
            sqlKeywords.add("DISK", (byte)6);
            sqlKeywords.add("DISTINCT", (byte)6);
            sqlKeywords.add("DISTRIBUTED", (byte)6);
            sqlKeywords.add("DOUBLE", (byte)6);
            sqlKeywords.add("DROP", (byte)6);
            sqlKeywords.add("DUMMY", (byte)6);
            sqlKeywords.add("DUMP", (byte)6);
            sqlKeywords.add("ELSE", (byte)6);
            sqlKeywords.add("END", (byte)6);
            sqlKeywords.add("ERRLVL", (byte)6);
            sqlKeywords.add("ERROREXIT", (byte)6);
            sqlKeywords.add("ESCAPE", (byte)6);
            sqlKeywords.add("EXCEPT", (byte)6);
            sqlKeywords.add("EXEC", (byte)6);
            sqlKeywords.add("EXECUTE", (byte)6);
            sqlKeywords.add("EXIT", (byte)6);
            sqlKeywords.add("FETCH", (byte)6);
            sqlKeywords.add("FILE", (byte)6);
            sqlKeywords.add("FILLFACTOR", (byte)6);
            sqlKeywords.add("FLOPPY", (byte)6);
            sqlKeywords.add("FOR", (byte)6);
            sqlKeywords.add("FOREIGN", (byte)6);
            sqlKeywords.add("FREETEXT", (byte)6);
            sqlKeywords.add("FREETEXTTABLE", (byte)6);
            sqlKeywords.add("FROM", (byte)6);
            sqlKeywords.add("FULL", (byte)6);
            sqlKeywords.add("GOTO", (byte)6);
            sqlKeywords.add("GRANT", (byte)6);
            sqlKeywords.add("GROUP", (byte)6);
            sqlKeywords.add("HAVING", (byte)6);
            sqlKeywords.add("HOLDLOCK", (byte)6);
            sqlKeywords.add("IDENTITY_INSERT", (byte)6);
            sqlKeywords.add("IDENTITYCOL", (byte)6);
            sqlKeywords.add("ID", (byte)6);
            sqlKeywords.add("IF", (byte)6);
            sqlKeywords.add("INDEX", (byte)6);
            sqlKeywords.add("INNER", (byte)6);
            sqlKeywords.add("INSERT", (byte)6);
            sqlKeywords.add("INTO", (byte)6);
            sqlKeywords.add("IS", (byte)6);
            sqlKeywords.add("ISOLATION", (byte)6);
            sqlKeywords.add("KEY", (byte)6);
            sqlKeywords.add("KILL", (byte)6);
            sqlKeywords.add("LEVEL", (byte)6);
            sqlKeywords.add("LINENO", (byte)6);
            sqlKeywords.add("LOAD", (byte)6);
            sqlKeywords.add("MAX", (byte)6);
            sqlKeywords.add("MIN", (byte)6);
            sqlKeywords.add("MIRROREXIT", (byte)6);
            sqlKeywords.add("NATIONAL", (byte)6);
            sqlKeywords.add("NOCHECK", (byte)6);
            sqlKeywords.add("NONCLUSTERED", (byte)6);
            sqlKeywords.add("OF", (byte)6);
            sqlKeywords.add("OFF", (byte)6);
            sqlKeywords.add("OFFSETS", (byte)6);
            sqlKeywords.add("ON", (byte)6);
            sqlKeywords.add("ONCE", (byte)6);
            sqlKeywords.add("ONLY", (byte)6);
            sqlKeywords.add("OPEN", (byte)6);
            sqlKeywords.add("OPENDATASOURCE", (byte)6);
            sqlKeywords.add("OPENQUERY", (byte)6);
            sqlKeywords.add("OPENROWSET", (byte)6);
            sqlKeywords.add("OPTION", (byte)6);
            sqlKeywords.add("ORDER", (byte)6);
            sqlKeywords.add("OVER", (byte)6);
            sqlKeywords.add("PERCENT", (byte)6);
            sqlKeywords.add("PERM", (byte)6);
            sqlKeywords.add("PERMANENT", (byte)6);
            sqlKeywords.add("PIPE", (byte)6);
            sqlKeywords.add("PLAN", (byte)6);
            sqlKeywords.add("PRECISION", (byte)6);
            sqlKeywords.add("PREPARE", (byte)6);
            sqlKeywords.add("PRIMARY", (byte)6);
            sqlKeywords.add("PRINT", (byte)6);
            sqlKeywords.add("PRIVILEGES", (byte)6);
            sqlKeywords.add("PROC", (byte)6);
            sqlKeywords.add("PROCEDURE", (byte)6);
            sqlKeywords.add("PROCESSEXIT", (byte)6);
            sqlKeywords.add("PUBLIC", (byte)6);
            sqlKeywords.add("QUOTED_IDENTIFIER", (byte)6);
            sqlKeywords.add("RAISERROR", (byte)6);
            sqlKeywords.add("READ", (byte)6);
            sqlKeywords.add("READTEXT", (byte)6);
            sqlKeywords.add("RECONFIGURE", (byte)6);
            sqlKeywords.add("REFERENCES", (byte)6);
            sqlKeywords.add("REPEATABLE", (byte)6);
            sqlKeywords.add("REPLICATION", (byte)6);
            sqlKeywords.add("RESTORE", (byte)6);
            sqlKeywords.add("RESTRICT", (byte)6);
            sqlKeywords.add("RETURN", (byte)6);
            sqlKeywords.add("REVOKE", (byte)6);
            sqlKeywords.add("ROLLBACK", (byte)6);
            sqlKeywords.add("ROWGUIDCOL", (byte)6);
            sqlKeywords.add("RULE", (byte)6);
            sqlKeywords.add("SAVE", (byte)6);
            sqlKeywords.add("SCHEMA", (byte)6);
            sqlKeywords.add("SELECT", (byte)6);
            sqlKeywords.add("SERIALIZABLE", (byte)6);
            sqlKeywords.add("SET", (byte)6);
            sqlKeywords.add("SETUSER", (byte)6);
            sqlKeywords.add("SHUTDOWN", (byte)6);
            sqlKeywords.add("STATISTICS", (byte)6);
            sqlKeywords.add("TABLE", (byte)6);
            sqlKeywords.add("TAPE", (byte)6);
            sqlKeywords.add("TEMP", (byte)6);
            sqlKeywords.add("TEMPORARY", (byte)6);
            sqlKeywords.add("TEXTIMAGE_ON", (byte)6);
            sqlKeywords.add("THEN", (byte)6);
            sqlKeywords.add("TO", (byte)6);
            sqlKeywords.add("TOP", (byte)6);
            sqlKeywords.add("TRAN", (byte)6);
            sqlKeywords.add("TRANSACTION", (byte)6);
            sqlKeywords.add("TRIGGER", (byte)6);
            sqlKeywords.add("TRUNCATE", (byte)6);
            sqlKeywords.add("TSEQUAL", (byte)6);
            sqlKeywords.add("UNCOMMITTED", (byte)6);
            sqlKeywords.add("UNION", (byte)6);
            sqlKeywords.add("UNIQUE", (byte)6);
            sqlKeywords.add("UPDATE", (byte)6);
            sqlKeywords.add("UPDATETEXT", (byte)6);
            sqlKeywords.add("USE", (byte)6);
            sqlKeywords.add("VALUES", (byte)6);
            sqlKeywords.add("VARYING", (byte)6);
            sqlKeywords.add("VIEW", (byte)6);
            sqlKeywords.add("WAITFOR", (byte)6);
            sqlKeywords.add("WHEN", (byte)6);
            sqlKeywords.add("WHERE", (byte)6);
            sqlKeywords.add("WHILE", (byte)6);
            sqlKeywords.add("WITH", (byte)6);
            sqlKeywords.add("WORK", (byte)6);
            sqlKeywords.add("WRITETEXT", (byte)6);
            sqlKeywords.add("binary", (byte)6);
            sqlKeywords.add("bit", (byte)6);
            sqlKeywords.add("char", (byte)6);
            sqlKeywords.add("character", (byte)6);
            sqlKeywords.add("datetime", (byte)6);
            sqlKeywords.add("decimal", (byte)6);
            sqlKeywords.add("float", (byte)6);
            sqlKeywords.add("image", (byte)6);
            sqlKeywords.add("int", (byte)6);
            sqlKeywords.add("integer", (byte)6);
            sqlKeywords.add("money", (byte)6);
            sqlKeywords.add("name", (byte)6);
            sqlKeywords.add("numeric", (byte)6);
            sqlKeywords.add("nchar", (byte)6);
            sqlKeywords.add("nvarchar", (byte)6);
            sqlKeywords.add("ntext", (byte)6);
            sqlKeywords.add("real", (byte)6);
            sqlKeywords.add("smalldatetime", (byte)6);
            sqlKeywords.add("smallint", (byte)6);
            sqlKeywords.add("smallmoney", (byte)6);
            sqlKeywords.add("text", (byte)6);
            sqlKeywords.add("timestamp", (byte)6);
            sqlKeywords.add("tinyint", (byte)6);
            sqlKeywords.add("uniqueidentifier", (byte)6);
            sqlKeywords.add("varbinary", (byte)6);
            sqlKeywords.add("varchar", (byte)6);
            sqlKeywords.add("@@CONNECTIONS", (byte)7);
            sqlKeywords.add("@@CPU_BUSY", (byte)7);
            sqlKeywords.add("@@CURSOR_ROWS", (byte)7);
            sqlKeywords.add("@@DATEFIRST", (byte)7);
            sqlKeywords.add("@@DBTS", (byte)7);
            sqlKeywords.add("@@ERROR", (byte)7);
            sqlKeywords.add("@@FETCH_STATUS", (byte)7);
            sqlKeywords.add("@@IDENTITY", (byte)7);
            sqlKeywords.add("@@IDLE", (byte)7);
            sqlKeywords.add("@@IO_BUSY", (byte)7);
            sqlKeywords.add("@@LANGID", (byte)7);
            sqlKeywords.add("@@LANGUAGE", (byte)7);
            sqlKeywords.add("@@LOCK_TIMEOUT", (byte)7);
            sqlKeywords.add("@@MAX_CONNECTIONS", (byte)7);
            sqlKeywords.add("@@MAX_PRECISION", (byte)7);
            sqlKeywords.add("@@NESTLEVEL", (byte)7);
            sqlKeywords.add("@@OPTIONS", (byte)7);
            sqlKeywords.add("@@PACK_RECEIVED", (byte)7);
            sqlKeywords.add("@@PACK_SENT", (byte)7);
            sqlKeywords.add("@@PACKET_ERRORS", (byte)7);
            sqlKeywords.add("@@PROCID", (byte)7);
            sqlKeywords.add("@@REMSERVER", (byte)7);
            sqlKeywords.add("@@ROWCOUNT", (byte)7);
            sqlKeywords.add("@@SERVERNAME", (byte)7);
            sqlKeywords.add("@@SERVICENAME", (byte)7);
            sqlKeywords.add("@@SPID", (byte)7);
            sqlKeywords.add("@@TEXTSIZE", (byte)7);
            sqlKeywords.add("@@TIMETICKS", (byte)7);
            sqlKeywords.add("@@TOTAL_ERRORS", (byte)7);
            sqlKeywords.add("@@TOTAL_READ", (byte)7);
            sqlKeywords.add("@@TOTAL_WRITE", (byte)7);
            sqlKeywords.add("@@TRANCOUNT", (byte)7);
            sqlKeywords.add("@@VERSION", (byte)7);
            sqlKeywords.add("ABS", (byte)7);
            sqlKeywords.add("ACOS", (byte)7);
            sqlKeywords.add("APP_NAME", (byte)7);
            sqlKeywords.add("ASCII", (byte)7);
            sqlKeywords.add("ASIN", (byte)7);
            sqlKeywords.add("ATAN", (byte)7);
            sqlKeywords.add("ATN2", (byte)7);
            sqlKeywords.add("AVG", (byte)7);
            sqlKeywords.add("CASE", (byte)7);
            sqlKeywords.add("CAST", (byte)7);
            sqlKeywords.add("CEILING", (byte)7);
            sqlKeywords.add("CHARINDEX", (byte)7);
            sqlKeywords.add("COALESCE", (byte)7);
            sqlKeywords.add("COL_LENGTH", (byte)7);
            sqlKeywords.add("COL_NAME", (byte)7);
            sqlKeywords.add("COLUMNPROPERTY", (byte)7);
            sqlKeywords.add("CONVERT", (byte)7);
            sqlKeywords.add("COS", (byte)7);
            sqlKeywords.add("COT", (byte)7);
            sqlKeywords.add("COUNT", (byte)7);
            sqlKeywords.add("CURRENT_TIME", (byte)7);
            sqlKeywords.add("CURRENT_DATE", (byte)7);
            sqlKeywords.add("CURRENT_TIMESTAMP", (byte)7);
            sqlKeywords.add("CURRENT_USER", (byte)7);
            sqlKeywords.add("CURSOR_STATUS", (byte)7);
            sqlKeywords.add("DATABASEPROPERTY", (byte)7);
            sqlKeywords.add("DATALENGTH", (byte)7);
            sqlKeywords.add("DATEADD", (byte)7);
            sqlKeywords.add("DATEDIFF", (byte)7);
            sqlKeywords.add("DATENAME", (byte)7);
            sqlKeywords.add("DATEPART", (byte)7);
            sqlKeywords.add("DAY", (byte)7);
            sqlKeywords.add("DB_ID", (byte)7);
            sqlKeywords.add("DB_NAME", (byte)7);
            sqlKeywords.add("DEGREES", (byte)7);
            sqlKeywords.add("DIFFERENCE", (byte)7);
            sqlKeywords.add("EXP", (byte)7);
            sqlKeywords.add("FILE_ID", (byte)7);
            sqlKeywords.add("FILE_NAME", (byte)7);
            sqlKeywords.add("FILEGROUP_ID", (byte)7);
            sqlKeywords.add("FILEGROUP_NAME", (byte)7);
            sqlKeywords.add("FILEGROUPPROPERTY", (byte)7);
            sqlKeywords.add("FILEPROPERTY", (byte)7);
            sqlKeywords.add("FLOOR", (byte)7);
            sqlKeywords.add("FORMATMESSAGE", (byte)7);
            sqlKeywords.add("FULLTEXTCATALOGPROPERTY", (byte)7);
            sqlKeywords.add("FULLTEXTSERVICEPROPERTY", (byte)7);
            sqlKeywords.add("GETANSINULL", (byte)7);
            sqlKeywords.add("GETDATE", (byte)7);
            sqlKeywords.add("HOST_ID", (byte)7);
            sqlKeywords.add("HOST_NAME", (byte)7);
            sqlKeywords.add("IDENT_INCR", (byte)7);
            sqlKeywords.add("IDENT_SEED", (byte)7);
            sqlKeywords.add("IDENTITY_INSERT", (byte)7);
            sqlKeywords.add("INDEX_COL", (byte)7);
            sqlKeywords.add("INDEXPROPERTY", (byte)7);
            sqlKeywords.add("IS_MEMBER", (byte)7);
            sqlKeywords.add("IS_SRVROLEMEMBER", (byte)7);
            sqlKeywords.add("ISDATE", (byte)7);
            sqlKeywords.add("ISNULL", (byte)7);
            sqlKeywords.add("ISNUMERIC", (byte)7);
            sqlKeywords.add("LEFT", (byte)7);
            sqlKeywords.add("LEN", (byte)7);
            sqlKeywords.add("LOG", (byte)7);
            sqlKeywords.add("LOG10", (byte)7);
            sqlKeywords.add("LOWER", (byte)7);
            sqlKeywords.add("LTRIM", (byte)7);
            sqlKeywords.add("MONTH", (byte)7);
            sqlKeywords.add("NEWID", (byte)7);
            sqlKeywords.add("NULLIF", (byte)7);
            sqlKeywords.add("OBJECT_ID", (byte)7);
            sqlKeywords.add("OBJECT_NAME", (byte)7);
            sqlKeywords.add("OBJECTPROPERTY", (byte)7);
            sqlKeywords.add("PARSENAME", (byte)7);
            sqlKeywords.add("PATINDEX", (byte)7);
            sqlKeywords.add("PERMISSIONS", (byte)7);
            sqlKeywords.add("PI", (byte)7);
            sqlKeywords.add("POWER", (byte)7);
            sqlKeywords.add("QUOTENAME", (byte)7);
            sqlKeywords.add("RADIANS", (byte)7);
            sqlKeywords.add("RAND", (byte)7);
            sqlKeywords.add("REPLACE", (byte)7);
            sqlKeywords.add("REPLICATE", (byte)7);
            sqlKeywords.add("REVERSE", (byte)7);
            sqlKeywords.add("RIGHT", (byte)7);
            sqlKeywords.add("ROUND", (byte)7);
            sqlKeywords.add("RTRIM", (byte)7);
            sqlKeywords.add("SESSION_USER", (byte)7);
            sqlKeywords.add("SIGN", (byte)7);
            sqlKeywords.add("SIN", (byte)7);
            sqlKeywords.add("SOUNDEX", (byte)7);
            sqlKeywords.add("SPACE", (byte)7);
            sqlKeywords.add("SQRT", (byte)7);
            sqlKeywords.add("SQUARE", (byte)7);
            sqlKeywords.add("STATS_DATE", (byte)7);
            sqlKeywords.add("STR", (byte)7);
            sqlKeywords.add("STUFF", (byte)7);
            sqlKeywords.add("SUBSTRING", (byte)7);
            sqlKeywords.add("SUSER_ID", (byte)7);
            sqlKeywords.add("SUSER_NAME", (byte)7);
            sqlKeywords.add("SUSER_SID", (byte)7);
            sqlKeywords.add("SUSER_SNAME", (byte)7);
            sqlKeywords.add("SYSTEM_USER", (byte)7);
            sqlKeywords.add("TAN", (byte)7);
            sqlKeywords.add("TEXTPTR", (byte)7);
            sqlKeywords.add("TEXTVALID", (byte)7);
            sqlKeywords.add("TYPEPROPERTY", (byte)7);
            sqlKeywords.add("UNICODE", (byte)7);
            sqlKeywords.add("UPPER", (byte)7);
            sqlKeywords.add("USER_ID", (byte)7);
            sqlKeywords.add("USER_NAME", (byte)7);
            sqlKeywords.add("USER", (byte)7);
            sqlKeywords.add("YEAR", (byte)7);
            sqlKeywords.add("ALL", (byte)6);
            sqlKeywords.add("AND", (byte)6);
            sqlKeywords.add("ANY", (byte)6);
            sqlKeywords.add("BETWEEN", (byte)6);
            sqlKeywords.add("CROSS", (byte)6);
            sqlKeywords.add("EXISTS", (byte)6);
            sqlKeywords.add("IN", (byte)6);
            sqlKeywords.add("INTERSECT", (byte)6);
            sqlKeywords.add("JOIN", (byte)6);
            sqlKeywords.add("LIKE", (byte)6);
            sqlKeywords.add("NOT", (byte)6);
            sqlKeywords.add("NULL", (byte)6);
            sqlKeywords.add("OR", (byte)6);
            sqlKeywords.add("OUTER", (byte)6);
            sqlKeywords.add("SOME", (byte)6);
            sqlKeywords.add("sp_add_agent_parameter", (byte)8);
            sqlKeywords.add("sp_add_agent_profile", (byte)8);
            sqlKeywords.add("sp_add_alert", (byte)8);
            sqlKeywords.add("sp_add_category", (byte)8);
            sqlKeywords.add("sp_add_data_file_recover_suspect_db", (byte)8);
            sqlKeywords.add("sp_add_job", (byte)8);
            sqlKeywords.add("sp_add_jobschedule", (byte)8);
            sqlKeywords.add("sp_add_jobserver", (byte)8);
            sqlKeywords.add("sp_add_jobstep", (byte)8);
            sqlKeywords.add("sp_add_log_file_recover_suspect_db", (byte)8);
            sqlKeywords.add("sp_add_notification", (byte)8);
            sqlKeywords.add("sp_add_operator", (byte)8);
            sqlKeywords.add("sp_add_targetservergroup", (byte)8);
            sqlKeywords.add("sp_add_targetsvrgrp_member", (byte)8);
            sqlKeywords.add("sp_addalias", (byte)8);
            sqlKeywords.add("sp_addapprole", (byte)8);
            sqlKeywords.add("sp_addarticle", (byte)8);
            sqlKeywords.add("sp_adddistpublisher", (byte)8);
            sqlKeywords.add("sp_adddistributiondb", (byte)8);
            sqlKeywords.add("sp_adddistributor", (byte)8);
            sqlKeywords.add("sp_addextendedproc", (byte)8);
            sqlKeywords.add("sp_addgroup", (byte)8);
            sqlKeywords.add("sp_addlinkedserver", (byte)8);
            sqlKeywords.add("sp_addlinkedsrvlogin", (byte)8);
            sqlKeywords.add("sp_addlinkedsrvlogin", (byte)8);
            sqlKeywords.add("sp_addlogin", (byte)8);
            sqlKeywords.add("sp_addmergearticle", (byte)8);
            sqlKeywords.add("sp_addmergefilter", (byte)8);
            sqlKeywords.add("sp_addmergepublication", (byte)8);
            sqlKeywords.add("sp_addmergepullsubscription", (byte)8);
            sqlKeywords.add("sp_addmergepullsubscription_agent", (byte)8);
            sqlKeywords.add("sp_addmergesubscription", (byte)8);
            sqlKeywords.add("sp_addmessage", (byte)8);
            sqlKeywords.add("sp_addpublication", (byte)8);
            sqlKeywords.add("sp_addpublication_snapshot", (byte)8);
            sqlKeywords.add("sp_addpublisher70", (byte)8);
            sqlKeywords.add("sp_addpullsubscription", (byte)8);
            sqlKeywords.add("sp_addpullsubscription_agent", (byte)8);
            sqlKeywords.add("sp_addremotelogin", (byte)8);
            sqlKeywords.add("sp_addrole", (byte)8);
            sqlKeywords.add("sp_addrolemember", (byte)8);
            sqlKeywords.add("sp_addserver", (byte)8);
            sqlKeywords.add("sp_addsrvrolemember", (byte)8);
            sqlKeywords.add("sp_addsubscriber", (byte)8);
            sqlKeywords.add("sp_addsubscriber_schedule", (byte)8);
            sqlKeywords.add("sp_addsubscription", (byte)8);
            sqlKeywords.add("sp_addsynctriggers", (byte)8);
            sqlKeywords.add("sp_addtabletocontents", (byte)8);
            sqlKeywords.add("sp_addtask", (byte)8);
            sqlKeywords.add("sp_addtype", (byte)8);
            sqlKeywords.add("sp_addumpdevice", (byte)8);
            sqlKeywords.add("sp_adduser", (byte)8);
            sqlKeywords.add("sp_altermessage", (byte)8);
            sqlKeywords.add("sp_apply_job_to_targets", (byte)8);
            sqlKeywords.add("sp_approlepassword", (byte)8);
            sqlKeywords.add("sp_article_validation", (byte)8);
            sqlKeywords.add("sp_articlecolumn", (byte)8);
            sqlKeywords.add("sp_articlefilter", (byte)8);
            sqlKeywords.add("sp_articlesynctranprocs", (byte)8);
            sqlKeywords.add("sp_articleview", (byte)8);
            sqlKeywords.add("sp_attach_db", (byte)8);
            sqlKeywords.add("sp_attach_single_file_db", (byte)8);
            sqlKeywords.add("sp_autostats", (byte)8);
            sqlKeywords.add("sp_bindefault", (byte)8);
            sqlKeywords.add("sp_bindrule", (byte)8);
            sqlKeywords.add("sp_bindsession", (byte)8);
            sqlKeywords.add("sp_browsereplcmds", (byte)8);
            sqlKeywords.add("sp_catalogs", (byte)8);
            sqlKeywords.add("sp_certify_removable", (byte)8);
            sqlKeywords.add("sp_change_agent_parameter", (byte)8);
            sqlKeywords.add("sp_change_agent_profile", (byte)8);
            sqlKeywords.add("sp_change_subscription_properties", (byte)8);
            sqlKeywords.add("sp_change_users_login", (byte)8);
            sqlKeywords.add("sp_changearticle", (byte)8);
            sqlKeywords.add("sp_changedbowner", (byte)8);
            sqlKeywords.add("sp_changedistpublisher", (byte)8);
            sqlKeywords.add("sp_changedistributiondb", (byte)8);
            sqlKeywords.add("sp_changedistributor_password", (byte)8);
            sqlKeywords.add("sp_changedistributor_property", (byte)8);
            sqlKeywords.add("sp_changegroup", (byte)8);
            sqlKeywords.add("sp_changemergearticle", (byte)8);
            sqlKeywords.add("sp_changemergefilter", (byte)8);
            sqlKeywords.add("sp_changemergepublication", (byte)8);
            sqlKeywords.add("sp_changemergepullsubscription", (byte)8);
            sqlKeywords.add("sp_changemergesubscription", (byte)8);
            sqlKeywords.add("sp_changeobjectowner", (byte)8);
            sqlKeywords.add("sp_changepublication", (byte)8);
            sqlKeywords.add("sp_changesubscriber", (byte)8);
            sqlKeywords.add("sp_changesubscriber_schedule", (byte)8);
            sqlKeywords.add("sp_changesubstatus", (byte)8);
            sqlKeywords.add("sp_check_for_sync_trigger", (byte)8);
            sqlKeywords.add("sp_column_privileges", (byte)8);
            sqlKeywords.add("sp_column_privileges_ex", (byte)8);
            sqlKeywords.add("sp_columns", (byte)8);
            sqlKeywords.add("sp_columns_ex", (byte)8);
            sqlKeywords.add("sp_configure", (byte)8);
            sqlKeywords.add("sp_create_removable", (byte)8);
            sqlKeywords.add("sp_createorphan", (byte)8);
            sqlKeywords.add("sp_createstats", (byte)8);
            sqlKeywords.add("sp_cursor", (byte)8);
            sqlKeywords.add("sp_cursor_list", (byte)8);
            sqlKeywords.add("sp_cursorclose", (byte)8);
            sqlKeywords.add("sp_cursorexecute", (byte)8);
            sqlKeywords.add("sp_cursorfetch", (byte)8);
            sqlKeywords.add("sp_cursoropen", (byte)8);
            sqlKeywords.add("sp_cursoroption", (byte)8);
            sqlKeywords.add("sp_cursorprepare", (byte)8);
            sqlKeywords.add("sp_cursorunprepare", (byte)8);
            sqlKeywords.add("sp_cycle_errorlog", (byte)8);
            sqlKeywords.add("sp_databases", (byte)8);
            sqlKeywords.add("sp_datatype_info", (byte)8);
            sqlKeywords.add("sp_dbcmptlevel", (byte)8);
            sqlKeywords.add("sp_dbfixedrolepermission", (byte)8);
            sqlKeywords.add("sp_dboption", (byte)8);
            sqlKeywords.add("sp_defaultdb", (byte)8);
            sqlKeywords.add("sp_defaultlanguage", (byte)8);
            sqlKeywords.add("sp_delete_alert", (byte)8);
            sqlKeywords.add("sp_delete_backuphistory", (byte)8);
            sqlKeywords.add("sp_delete_category", (byte)8);
            sqlKeywords.add("sp_delete_job", (byte)8);
            sqlKeywords.add("sp_delete_jobschedule", (byte)8);
            sqlKeywords.add("sp_delete_jobserver", (byte)8);
            sqlKeywords.add("sp_delete_jobstep", (byte)8);
            sqlKeywords.add("sp_delete_notification", (byte)8);
            sqlKeywords.add("sp_delete_operator", (byte)8);
            sqlKeywords.add("sp_delete_targetserver", (byte)8);
            sqlKeywords.add("sp_delete_targetservergroup", (byte)8);
            sqlKeywords.add("sp_delete_targetsvrgrp_member", (byte)8);
            sqlKeywords.add("sp_deletemergeconflictrow", (byte)8);
            sqlKeywords.add("sp_denylogin", (byte)8);
            sqlKeywords.add("sp_depends", (byte)8);
            sqlKeywords.add("sp_describe_cursor", (byte)8);
            sqlKeywords.add("sp_describe_cursor_columns", (byte)8);
            sqlKeywords.add("sp_describe_cursor_tables", (byte)8);
            sqlKeywords.add("sp_detach_db", (byte)8);
            sqlKeywords.add("sp_drop_agent_parameter", (byte)8);
            sqlKeywords.add("sp_drop_agent_profile", (byte)8);
            sqlKeywords.add("sp_dropalias", (byte)8);
            sqlKeywords.add("sp_dropapprole", (byte)8);
            sqlKeywords.add("sp_droparticle", (byte)8);
            sqlKeywords.add("sp_dropdevice", (byte)8);
            sqlKeywords.add("sp_dropdistpublisher", (byte)8);
            sqlKeywords.add("sp_dropdistributiondb", (byte)8);
            sqlKeywords.add("sp_dropdistributor", (byte)8);
            sqlKeywords.add("sp_dropextendedproc", (byte)8);
            sqlKeywords.add("sp_dropgroup", (byte)8);
            sqlKeywords.add("sp_droplinkedsrvlogin", (byte)8);
            sqlKeywords.add("sp_droplinkedsrvlogin", (byte)8);
            sqlKeywords.add("sp_droplogin", (byte)8);
            sqlKeywords.add("sp_dropmergearticle", (byte)8);
            sqlKeywords.add("sp_dropmergefilter", (byte)8);
            sqlKeywords.add("sp_dropmergepublication", (byte)8);
            sqlKeywords.add("sp_dropmergepullsubscription", (byte)8);
            sqlKeywords.add("sp_dropmergesubscription", (byte)8);
            sqlKeywords.add("sp_dropmessage", (byte)8);
            sqlKeywords.add("sp_droporphans", (byte)8);
            sqlKeywords.add("sp_droppublication", (byte)8);
            sqlKeywords.add("sp_droppullsubscription", (byte)8);
            sqlKeywords.add("sp_dropremotelogin", (byte)8);
            sqlKeywords.add("sp_droprole", (byte)8);
            sqlKeywords.add("sp_droprolemember", (byte)8);
            sqlKeywords.add("sp_dropserver", (byte)8);
            sqlKeywords.add("sp_dropsrvrolemember", (byte)8);
            sqlKeywords.add("sp_dropsubscriber", (byte)8);
            sqlKeywords.add("sp_dropsubscription", (byte)8);
            sqlKeywords.add("sp_droptask", (byte)8);
            sqlKeywords.add("sp_droptype", (byte)8);
            sqlKeywords.add("sp_dropuser", (byte)8);
            sqlKeywords.add("sp_dropwebtask", (byte)8);
            sqlKeywords.add("sp_dsninfo", (byte)8);
            sqlKeywords.add("sp_dumpparamcmd", (byte)8);
            sqlKeywords.add("sp_enumcodepages", (byte)8);
            sqlKeywords.add("sp_enumcustomresolvers", (byte)8);
            sqlKeywords.add("sp_enumdsn", (byte)8);
            sqlKeywords.add("sp_enumfullsubscribers", (byte)8);
            sqlKeywords.add("sp_execute", (byte)8);
            sqlKeywords.add("sp_executesql", (byte)8);
            sqlKeywords.add("sp_expired_subscription_cleanup", (byte)8);
            sqlKeywords.add("sp_fkeys", (byte)8);
            sqlKeywords.add("sp_foreignkeys", (byte)8);
            sqlKeywords.add("sp_fulltext_catalog", (byte)8);
            sqlKeywords.add("sp_fulltext_column", (byte)8);
            sqlKeywords.add("sp_fulltext_database", (byte)8);
            sqlKeywords.add("sp_fulltext_service", (byte)8);
            sqlKeywords.add("sp_fulltext_table", (byte)8);
            sqlKeywords.add("sp_generatefilters", (byte)8);
            sqlKeywords.add("sp_get_distributor", (byte)8);
            sqlKeywords.add("sp_getbindtoken", (byte)8);
            sqlKeywords.add("sp_getmergedeletetype", (byte)8);
            sqlKeywords.add("sp_grant_publication_access", (byte)8);
            sqlKeywords.add("sp_grantdbaccess", (byte)8);
            sqlKeywords.add("sp_grantlogin", (byte)8);
            sqlKeywords.add("sp_help", (byte)8);
            sqlKeywords.add("sp_help_agent_default", (byte)8);
            sqlKeywords.add("sp_help_agent_parameter", (byte)8);
            sqlKeywords.add("sp_help_agent_profile", (byte)8);
            sqlKeywords.add("sp_help_alert", (byte)8);
            sqlKeywords.add("sp_help_category", (byte)8);
            sqlKeywords.add("sp_help_downloadlist", (byte)8);
            sqlKeywords.add("sp_help_fulltext_catalogs", (byte)8);
            sqlKeywords.add("sp_help_fulltext_catalogs_cursor", (byte)8);
            sqlKeywords.add("sp_help_fulltext_columns", (byte)8);
            sqlKeywords.add("sp_help_fulltext_columns_cursor", (byte)8);
            sqlKeywords.add("sp_help_fulltext_tables", (byte)8);
            sqlKeywords.add("sp_help_fulltext_tables_cursor", (byte)8);
            sqlKeywords.add("sp_help_job", (byte)8);
            sqlKeywords.add("sp_help_jobhistory", (byte)8);
            sqlKeywords.add("sp_help_jobschedule", (byte)8);
            sqlKeywords.add("sp_help_jobserver", (byte)8);
            sqlKeywords.add("sp_help_jobstep", (byte)8);
            sqlKeywords.add("sp_help_notification", (byte)8);
            sqlKeywords.add("sp_help_operator", (byte)8);
            sqlKeywords.add("sp_help_publication_access", (byte)8);
            sqlKeywords.add("sp_help_targetserver", (byte)8);
            sqlKeywords.add("sp_help_targetservergroup", (byte)8);
            sqlKeywords.add("sp_helparticle", (byte)8);
            sqlKeywords.add("sp_helparticlecolumns", (byte)8);
            sqlKeywords.add("sp_helpconstraint", (byte)8);
            sqlKeywords.add("sp_helpdb", (byte)8);
            sqlKeywords.add("sp_helpdbfixedrole", (byte)8);
            sqlKeywords.add("sp_helpdevice", (byte)8);
            sqlKeywords.add("sp_helpdistpublisher", (byte)8);
            sqlKeywords.add("sp_helpdistributiondb", (byte)8);
            sqlKeywords.add("sp_helpdistributor", (byte)8);
            sqlKeywords.add("sp_helpextendedproc", (byte)8);
            sqlKeywords.add("sp_helpfile", (byte)8);
            sqlKeywords.add("sp_helpfilegroup", (byte)8);
            sqlKeywords.add("sp_helpgroup", (byte)8);
            sqlKeywords.add("sp_helphistory", (byte)8);
            sqlKeywords.add("sp_helpindex", (byte)8);
            sqlKeywords.add("sp_helplanguage", (byte)8);
            sqlKeywords.add("sp_helplinkedsrvlogin", (byte)8);
            sqlKeywords.add("sp_helplogins", (byte)8);
            sqlKeywords.add("sp_helpmergearticle", (byte)8);
            sqlKeywords.add("sp_helpmergearticleconflicts", (byte)8);
            sqlKeywords.add("sp_helpmergeconflictrows", (byte)8);
            sqlKeywords.add("sp_helpmergedeleteconflictrows", (byte)8);
            sqlKeywords.add("sp_helpmergefilter", (byte)8);
            sqlKeywords.add("sp_helpmergepublication", (byte)8);
            sqlKeywords.add("sp_helpmergepullsubscription", (byte)8);
            sqlKeywords.add("sp_helpmergesubscription", (byte)8);
            sqlKeywords.add("sp_helpntgroup", (byte)8);
            sqlKeywords.add("sp_helppublication", (byte)8);
            sqlKeywords.add("sp_helppullsubscription", (byte)8);
            sqlKeywords.add("sp_helpremotelogin", (byte)8);
            sqlKeywords.add("sp_helpreplicationdboption", (byte)8);
            sqlKeywords.add("sp_helprole", (byte)8);
            sqlKeywords.add("sp_helprolemember", (byte)8);
            sqlKeywords.add("sp_helprotect", (byte)8);
            sqlKeywords.add("sp_helpserver", (byte)8);
            sqlKeywords.add("sp_helpsort", (byte)8);
            sqlKeywords.add("sp_helpsrvrole", (byte)8);
            sqlKeywords.add("sp_helpsrvrolemember", (byte)8);
            sqlKeywords.add("sp_helpsubscriberinfo", (byte)8);
            sqlKeywords.add("sp_helpsubscription", (byte)8);
            sqlKeywords.add("sp_helpsubscription_properties", (byte)8);
            sqlKeywords.add("sp_helptask", (byte)8);
            sqlKeywords.add("sp_helptext", (byte)8);
            sqlKeywords.add("sp_helptrigger", (byte)8);
            sqlKeywords.add("sp_helpuser", (byte)8);
            sqlKeywords.add("sp_indexes", (byte)8);
            sqlKeywords.add("sp_indexoption", (byte)8);
            sqlKeywords.add("sp_link_publication", (byte)8);
            sqlKeywords.add("sp_linkedservers", (byte)8);
            sqlKeywords.add("sp_lock", (byte)8);
            sqlKeywords.add("sp_makewebtask", (byte)8);
            sqlKeywords.add("sp_manage_jobs_by_login", (byte)8);
            sqlKeywords.add("sp_mergedummyupdate", (byte)8);
            sqlKeywords.add("sp_mergesubscription_cleanup", (byte)8);
            sqlKeywords.add("sp_monitor", (byte)8);
            sqlKeywords.add("sp_msx_defect", (byte)8);
            sqlKeywords.add("sp_msx_enlist", (byte)8);
            sqlKeywords.add("sp_OACreate", (byte)8);
            sqlKeywords.add("sp_OADestroy", (byte)8);
            sqlKeywords.add("sp_OAGetErrorInfo", (byte)8);
            sqlKeywords.add("sp_OAGetProperty", (byte)8);
            sqlKeywords.add("sp_OAMethod", (byte)8);
            sqlKeywords.add("sp_OASetProperty", (byte)8);
            sqlKeywords.add("sp_OAStop", (byte)8);
            sqlKeywords.add("sp_password", (byte)8);
            sqlKeywords.add("sp_pkeys", (byte)8);
            sqlKeywords.add("sp_post_msx_operation", (byte)8);
            sqlKeywords.add("sp_prepare", (byte)8);
            sqlKeywords.add("sp_primarykeys", (byte)8);
            sqlKeywords.add("sp_processmail", (byte)8);
            sqlKeywords.add("sp_procoption", (byte)8);
            sqlKeywords.add("sp_publication_validation", (byte)8);
            sqlKeywords.add("sp_purge_jobhistory", (byte)8);
            sqlKeywords.add("sp_purgehistory", (byte)8);
            sqlKeywords.add("sp_reassigntask", (byte)8);
            sqlKeywords.add("sp_recompile", (byte)8);
            sqlKeywords.add("sp_refreshsubscriptions", (byte)8);
            sqlKeywords.add("sp_refreshview", (byte)8);
            sqlKeywords.add("sp_reinitmergepullsubscription", (byte)8);
            sqlKeywords.add("sp_reinitmergesubscription", (byte)8);
            sqlKeywords.add("sp_reinitpullsubscription", (byte)8);
            sqlKeywords.add("sp_reinitsubscription", (byte)8);
            sqlKeywords.add("sp_remoteoption", (byte)8);
            sqlKeywords.add("sp_remove_job_from_targets", (byte)8);
            sqlKeywords.add("sp_removedbreplication", (byte)8);
            sqlKeywords.add("sp_rename", (byte)8);
            sqlKeywords.add("sp_renamedb", (byte)8);
            sqlKeywords.add("sp_replcmds", (byte)8);
            sqlKeywords.add("sp_replcounters", (byte)8);
            sqlKeywords.add("sp_repldone", (byte)8);
            sqlKeywords.add("sp_replflush", (byte)8);
            sqlKeywords.add("sp_replication_agent_checkup", (byte)8);
            sqlKeywords.add("sp_replicationdboption", (byte)8);
            sqlKeywords.add("sp_replsetoriginator", (byte)8);
            sqlKeywords.add("sp_replshowcmds", (byte)8);
            sqlKeywords.add("sp_repltrans", (byte)8);
            sqlKeywords.add("sp_reset_connection", (byte)8);
            sqlKeywords.add("sp_resync_targetserver", (byte)8);
            sqlKeywords.add("sp_revoke_publication_access", (byte)8);
            sqlKeywords.add("sp_revokedbaccess", (byte)8);
            sqlKeywords.add("sp_revokelogin", (byte)8);
            sqlKeywords.add("sp_runwebtask", (byte)8);
            sqlKeywords.add("sp_script_synctran_commands", (byte)8);
            sqlKeywords.add("sp_scriptdelproc", (byte)8);
            sqlKeywords.add("sp_scriptinsproc", (byte)8);
            sqlKeywords.add("sp_scriptmappedupdproc", (byte)8);
            sqlKeywords.add("sp_scriptupdproc", (byte)8);
            sqlKeywords.add("sp_sdidebug", (byte)8);
            sqlKeywords.add("sp_server_info", (byte)8);
            sqlKeywords.add("sp_serveroption", (byte)8);
            sqlKeywords.add("sp_serveroption", (byte)8);
            sqlKeywords.add("sp_setapprole", (byte)8);
            sqlKeywords.add("sp_setnetname", (byte)8);
            sqlKeywords.add("sp_spaceused", (byte)8);
            sqlKeywords.add("sp_special_columns", (byte)8);
            sqlKeywords.add("sp_sproc_columns", (byte)8);
            sqlKeywords.add("sp_srvrolepermission", (byte)8);
            sqlKeywords.add("sp_start_job", (byte)8);
            sqlKeywords.add("sp_statistics", (byte)8);
            sqlKeywords.add("sp_stop_job", (byte)8);
            sqlKeywords.add("sp_stored_procedures", (byte)8);
            sqlKeywords.add("sp_subscription_cleanup", (byte)8);
            sqlKeywords.add("sp_table_privileges", (byte)8);
            sqlKeywords.add("sp_table_privileges_ex", (byte)8);
            sqlKeywords.add("sp_table_validation", (byte)8);
            sqlKeywords.add("sp_tableoption", (byte)8);
            sqlKeywords.add("sp_tables", (byte)8);
            sqlKeywords.add("sp_tables_ex", (byte)8);
            sqlKeywords.add("sp_unbindefault", (byte)8);
            sqlKeywords.add("sp_unbindrule", (byte)8);
            sqlKeywords.add("sp_unprepare", (byte)8);
            sqlKeywords.add("sp_update_agent_profile", (byte)8);
            sqlKeywords.add("sp_update_alert", (byte)8);
            sqlKeywords.add("sp_update_category", (byte)8);
            sqlKeywords.add("sp_update_job", (byte)8);
            sqlKeywords.add("sp_update_jobschedule", (byte)8);
            sqlKeywords.add("sp_update_jobstep", (byte)8);
            sqlKeywords.add("sp_update_notification", (byte)8);
            sqlKeywords.add("sp_update_operator", (byte)8);
            sqlKeywords.add("sp_update_targetservergroup", (byte)8);
            sqlKeywords.add("sp_updatestats", (byte)8);
            sqlKeywords.add("sp_updatetask", (byte)8);
            sqlKeywords.add("sp_validatelogins", (byte)8);
            sqlKeywords.add("sp_validname", (byte)8);
            sqlKeywords.add("sp_who", (byte)8);
            sqlKeywords.add("xp_cmdshell", (byte)8);
            sqlKeywords.add("xp_deletemail", (byte)8);
            sqlKeywords.add("xp_enumgroups", (byte)8);
            sqlKeywords.add("xp_findnextmsg", (byte)8);
            sqlKeywords.add("xp_findnextmsg", (byte)8);
            sqlKeywords.add("xp_grantlogin", (byte)8);
            sqlKeywords.add("xp_logevent", (byte)8);
            sqlKeywords.add("xp_loginconfig", (byte)8);
            sqlKeywords.add("xp_logininfo", (byte)8);
            sqlKeywords.add("xp_msver", (byte)8);
            sqlKeywords.add("xp_readmail", (byte)8);
            sqlKeywords.add("xp_revokelogin", (byte)8);
            sqlKeywords.add("xp_sendmail", (byte)8);
            sqlKeywords.add("xp_sprintf", (byte)8);
            sqlKeywords.add("xp_sqlinventory", (byte)8);
            sqlKeywords.add("xp_sqlmaint", (byte)8);
            sqlKeywords.add("xp_sqltrace", (byte)8);
            sqlKeywords.add("xp_sscanf", (byte)8);
            sqlKeywords.add("xp_startmail", (byte)8);
            sqlKeywords.add("xp_stopmail", (byte)8);
            sqlKeywords.add("xp_trace_addnewqueue", (byte)8);
            sqlKeywords.add("xp_trace_deletequeuedefinition", (byte)8);
            sqlKeywords.add("xp_trace_destroyqueue", (byte)8);
            sqlKeywords.add("xp_trace_enumqueuedefname", (byte)8);
            sqlKeywords.add("xp_trace_enumqueuehandles", (byte)8);
            sqlKeywords.add("xp_trace_eventclassrequired", (byte)8);
            sqlKeywords.add("xp_trace_flushqueryhistory", (byte)8);
            sqlKeywords.add("xp_trace_generate_event", (byte)8);
            sqlKeywords.add("xp_trace_getappfilter", (byte)8);
            sqlKeywords.add("xp_trace_getconnectionidfilter", (byte)8);
            sqlKeywords.add("xp_trace_getcpufilter", (byte)8);
            sqlKeywords.add("xp_trace_getdbidfilter", (byte)8);
            sqlKeywords.add("xp_trace_getdurationfilter", (byte)8);
            sqlKeywords.add("xp_trace_geteventfilter", (byte)8);
            sqlKeywords.add("xp_trace_geteventnames", (byte)8);
            sqlKeywords.add("xp_trace_getevents", (byte)8);
            sqlKeywords.add("xp_trace_gethostfilter", (byte)8);
            sqlKeywords.add("xp_trace_gethpidfilter", (byte)8);
            sqlKeywords.add("xp_trace_getindidfilter", (byte)8);
            sqlKeywords.add("xp_trace_getntdmfilter", (byte)8);
            sqlKeywords.add("xp_trace_getntnmfilter", (byte)8);
            sqlKeywords.add("xp_trace_getobjidfilter", (byte)8);
            sqlKeywords.add("xp_trace_getqueueautostart", (byte)8);
            sqlKeywords.add("xp_trace_getqueuedestination", (byte)8);
            sqlKeywords.add("xp_trace_getqueueproperties", (byte)8);
            sqlKeywords.add("xp_trace_getreadfilter", (byte)8);
            sqlKeywords.add("xp_trace_getserverfilter", (byte)8);
            sqlKeywords.add("xp_trace_getseverityfilter", (byte)8);
            sqlKeywords.add("xp_trace_getspidfilter", (byte)8);
            sqlKeywords.add("xp_trace_getsysobjectsfilter", (byte)8);
            sqlKeywords.add("xp_trace_gettextfilter", (byte)8);
            sqlKeywords.add("xp_trace_getuserfilter", (byte)8);
            sqlKeywords.add("xp_trace_getwritefilter", (byte)8);
            sqlKeywords.add("xp_trace_loadqueuedefinition", (byte)8);
            sqlKeywords.add("xp_trace_pausequeue", (byte)8);
            sqlKeywords.add("xp_trace_restartqueue", (byte)8);
            sqlKeywords.add("xp_trace_savequeuedefinition", (byte)8);
            sqlKeywords.add("xp_trace_setappfilter", (byte)8);
            sqlKeywords.add("xp_trace_setconnectionidfilter", (byte)8);
            sqlKeywords.add("xp_trace_setcpufilter", (byte)8);
            sqlKeywords.add("xp_trace_setdbidfilter", (byte)8);
            sqlKeywords.add("xp_trace_setdurationfilter", (byte)8);
            sqlKeywords.add("xp_trace_seteventclassrequired", (byte)8);
            sqlKeywords.add("xp_trace_seteventfilter", (byte)8);
            sqlKeywords.add("xp_trace_sethostfilter", (byte)8);
            sqlKeywords.add("xp_trace_sethpidfilter", (byte)8);
            sqlKeywords.add("xp_trace_setindidfilter", (byte)8);
            sqlKeywords.add("xp_trace_setntdmfilter", (byte)8);
            sqlKeywords.add("xp_trace_setntnmfilter", (byte)8);
            sqlKeywords.add("xp_trace_setobjidfilter", (byte)8);
            sqlKeywords.add("xp_trace_setqueryhistory", (byte)8);
            sqlKeywords.add("xp_trace_setqueueautostart", (byte)8);
            sqlKeywords.add("xp_trace_setqueuecreateinfo", (byte)8);
            sqlKeywords.add("xp_trace_setqueuedestination", (byte)8);
            sqlKeywords.add("xp_trace_setreadfilter", (byte)8);
            sqlKeywords.add("xp_trace_setserverfilter", (byte)8);
            sqlKeywords.add("xp_trace_setseverityfilter", (byte)8);
            sqlKeywords.add("xp_trace_setspidfilter", (byte)8);
            sqlKeywords.add("xp_trace_setsysobjectsfilter", (byte)8);
            sqlKeywords.add("xp_trace_settextfilter", (byte)8);
            sqlKeywords.add("xp_trace_setuserfilter", (byte)8);
            sqlKeywords.add("xp_trace_setwritefilter", (byte)8);
            sqlKeywords.add("backupfile", (byte)8);
            sqlKeywords.add("backupmediafamily", (byte)8);
            sqlKeywords.add("backupmediaset", (byte)8);
            sqlKeywords.add("backupset", (byte)8);
            sqlKeywords.add("MSagent_parameters", (byte)8);
            sqlKeywords.add("MSagent_profiles", (byte)8);
            sqlKeywords.add("MSarticles", (byte)8);
            sqlKeywords.add("MSdistpublishers", (byte)8);
            sqlKeywords.add("MSdistribution_agents", (byte)8);
            sqlKeywords.add("MSdistribution_history", (byte)8);
            sqlKeywords.add("MSdistributiondbs", (byte)8);
            sqlKeywords.add("MSdistributor", (byte)8);
            sqlKeywords.add("MSlogreader_agents", (byte)8);
            sqlKeywords.add("MSlogreader_history", (byte)8);
            sqlKeywords.add("MSmerge_agents", (byte)8);
            sqlKeywords.add("MSmerge_contents", (byte)8);
            sqlKeywords.add("MSmerge_delete_conflicts", (byte)8);
            sqlKeywords.add("MSmerge_genhistory", (byte)8);
            sqlKeywords.add("MSmerge_history", (byte)8);
            sqlKeywords.add("MSmerge_replinfo", (byte)8);
            sqlKeywords.add("MSmerge_subscriptions", (byte)8);
            sqlKeywords.add("MSmerge_tombstone", (byte)8);
            sqlKeywords.add("MSpublication_access", (byte)8);
            sqlKeywords.add("Mspublications", (byte)8);
            sqlKeywords.add("Mspublisher_databases", (byte)8);
            sqlKeywords.add("MSrepl_commands", (byte)8);
            sqlKeywords.add("MSrepl_errors", (byte)8);
            sqlKeywords.add("Msrepl_originators", (byte)8);
            sqlKeywords.add("MSrepl_transactions", (byte)8);
            sqlKeywords.add("MSrepl_version", (byte)8);
            sqlKeywords.add("MSreplication_objects", (byte)8);
            sqlKeywords.add("MSreplication_subscriptions", (byte)8);
            sqlKeywords.add("MSsnapshot_agents", (byte)8);
            sqlKeywords.add("MSsnapshot_history", (byte)8);
            sqlKeywords.add("MSsubscriber_info", (byte)8);
            sqlKeywords.add("MSsubscriber_schedule", (byte)8);
            sqlKeywords.add("MSsubscription_properties", (byte)8);
            sqlKeywords.add("MSsubscriptions", (byte)8);
            sqlKeywords.add("restorefile", (byte)8);
            sqlKeywords.add("restorefilegroup", (byte)8);
            sqlKeywords.add("restorehistory", (byte)8);
            sqlKeywords.add("sysalerts", (byte)8);
            sqlKeywords.add("sysallocations", (byte)8);
            sqlKeywords.add("sysaltfiles", (byte)8);
            sqlKeywords.add("sysarticles", (byte)8);
            sqlKeywords.add("sysarticleupdates", (byte)8);
            sqlKeywords.add("syscacheobjects", (byte)8);
            sqlKeywords.add("syscategories", (byte)8);
            sqlKeywords.add("syscharsets", (byte)8);
            sqlKeywords.add("syscolumns", (byte)8);
            sqlKeywords.add("syscomments", (byte)8);
            sqlKeywords.add("sysconfigures", (byte)8);
            sqlKeywords.add("sysconstraints", (byte)8);
            sqlKeywords.add("syscurconfigs", (byte)8);
            sqlKeywords.add("sysdatabases", (byte)8);
            sqlKeywords.add("sysdatabases", (byte)8);
            sqlKeywords.add("sysdepends", (byte)8);
            sqlKeywords.add("sysdevices", (byte)8);
            sqlKeywords.add("sysdownloadlist", (byte)8);
            sqlKeywords.add("sysfilegroups", (byte)8);
            sqlKeywords.add("sysfiles", (byte)8);
            sqlKeywords.add("sysforeignkeys", (byte)8);
            sqlKeywords.add("sysfulltextcatalogs", (byte)8);
            sqlKeywords.add("sysindexes", (byte)8);
            sqlKeywords.add("sysindexkeys", (byte)8);
            sqlKeywords.add("sysjobhistory", (byte)8);
            sqlKeywords.add("sysjobs", (byte)8);
            sqlKeywords.add("sysjobschedules", (byte)8);
            sqlKeywords.add("sysjobservers", (byte)8);
            sqlKeywords.add("sysjobsteps", (byte)8);
            sqlKeywords.add("syslanguages", (byte)8);
            sqlKeywords.add("syslockinfo", (byte)8);
            sqlKeywords.add("syslogins", (byte)8);
            sqlKeywords.add("sysmembers", (byte)8);
            sqlKeywords.add("sysmergearticles", (byte)8);
            sqlKeywords.add("sysmergepublications", (byte)8);
            sqlKeywords.add("sysmergeschemachange", (byte)8);
            sqlKeywords.add("sysmergesubscriptions", (byte)8);
            sqlKeywords.add("sysmergesubsetfilters", (byte)8);
            sqlKeywords.add("sysmessages", (byte)8);
            sqlKeywords.add("sysnotifications", (byte)8);
            sqlKeywords.add("sysobjects", (byte)8);
            sqlKeywords.add("sysobjects", (byte)8);
            sqlKeywords.add("sysoledbusers", (byte)8);
            sqlKeywords.add("sysoperators", (byte)8);
            sqlKeywords.add("sysperfinfo", (byte)8);
            sqlKeywords.add("syspermissions", (byte)8);
            sqlKeywords.add("sysprocesses", (byte)8);
            sqlKeywords.add("sysprotects", (byte)8);
            sqlKeywords.add("syspublications", (byte)8);
            sqlKeywords.add("sysreferences", (byte)8);
            sqlKeywords.add("sysremotelogins", (byte)8);
            sqlKeywords.add("sysreplicationalerts", (byte)8);
            sqlKeywords.add("sysservers", (byte)8);
            sqlKeywords.add("sysservers", (byte)8);
            sqlKeywords.add("syssubscriptions", (byte)8);
            sqlKeywords.add("systargetservergroupmembers", (byte)8);
            sqlKeywords.add("systargetservergroups", (byte)8);
            sqlKeywords.add("systargetservers", (byte)8);
            sqlKeywords.add("systaskids", (byte)8);
            sqlKeywords.add("systypes", (byte)8);
            sqlKeywords.add("sysusers", (byte)8);
        }
        return sqlKeywords;
    }

    private boolean doKeyword(Segment line, int i, char c) {
        int i1 = i + 1;
        int len = i - this.lastKeyword;
        byte id = this.keywords.lookup(line, this.lastKeyword, len);
        if (id != 0) {
            if (this.lastKeyword != this.lastOffset) {
                this.addToken(this.lastKeyword - this.lastOffset, (byte)0);
            }
            this.addToken(len, id);
            this.lastOffset = i;
        }
        this.lastKeyword = i1;
        return false;
    }
}

