/*
 * Decompiled with CFR 0.152.
 */
package jehep.syntax;

import javax.swing.text.Segment;
import jehep.syntax.KeywordMap;
import jehep.syntax.TokenMarker;

public class SQRTokenMarker
extends TokenMarker {
    boolean bracket = false;
    private static KeywordMap sqrKeywords;
    private KeywordMap keywords = SQRTokenMarker.getKeywords();
    private int lastOffset;
    private int lastKeyword;

    @Override
    public byte markTokensImpl(byte token, Segment line, int lineIndex) {
        int offset;
        char[] array = line.array;
        this.lastOffset = offset = line.offset;
        this.lastKeyword = offset;
        int length = line.count + offset;
        block18: for (int i = offset; i < length; ++i) {
            int i1 = i + 1;
            char c = array[i];
            switch (token) {
                case 0: {
                    switch (c) {
                        case '[': {
                            this.bracket = true;
                        }
                        case '\"': {
                            this.doKeyword(line, i, c);
                            this.addToken(i - this.lastOffset, token);
                            token = (byte)3;
                            this.lastOffset = this.lastKeyword = i;
                            break;
                        }
                        case '\'': {
                            this.doKeyword(line, i, c);
                            this.addToken(i - this.lastOffset, token);
                            token = (byte)4;
                            this.lastOffset = this.lastKeyword = i;
                            break;
                        }
                        case ':': {
                            if (this.lastKeyword == offset) {
                                if (this.doKeyword(line, i, c)) break;
                                this.addToken(i1 - this.lastOffset, (byte)5);
                                this.lastOffset = this.lastKeyword = i1;
                                break;
                            }
                            if (!this.doKeyword(line, i, c)) continue block18;
                            break;
                        }
                        case '!': {
                            this.doKeyword(line, i, c);
                            if (length - i <= 1) continue block18;
                            this.addToken(i - this.lastOffset, token);
                            this.addToken(length - i, (byte)1);
                            this.lastOffset = length;
                            break block18;
                        }
                        default: {
                            if (Character.isLetterOrDigit(c) || c == '-' || c == '#') continue block18;
                            this.doKeyword(line, i, c);
                            break;
                        }
                    }
                    continue block18;
                }
                case 1: {
                    continue block18;
                }
                case 2: {
                    if (c != '*' || length - i <= 1 || array[i1] != '/') continue block18;
                    this.addToken(++i + 1 - this.lastOffset, token);
                    token = 0;
                    this.lastOffset = this.lastKeyword = i + 1;
                    continue block18;
                }
                case 3: {
                    if (c != '\"' && c != ']') continue block18;
                    this.addToken(i1 - this.lastOffset, token);
                    token = 0;
                    this.lastOffset = this.lastKeyword = i1;
                    this.bracket = false;
                    continue block18;
                }
                case 4: {
                    if (c != '\'') continue block18;
                    this.addToken(i1 - this.lastOffset, (byte)3);
                    token = 0;
                    this.lastOffset = this.lastKeyword = i1;
                    continue block18;
                }
                default: {
                    throw new InternalError("Invalid state: " + token);
                }
            }
        }
        if (token == 0) {
            this.doKeyword(line, length, '\u0000');
        }
        switch (token) {
            case 3: 
            case 4: {
                this.addToken(length - this.lastOffset, this.bracket ? (byte)3 : 10);
                token = (byte)(this.bracket ? 3 : 0);
                break;
            }
            case 7: {
                this.addToken(length - this.lastOffset, token);
                token = 0;
                break;
            }
            default: {
                this.addToken(length - this.lastOffset, token);
            }
        }
        return token;
    }

    public static KeywordMap getKeywords() {
        if (sqrKeywords == null) {
            sqrKeywords = new KeywordMap(true);
            sqrKeywords.add("BEGIN-FOOTING", (byte)6);
            sqrKeywords.add("BEGIN-HEADING", (byte)6);
            sqrKeywords.add("BEGIN-PROCEDURE", (byte)6);
            sqrKeywords.add("BEGIN-PROGRAM", (byte)6);
            sqrKeywords.add("BEGIN-REPORT", (byte)6);
            sqrKeywords.add("BEGIN-SELECT", (byte)6);
            sqrKeywords.add("BEGIN-SETUP", (byte)6);
            sqrKeywords.add("END-FOOTING", (byte)6);
            sqrKeywords.add("END-HEADING", (byte)6);
            sqrKeywords.add("END-PROCEDURE", (byte)6);
            sqrKeywords.add("END-PROGRAM", (byte)6);
            sqrKeywords.add("END-REPORT", (byte)6);
            sqrKeywords.add("END-SETUP", (byte)6);
            sqrKeywords.add("END-SELECT", (byte)6);
            sqrKeywords.add("INPUT", (byte)6);
            sqrKeywords.add("#include", (byte)7);
            sqrKeywords.add("#debug", (byte)7);
            sqrKeywords.add("#define", (byte)7);
            sqrKeywords.add("#else", (byte)7);
            sqrKeywords.add("#end-if", (byte)7);
            sqrKeywords.add("#endif", (byte)7);
            sqrKeywords.add("#if", (byte)7);
            sqrKeywords.add("#ifdef", (byte)7);
            sqrKeywords.add("#ifndef", (byte)7);
            sqrKeywords.add("add", (byte)8);
            sqrKeywords.add("array-add", (byte)8);
            sqrKeywords.add("array-divide", (byte)8);
            sqrKeywords.add("array-multiply", (byte)8);
            sqrKeywords.add("array-subtract", (byte)8);
            sqrKeywords.add("ask", (byte)8);
            sqrKeywords.add("break", (byte)8);
            sqrKeywords.add("call", (byte)8);
            sqrKeywords.add("clear-array", (byte)8);
            sqrKeywords.add("close", (byte)8);
            sqrKeywords.add("columns", (byte)8);
            sqrKeywords.add("commit", (byte)8);
            sqrKeywords.add("concat", (byte)8);
            sqrKeywords.add("connect", (byte)8);
            sqrKeywords.add("create-array", (byte)8);
            sqrKeywords.add("date-time", (byte)8);
            sqrKeywords.add("display", (byte)8);
            sqrKeywords.add("divide", (byte)8);
            sqrKeywords.add("do", (byte)8);
            sqrKeywords.add("dollar-symbol", (byte)8);
            sqrKeywords.add("else", (byte)8);
            sqrKeywords.add("encode", (byte)8);
            sqrKeywords.add("end-evaluate", (byte)8);
            sqrKeywords.add("end-if", (byte)8);
            sqrKeywords.add("end-while", (byte)8);
            sqrKeywords.add("evaluate", (byte)8);
            sqrKeywords.add("execute", (byte)8);
            sqrKeywords.add("extract", (byte)8);
            sqrKeywords.add("find", (byte)8);
            sqrKeywords.add("font", (byte)8);
            sqrKeywords.add("get", (byte)8);
            sqrKeywords.add("goto", (byte)8);
            sqrKeywords.add("graphic", (byte)8);
            sqrKeywords.add("if", (byte)8);
            sqrKeywords.add("last-page", (byte)8);
            sqrKeywords.add("let", (byte)8);
            sqrKeywords.add("lookup", (byte)8);
            sqrKeywords.add("lowercase", (byte)8);
            sqrKeywords.add("money-symbol", (byte)8);
            sqrKeywords.add("move", (byte)8);
            sqrKeywords.add("multiply", (byte)8);
            sqrKeywords.add("new-page", (byte)8);
            sqrKeywords.add("new-report", (byte)8);
            sqrKeywords.add("next-column", (byte)8);
            sqrKeywords.add("next-listing", (byte)8);
            sqrKeywords.add("no-formfeed", (byte)8);
            sqrKeywords.add("open", (byte)8);
            sqrKeywords.add("page-number", (byte)8);
            sqrKeywords.add("page-size", (byte)8);
            sqrKeywords.add("position", (byte)8);
            sqrKeywords.add("print", (byte)8);
            sqrKeywords.add("print-bar-code", (byte)8);
            sqrKeywords.add("print-chart", (byte)8);
            sqrKeywords.add("print-direct", (byte)8);
            sqrKeywords.add("print-image", (byte)8);
            sqrKeywords.add("printer-deinit", (byte)8);
            sqrKeywords.add("printer-init", (byte)8);
            sqrKeywords.add("put", (byte)8);
            sqrKeywords.add("read", (byte)8);
            sqrKeywords.add("rollback", (byte)8);
            sqrKeywords.add("show", (byte)8);
            sqrKeywords.add("stop", (byte)8);
            sqrKeywords.add("string", (byte)8);
            sqrKeywords.add("subtract", (byte)8);
            sqrKeywords.add("unstring", (byte)8);
            sqrKeywords.add("uppercase", (byte)8);
            sqrKeywords.add("use", (byte)8);
            sqrKeywords.add("use-column", (byte)8);
            sqrKeywords.add("use-printer-type", (byte)8);
            sqrKeywords.add("use-procedure", (byte)8);
            sqrKeywords.add("use-report", (byte)8);
            sqrKeywords.add("use-report", (byte)8);
            sqrKeywords.add("while", (byte)8);
            sqrKeywords.add("write", (byte)8);
            sqrKeywords.add("from", (byte)8);
            sqrKeywords.add("where", (byte)8);
            sqrKeywords.add("order", (byte)8);
            sqrKeywords.add("by", (byte)8);
            sqrKeywords.add("in", (byte)8);
            sqrKeywords.add("to", (byte)8);
            sqrKeywords.add("between", (byte)8);
            sqrKeywords.add("and", (byte)8);
            sqrKeywords.add("or", (byte)8);
            sqrKeywords.add("substr", (byte)8);
            sqrKeywords.add("instr", (byte)8);
            sqrKeywords.add("len", (byte)8);
        }
        return sqrKeywords;
    }

    private boolean doKeyword(Segment line, int i, char c) {
        int i1 = i + 1;
        int len = i - this.lastKeyword;
        byte id = this.keywords.lookup(line, this.lastKeyword, len);
        if (id != 0) {
            if (this.lastKeyword != this.lastOffset) {
                this.addToken(this.lastKeyword - this.lastOffset, (byte)0);
            }
            this.addToken(len, id);
            this.lastOffset = i;
        }
        this.lastKeyword = i1;
        return false;
    }
}

