/*
 * Decompiled with CFR 0.152.
 */
package jehep.syntax;

import javax.swing.text.Segment;
import jehep.syntax.KeywordMap;
import jehep.syntax.TokenMarker;

public class PascalTokenMarker
extends TokenMarker {
    public static final String METHOD_DELIMITERS = " \t~!%^*()-+=|\\#/{}[]:;\"'<>,.?";
    private static KeywordMap pascalKeywords;
    private KeywordMap keywords = PascalTokenMarker.getKeywords();
    private int lastOffset;
    private int lastKeyword;
    private int lastWhitespace;

    @Override
    public byte markTokensImpl(byte token, Segment line, int lineIndex) {
        int offset;
        char[] array = line.array;
        this.lastOffset = offset = line.offset;
        this.lastKeyword = offset;
        this.lastWhitespace = offset - 1;
        int length = line.count + offset;
        boolean backslash = false;
        block17: for (int i = offset; i < length; ++i) {
            int i1 = i + 1;
            char c = array[i];
            if (c == '\\') {
                backslash = !backslash;
                continue;
            }
            switch (token) {
                case 0: {
                    block6 : switch (c) {
                        case '(': {
                            if (backslash) {
                                this.doKeyword(line, i, c);
                                backslash = false;
                                break;
                            }
                            boolean k = this.doKeyword(line, i, c);
                            if (length - i > 1) {
                                switch (array[i1]) {
                                    case '*': {
                                        this.addToken(i - this.lastOffset, token);
                                        token = (byte)2;
                                        this.lastOffset = this.lastKeyword = i;
                                        break block6;
                                    }
                                }
                            }
                            if (k) break;
                            this.addToken(this.lastWhitespace - this.lastOffset + 1, token);
                            this.addToken(i - this.lastWhitespace - 1, (byte)11);
                            this.addToken(1, (byte)0);
                            token = 0;
                            this.lastOffset = this.lastKeyword = i1;
                            this.lastWhitespace = i;
                            break;
                        }
                        case '{': {
                            backslash = false;
                            this.doKeyword(line, i, c);
                            this.addToken(i - this.lastOffset, token);
                            token = 1;
                            this.lastOffset = this.lastKeyword = i1;
                            break;
                        }
                        case '\'': {
                            this.doKeyword(line, i, c);
                            if (backslash) {
                                backslash = false;
                                break;
                            }
                            this.addToken(i - this.lastOffset, token);
                            token = (byte)3;
                            this.lastOffset = this.lastKeyword = i;
                            break;
                        }
                        default: {
                            backslash = false;
                            if (!Character.isLetterOrDigit(c) && c != '_' && c != '{' && c != '}') {
                                this.doKeyword(line, i, c);
                            }
                            if (METHOD_DELIMITERS.indexOf(c) == -1) continue block17;
                            this.lastWhitespace = i;
                            break;
                        }
                    }
                    continue block17;
                }
                case 1: {
                    backslash = false;
                    if (c != '}') continue block17;
                    this.addToken(i + 1 - this.lastOffset, token);
                    token = 0;
                    this.lastOffset = this.lastKeyword = i;
                    this.lastWhitespace = i;
                    continue block17;
                }
                case 2: {
                    backslash = false;
                    if (c != '*' || length - i <= 1 || array[i1] != ')') continue block17;
                    this.addToken(++i + 1 - this.lastOffset, token);
                    token = 0;
                    this.lastOffset = this.lastKeyword = i + 1;
                    this.lastWhitespace = i;
                    continue block17;
                }
                case 3: {
                    if (backslash) {
                        backslash = false;
                        continue block17;
                    }
                    if (c != '\'') continue block17;
                    this.addToken(i1 - this.lastOffset, token);
                    token = 0;
                    this.lastOffset = this.lastKeyword = i1;
                    this.lastWhitespace = i;
                    continue block17;
                }
                default: {
                    throw new InternalError("Invalid state: " + token);
                }
            }
        }
        if (token == 0) {
            this.doKeyword(line, length, '\u0000');
        }
        switch (token) {
            case 3: {
                this.addToken(length - this.lastOffset, (byte)10);
                token = 0;
                break;
            }
            default: {
                this.addToken(length - this.lastOffset, token);
            }
        }
        return token;
    }

    public static KeywordMap getKeywords() {
        if (pascalKeywords == null) {
            pascalKeywords = new KeywordMap(false);
            pascalKeywords.add("absolute", (byte)6);
            pascalKeywords.add("and", (byte)9);
            pascalKeywords.add("array", (byte)8);
            pascalKeywords.add("asm", (byte)6);
            pascalKeywords.add("begin", (byte)6);
            pascalKeywords.add("case", (byte)6);
            pascalKeywords.add("const", (byte)6);
            pascalKeywords.add("constructor", (byte)6);
            pascalKeywords.add("destructor", (byte)6);
            pascalKeywords.add("div", (byte)9);
            pascalKeywords.add("do", (byte)6);
            pascalKeywords.add("downto", (byte)6);
            pascalKeywords.add("else", (byte)6);
            pascalKeywords.add("end", (byte)6);
            pascalKeywords.add("external", (byte)6);
            pascalKeywords.add("file", (byte)6);
            pascalKeywords.add("for", (byte)6);
            pascalKeywords.add("forward", (byte)6);
            pascalKeywords.add("function", (byte)6);
            pascalKeywords.add("goto", (byte)6);
            pascalKeywords.add("if", (byte)6);
            pascalKeywords.add("implementation", (byte)7);
            pascalKeywords.add("in", (byte)6);
            pascalKeywords.add("inherited", (byte)6);
            pascalKeywords.add("inline", (byte)6);
            pascalKeywords.add("interface", (byte)6);
            pascalKeywords.add("interrupt", (byte)6);
            pascalKeywords.add("label", (byte)7);
            pascalKeywords.add("library", (byte)7);
            pascalKeywords.add("mod", (byte)9);
            pascalKeywords.add("nil", (byte)5);
            pascalKeywords.add("not", (byte)9);
            pascalKeywords.add("object", (byte)8);
            pascalKeywords.add("of", (byte)6);
            pascalKeywords.add("on", (byte)6);
            pascalKeywords.add("packed", (byte)6);
            pascalKeywords.add("private", (byte)6);
            pascalKeywords.add("procedure", (byte)6);
            pascalKeywords.add("program", (byte)6);
            pascalKeywords.add("public", (byte)6);
            pascalKeywords.add("record", (byte)8);
            pascalKeywords.add("repeat", (byte)6);
            pascalKeywords.add("set", (byte)8);
            pascalKeywords.add("shl", (byte)6);
            pascalKeywords.add("shr", (byte)6);
            pascalKeywords.add("string", (byte)8);
            pascalKeywords.add("then", (byte)6);
            pascalKeywords.add("to", (byte)6);
            pascalKeywords.add("type", (byte)6);
            pascalKeywords.add("unit", (byte)6);
            pascalKeywords.add("until", (byte)6);
            pascalKeywords.add("uses", (byte)7);
            pascalKeywords.add("var", (byte)6);
            pascalKeywords.add("virtual", (byte)6);
            pascalKeywords.add("while", (byte)6);
            pascalKeywords.add("with", (byte)6);
            pascalKeywords.add("xor", (byte)9);
            pascalKeywords.add("true", (byte)5);
            pascalKeywords.add("false", (byte)5);
            pascalKeywords.add("maxint", (byte)5);
            pascalKeywords.add("maxlongint", (byte)5);
            pascalKeywords.add("boolean", (byte)8);
            pascalKeywords.add("byte", (byte)8);
            pascalKeywords.add("char", (byte)8);
            pascalKeywords.add("extended", (byte)8);
            pascalKeywords.add("longint", (byte)8);
            pascalKeywords.add("integer", (byte)8);
        }
        return pascalKeywords;
    }

    private boolean doKeyword(Segment line, int i, char c) {
        int i1 = i + 1;
        int len = i - this.lastKeyword;
        byte id = this.keywords.lookup(line, this.lastKeyword, len);
        if (id != 0) {
            if (this.lastKeyword != this.lastOffset) {
                this.addToken(this.lastKeyword - this.lastOffset, (byte)0);
            }
            this.addToken(len, id);
            this.lastOffset = i;
            this.lastKeyword = i1;
            this.lastWhitespace = i;
            return true;
        }
        this.lastKeyword = i1;
        return false;
    }
}

