/*
 * Decompiled with CFR 0.152.
 */
package jehep.syntax;

import javax.swing.text.Segment;
import jehep.syntax.KeywordMap;
import jehep.syntax.TokenMarker;

public class CPPTokenMarker
extends TokenMarker {
    public static final String METHOD_DELIMITERS = " \t~!%^*()-+=|\\#/{}[]:;\"'<>,.?@";
    private static KeywordMap CPPKeywords;
    protected boolean cpp;
    protected boolean javadoc;
    protected KeywordMap keywords;
    protected int lastOffset;
    protected int lastKeyword;
    protected int lastWhitespace;

    public CPPTokenMarker() {
        this(true, false, CPPTokenMarker.getKeywords());
        this.cpp = false;
        this.javadoc = false;
    }

    public CPPTokenMarker(boolean cpp, boolean javadoc, KeywordMap keywords) {
        this.cpp = cpp;
        this.javadoc = javadoc;
        this.keywords = keywords;
        cpp = false;
        javadoc = false;
    }

    @Override
    public byte markTokensImpl(byte token, Segment line, int lineIndex) {
        int offset;
        char[] array = line.array;
        this.lastOffset = offset = line.offset;
        this.lastKeyword = offset;
        int length = line.count + offset;
        boolean backslash = false;
        block21: for (int i = offset; i < length; ++i) {
            int i1 = i + 1;
            char c = array[i];
            if (c == '\\') {
                backslash = !backslash;
                continue;
            }
            switch (token) {
                case 0: {
                    switch (c) {
                        case '#': {
                            if (backslash) {
                                backslash = false;
                                break;
                            }
                            if (!this.cpp) continue block21;
                            if (this.doKeyword(line, i, c)) break;
                            this.addToken(i - this.lastOffset, token);
                            this.addToken(length - i, (byte)7);
                            this.lastOffset = this.lastKeyword = length;
                            break block21;
                        }
                        case '\"': {
                            this.doKeyword(line, i, c);
                            if (backslash) {
                                backslash = false;
                                break;
                            }
                            this.addToken(i - this.lastOffset, token);
                            token = (byte)3;
                            this.lastOffset = this.lastKeyword = i;
                            break;
                        }
                        case '\'': {
                            this.doKeyword(line, i, c);
                            if (backslash) {
                                backslash = false;
                                break;
                            }
                            this.addToken(i - this.lastOffset, token);
                            token = (byte)4;
                            this.lastOffset = this.lastKeyword = i;
                            break;
                        }
                        case ':': {
                            if (this.lastKeyword == offset) {
                                if (this.doKeyword(line, i, c)) break;
                                backslash = false;
                                this.addToken(i1 - this.lastOffset, (byte)5);
                                this.lastOffset = this.lastKeyword = i1;
                                break;
                            }
                            if (!this.doKeyword(line, i, c)) continue block21;
                            break;
                        }
                        case '/': {
                            backslash = false;
                            this.doKeyword(line, i, c);
                            if (length - i <= 1) continue block21;
                            switch (array[i1]) {
                                case '*': {
                                    this.addToken(i - this.lastOffset, token);
                                    this.lastOffset = this.lastKeyword = i;
                                    if (this.javadoc && length - i > 2 && array[i + 2] == '*') {
                                        token = (byte)2;
                                        break;
                                    }
                                    token = 1;
                                    break;
                                }
                                case '/': {
                                    this.addToken(i - this.lastOffset, token);
                                    this.addToken(length - i, (byte)1);
                                    this.lastOffset = this.lastKeyword = length;
                                    break block21;
                                }
                            }
                            continue block21;
                        }
                        default: {
                            backslash = false;
                            if (!Character.isLetterOrDigit(c) && c != '_') {
                                this.doKeyword(line, i, c);
                            }
                            if (METHOD_DELIMITERS.indexOf(c) == -1) continue block21;
                            this.lastWhitespace = i;
                            break;
                        }
                    }
                    continue block21;
                }
                case 1: 
                case 2: {
                    backslash = false;
                    if (c != '*' || length - i <= 1 || array[i1] != '/') continue block21;
                    this.addToken(++i + 1 - this.lastOffset, token);
                    token = 0;
                    this.lastOffset = this.lastKeyword = i + 1;
                    continue block21;
                }
                case 3: {
                    if (backslash) {
                        backslash = false;
                        continue block21;
                    }
                    if (c != '\"') continue block21;
                    this.addToken(i1 - this.lastOffset, token);
                    token = 0;
                    this.lastOffset = this.lastKeyword = i1;
                    continue block21;
                }
                case 4: {
                    if (backslash) {
                        backslash = false;
                        continue block21;
                    }
                    if (c != '\'') continue block21;
                    this.addToken(i1 - this.lastOffset, (byte)3);
                    token = 0;
                    this.lastOffset = this.lastKeyword = i1;
                    continue block21;
                }
                default: {
                    throw new InternalError("Invalid state: " + token);
                }
            }
        }
        if (token == 0) {
            this.doKeyword(line, length, '\u0000');
        }
        switch (token) {
            case 3: 
            case 4: {
                this.addToken(length - this.lastOffset, (byte)10);
                token = 0;
                break;
            }
            case 7: {
                this.addToken(length - this.lastOffset, token);
                if (!backslash) {
                    token = 0;
                }
            }
            default: {
                this.addToken(length - this.lastOffset, token);
            }
        }
        return token;
    }

    public static KeywordMap getKeywords() {
        if (CPPKeywords == null) {
            CPPKeywords = new KeywordMap(false);
            CPPKeywords.add("(", (byte)8);
            CPPKeywords.add(") ", (byte)8);
            CPPKeywords.add("* ", (byte)8);
            CPPKeywords.add("+ ", (byte)8);
            CPPKeywords.add(", ", (byte)8);
            CPPKeywords.add("- ", (byte)8);
            CPPKeywords.add(". ", (byte)8);
            CPPKeywords.add("/ ", (byte)8);
            CPPKeywords.add(": ", (byte)8);
            CPPKeywords.add("; ", (byte)8);
            CPPKeywords.add("< ", (byte)8);
            CPPKeywords.add("<=", (byte)8);
            CPPKeywords.add("<>", (byte)8);
            CPPKeywords.add("= ", (byte)8);
            CPPKeywords.add(">", (byte)8);
            CPPKeywords.add(">=", (byte)8);
            CPPKeywords.add("?", (byte)8);
            CPPKeywords.add("->", (byte)6);
            CPPKeywords.add("[", (byte)8);
            CPPKeywords.add("]", (byte)8);
            CPPKeywords.add("<<", (byte)8);
            CPPKeywords.add("{", (byte)8);
            CPPKeywords.add("} ", (byte)8);
            CPPKeywords.add("and", (byte)8);
            CPPKeywords.add("and_eq", (byte)8);
            CPPKeywords.add("asm", (byte)7);
            CPPKeywords.add("auto", (byte)6);
            CPPKeywords.add("bitand", (byte)8);
            CPPKeywords.add("bitor", (byte)8);
            CPPKeywords.add("bool", (byte)8);
            CPPKeywords.add("break", (byte)6);
            CPPKeywords.add("case", (byte)6);
            CPPKeywords.add("catch", (byte)6);
            CPPKeywords.add("char", (byte)8);
            CPPKeywords.add("class", (byte)8);
            CPPKeywords.add("compl", (byte)8);
            CPPKeywords.add("const", (byte)6);
            CPPKeywords.add("const_cast", (byte)8);
            CPPKeywords.add("continue", (byte)6);
            CPPKeywords.add("default", (byte)6);
            CPPKeywords.add("delete", (byte)6);
            CPPKeywords.add("cout", (byte)6);
            CPPKeywords.add("endl", (byte)6);
            CPPKeywords.add("std", (byte)6);
            CPPKeywords.add("ofstream", (byte)6);
            CPPKeywords.add("ifstream", (byte)6);
            CPPKeywords.add("fopen", (byte)6);
            CPPKeywords.add("fclose", (byte)6);
            CPPKeywords.add("close", (byte)6);
            CPPKeywords.add("sprintf", (byte)6);
            CPPKeywords.add("printf", (byte)6);
            CPPKeywords.add("strcmp", (byte)6);
            CPPKeywords.add("getline", (byte)6);
            CPPKeywords.add("ignore", (byte)6);
            CPPKeywords.add("get", (byte)6);
            CPPKeywords.add("read", (byte)6);
            CPPKeywords.add("peek", (byte)6);
            CPPKeywords.add("string", (byte)8);
            CPPKeywords.add("vector", (byte)8);
            CPPKeywords.add("do", (byte)6);
            CPPKeywords.add("double", (byte)8);
            CPPKeywords.add("dynamic_cast", (byte)8);
            CPPKeywords.add("else", (byte)6);
            CPPKeywords.add("enum", (byte)8);
            CPPKeywords.add("explicit", (byte)6);
            CPPKeywords.add("export", (byte)7);
            CPPKeywords.add("extern", (byte)7);
            CPPKeywords.add("false", (byte)4);
            CPPKeywords.add("float", (byte)8);
            CPPKeywords.add("Int_t", (byte)8);
            CPPKeywords.add("for", (byte)6);
            CPPKeywords.add("friend", (byte)6);
            CPPKeywords.add("goto", (byte)6);
            CPPKeywords.add("if", (byte)6);
            CPPKeywords.add("inline", (byte)6);
            CPPKeywords.add("int", (byte)8);
            CPPKeywords.add("long", (byte)8);
            CPPKeywords.add("mutable", (byte)8);
            CPPKeywords.add("namespace", (byte)8);
            CPPKeywords.add("not", (byte)8);
            CPPKeywords.add("not_eq", (byte)8);
            CPPKeywords.add("operator", (byte)8);
            CPPKeywords.add("or", (byte)8);
            CPPKeywords.add("or_eq", (byte)8);
            CPPKeywords.add("private", (byte)6);
            CPPKeywords.add("protected", (byte)6);
            CPPKeywords.add("public", (byte)6);
            CPPKeywords.add("register", (byte)6);
            CPPKeywords.add("reinterpret_cast", (byte)8);
            CPPKeywords.add("return", (byte)6);
            CPPKeywords.add("short", (byte)8);
            CPPKeywords.add("signed", (byte)8);
            CPPKeywords.add("sizeof", (byte)6);
            CPPKeywords.add("static", (byte)6);
            CPPKeywords.add("static_cast", (byte)8);
            CPPKeywords.add("struct", (byte)8);
            CPPKeywords.add("switch", (byte)6);
            CPPKeywords.add("template", (byte)8);
            CPPKeywords.add("this", (byte)4);
            CPPKeywords.add("throw", (byte)6);
            CPPKeywords.add("true", (byte)4);
            CPPKeywords.add("try", (byte)6);
            CPPKeywords.add("typedef", (byte)8);
            CPPKeywords.add("typeid", (byte)8);
            CPPKeywords.add("typename", (byte)8);
            CPPKeywords.add("union", (byte)8);
            CPPKeywords.add("unsigned", (byte)8);
            CPPKeywords.add("using", (byte)7);
            CPPKeywords.add("virtual", (byte)6);
            CPPKeywords.add("void", (byte)6);
            CPPKeywords.add("volatile", (byte)6);
            CPPKeywords.add("wchar_t", (byte)8);
            CPPKeywords.add("while", (byte)6);
            CPPKeywords.add("xor", (byte)8);
            CPPKeywords.add("xor_eq", (byte)8);
            CPPKeywords.add("NULL", (byte)4);
            CPPKeywords.add("new", (byte)11);
            CPPKeywords.add("#include", (byte)9);
            CPPKeywords.add("#define", (byte)11);
            CPPKeywords.add("#undef", (byte)11);
            CPPKeywords.add("#ifndef", (byte)11);
            CPPKeywords.add("#endif", (byte)11);
            CPPKeywords.add("#else", (byte)11);
            CPPKeywords.add("#if", (byte)11);
            CPPKeywords.add("#elif", (byte)11);
            CPPKeywords.add("#efined", (byte)11);
            CPPKeywords.add("#line", (byte)11);
            CPPKeywords.add("#error", (byte)11);
            CPPKeywords.add("#pragma", (byte)11);
        }
        return CPPKeywords;
    }

    protected boolean doKeyword(Segment line, int i, char c) {
        int i1 = i + 1;
        int len = i - this.lastKeyword;
        byte id = this.keywords.lookup(line, this.lastKeyword, len);
        if (id != 0) {
            if (this.lastKeyword != this.lastOffset) {
                this.addToken(this.lastKeyword - this.lastOffset, (byte)0);
            }
            this.addToken(len, id);
            this.lastOffset = i;
            this.lastKeyword = i1;
            this.lastWhitespace = i;
            return true;
        }
        this.lastKeyword = i1;
        return false;
    }
}

