/*
 * Decompiled with CFR 0.152.
 */
package jehep.sexam;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import javax.swing.plaf.basic.BasicTextFieldUI;
import javax.swing.text.JTextComponent;

public class HintTextFieldUI
extends BasicTextFieldUI
implements FocusListener {
    private String hint;
    private boolean hideOnFocus;
    private Color color;

    public Color getColor() {
        return this.color;
    }

    public void setColor(Color color) {
        this.color = color;
        this.repaint();
    }

    private void repaint() {
        if (this.getComponent() != null) {
            this.getComponent().repaint();
        }
    }

    public boolean isHideOnFocus() {
        return this.hideOnFocus;
    }

    public void setHideOnFocus(boolean hideOnFocus) {
        this.hideOnFocus = hideOnFocus;
        this.repaint();
    }

    public String getHint() {
        return this.hint;
    }

    public void setHint(String hint) {
        this.hint = hint;
        this.repaint();
    }

    public HintTextFieldUI(String hint) {
        this(hint, false);
    }

    public HintTextFieldUI(String hint, boolean hideOnFocus) {
        this(hint, hideOnFocus, null);
    }

    public HintTextFieldUI(String hint, boolean hideOnFocus, Color color) {
        this.hint = hint;
        this.hideOnFocus = hideOnFocus;
        this.color = color;
    }

    @Override
    protected void paintSafely(Graphics g) {
        super.paintSafely(g);
        JTextComponent comp = this.getComponent();
        if (!(this.hint == null || comp.getText().length() != 0 || this.hideOnFocus && comp.hasFocus())) {
            if (this.color != null) {
                g.setColor(this.color);
            } else {
                g.setColor(comp.getForeground().brighter().brighter().brighter());
            }
            int padding = (comp.getHeight() - comp.getFont().getSize()) / 2;
            g.drawString(this.hint, 2, comp.getHeight() - padding - 1);
        }
    }

    @Override
    public void focusGained(FocusEvent e) {
        if (this.hideOnFocus) {
            this.repaint();
        }
    }

    @Override
    public void focusLost(FocusEvent e) {
        if (this.hideOnFocus) {
            this.repaint();
        }
    }

    @Override
    protected void installListeners() {
        super.installListeners();
        this.getComponent().addFocusListener(this);
    }

    @Override
    protected void uninstallListeners() {
        super.uninstallListeners();
        this.getComponent().removeFocusListener(this);
    }
}

